/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.datatypes.CompoundDatatype;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.CompoundPropertyMaker;
import org.apache.fop.fo.properties.EnumProperty;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.Property;

public class CondLengthProperty
extends Property
implements CompoundDatatype {
    private Property length;
    private EnumProperty conditionality;

    public void setComponent(int cmpId, Property cmpnValue, boolean bIsDefault) {
        if (cmpId == 2048) {
            this.length = cmpnValue;
        } else if (cmpId == 1024) {
            this.conditionality = (EnumProperty)cmpnValue;
        }
    }

    public Property getComponent(int cmpId) {
        if (cmpId == 2048) {
            return this.length;
        }
        if (cmpId == 1024) {
            return this.conditionality;
        }
        return null;
    }

    public Property getConditionality() {
        return this.conditionality;
    }

    public Property getLengthComponent() {
        return this.length;
    }

    public boolean isDiscard() {
        return this.conditionality.getEnum() == 32;
    }

    public int getLengthValue() {
        return this.length.getLength().getValue();
    }

    public int getLengthValue(PercentBaseContext context) {
        return this.length.getLength().getValue(context);
    }

    public String toString() {
        return "CondLength[" + this.length.getObject().toString() + ", " + (this.isDiscard() ? this.conditionality.toString().toLowerCase() : this.conditionality.toString()) + "]";
    }

    public CondLengthProperty getCondLength() {
        return this;
    }

    public Length getLength() {
        return this.length.getLength();
    }

    public Object getObject() {
        return this;
    }

    public static class Maker
    extends CompoundPropertyMaker {
        public Maker(int propId) {
            super(propId);
        }

        public Property makeNewProperty() {
            return new CondLengthProperty();
        }

        public Property convertProperty(Property p, PropertyList propertyList, FObj fo) throws PropertyException {
            if (p instanceof KeepProperty) {
                return p;
            }
            return super.convertProperty(p, propertyList, fo);
        }
    }
}

