/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.fonts.FontTriplet;

public class FontInfo {
    private static final FontTriplet[] TRIPLETS_TYPE = new FontTriplet[1];
    protected static Log log = LogFactory.getLog((Class)FontInfo.class);
    private Map usedFonts;
    private Map triplets;
    private Map tripletPriorities;
    private Map fonts;
    private Collection loggedFontKeys;
    private Map fontInstanceCache = new HashMap();

    public FontInfo() {
        this.triplets = new HashMap();
        this.tripletPriorities = new HashMap();
        this.fonts = new HashMap();
        this.usedFonts = new HashMap();
    }

    public boolean isSetupValid() {
        this.tripletPriorities = null;
        return this.triplets.containsKey(Font.DEFAULT_FONT);
    }

    public void addFontProperties(String name, String family, String style, int weight) {
        this.addFontProperties(name, FontInfo.createFontKey(family, style, weight));
    }

    public void addFontProperties(String name, FontTriplet triplet) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering: " + triplet + " under " + name));
        }
        String oldName = (String)this.triplets.get(triplet);
        int newPriority = triplet.getPriority();
        if (oldName != null) {
            int oldPriority = (Integer)this.tripletPriorities.get(triplet);
            if (oldPriority < newPriority) {
                this.logDuplicateFont(triplet, false, oldName, oldPriority, name, newPriority);
                return;
            }
            this.logDuplicateFont(triplet, true, oldName, oldPriority, name, newPriority);
        }
        this.triplets.put(triplet, name);
        this.tripletPriorities.put(triplet, new Integer(newPriority));
    }

    private void logDuplicateFont(FontTriplet triplet, boolean replacing, String oldKey, int oldPriority, String newKey, int newPriority) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(triplet + (replacing ? ": Replacing " : ": Not replacing ") + ((FontMetrics)this.fonts.get(this.triplets.get(triplet))).getFullName() + " (" + oldPriority + ") by " + ((FontMetrics)this.fonts.get(newKey)).getFullName() + " (" + newPriority + ")"));
        }
    }

    public void addMetrics(String name, FontMetrics metrics) {
        this.fonts.put(name, metrics);
    }

    private FontTriplet fontLookup(String family, String style, int weight, boolean substFont) {
        FontTriplet startKey;
        FontTriplet key;
        String f;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Font lookup: " + family + " " + style + " " + weight));
        }
        if ((f = this.getInternalFontKey(key = (startKey = FontInfo.createFontKey(family, style, weight)))) == null) {
            key = this.doAdjustedLookup(family, style, weight, startKey, substFont);
        }
        if (key != null) {
            if (key != startKey) {
                this.notifyFontReplacement(startKey, key);
            }
            return key;
        }
        return null;
    }

    private FontTriplet doAdjustedLookup(String family, String style, int weight, FontTriplet startKey, boolean substFont) {
        FontTriplet key;
        String f;
        if (!family.equals(startKey.getName()) && (f = this.getInternalFontKey(key = FontInfo.createFontKey(family, style, weight))) != null) {
            return key;
        }
        key = this.findAdjustWeight(family, style, weight);
        f = this.getInternalFontKey(key);
        if (!substFont && f == null) {
            return null;
        }
        if (f == null && style != "normal") {
            key = FontInfo.createFontKey(family, "normal", weight);
            f = this.getInternalFontKey(key);
        }
        if (f == null && weight != 400) {
            int diffWeight = (400 - weight) / 100;
            int direction = diffWeight > 0 ? 1 : -1;
            int tryWeight = weight;
            while (tryWeight != 400) {
                tryWeight += 100 * direction;
                key = FontInfo.createFontKey(family, style, weight);
                f = this.getInternalFontKey(key);
                if (f == null) {
                    key = FontInfo.createFontKey(family, "normal", weight);
                    f = this.getInternalFontKey(key);
                }
                if (f == null) continue;
            }
        }
        if (f == null) {
            return this.doAdjustedLookup("any", style, weight, startKey, false);
        }
        if (f == null) {
            key = Font.DEFAULT_FONT;
            f = this.getInternalFontKey(key);
        }
        if (f != null) {
            return key;
        }
        return null;
    }

    public void useFont(String internalName) {
        this.usedFonts.put(internalName, this.fonts.get(internalName));
    }

    public Font getFontInstance(FontTriplet triplet, int fontSize) {
        Integer size;
        Font font;
        HashMap<Integer, Font> sizes = (HashMap<Integer, Font>)this.fontInstanceCache.get(triplet);
        if (sizes == null) {
            sizes = new HashMap<Integer, Font>();
            this.fontInstanceCache.put(triplet, sizes);
        }
        if ((font = (Font)sizes.get(size = new Integer(fontSize))) == null) {
            String fname = this.getInternalFontKey(triplet);
            this.useFont(fname);
            FontMetrics metrics = this.getMetricsFor(fname);
            font = new Font(fname, triplet, metrics, fontSize);
            sizes.put(size, font);
        }
        return font;
    }

    public FontTriplet fontLookup(String family, String style, int weight) {
        return this.fontLookup(family, style, weight, true);
    }

    public FontTriplet[] fontLookup(String[] families, String style, int weight) {
        if (families.length == 0) {
            throw new IllegalArgumentException("Specify at least one font family");
        }
        ArrayList<FontTriplet> tmpTriplets = new ArrayList<FontTriplet>();
        int c = families.length;
        for (int i = 0; i < c; ++i) {
            FontTriplet triplet = this.fontLookup(families[i], style, weight, i >= families.length - 1);
            if (triplet == null) continue;
            tmpTriplets.add(triplet);
        }
        if (tmpTriplets.size() != 0) {
            return tmpTriplets.toArray(TRIPLETS_TYPE);
        }
        StringBuffer sb = new StringBuffer();
        int c2 = families.length;
        for (int i = 0; i < c2; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(families[i]);
        }
        throw new IllegalStateException("fontLookup must return an array with at least one FontTriplet on the last call. Lookup: " + sb.toString());
    }

    private void notifyFontReplacement(FontTriplet replacedKey, FontTriplet newKey) {
        if (this.loggedFontKeys == null) {
            this.loggedFontKeys = new HashSet();
        }
        if (!this.loggedFontKeys.contains(replacedKey)) {
            this.loggedFontKeys.add(replacedKey);
            log.warn((Object)("Font '" + replacedKey + "' not found. " + "Substituting with '" + newKey + "'."));
        }
    }

    public FontTriplet findAdjustWeight(String family, String style, int weight) {
        FontTriplet key = null;
        String f = null;
        int newWeight = weight;
        if (newWeight < 400) {
            while (f == null && newWeight > 100) {
                key = FontInfo.createFontKey(family, style, newWeight -= 100);
                f = this.getInternalFontKey(key);
            }
            newWeight = weight;
            while (f == null && newWeight < 400) {
                key = FontInfo.createFontKey(family, style, newWeight += 100);
                f = this.getInternalFontKey(key);
            }
        } else if (newWeight == 500) {
            key = FontInfo.createFontKey(family, style, 400);
            f = this.getInternalFontKey(key);
        } else if (newWeight > 500) {
            while (f == null && newWeight < 1000) {
                key = FontInfo.createFontKey(family, style, newWeight += 100);
                f = this.getInternalFontKey(key);
            }
            newWeight = weight;
            while (f == null && newWeight > 400) {
                key = FontInfo.createFontKey(family, style, newWeight -= 100);
                f = this.getInternalFontKey(key);
            }
        }
        if (f == null && weight != 400) {
            key = FontInfo.createFontKey(family, style, 400);
            f = this.getInternalFontKey(key);
        }
        if (f != null) {
            return key;
        }
        return null;
    }

    public boolean hasFont(String family, String style, int weight) {
        FontTriplet key = FontInfo.createFontKey(family, style, weight);
        return this.triplets.containsKey(key);
    }

    public String getInternalFontKey(FontTriplet triplet) {
        return (String)this.triplets.get(triplet);
    }

    public static FontTriplet createFontKey(String family, String style, int weight) {
        return new FontTriplet(family, style, weight);
    }

    public Map getFonts() {
        return Collections.unmodifiableMap(this.fonts);
    }

    public Map getFontTriplets() {
        return Collections.unmodifiableMap(this.triplets);
    }

    public Map getUsedFonts() {
        return this.usedFonts;
    }

    public FontMetrics getMetricsFor(String fontName) {
        FontMetrics metrics = (FontMetrics)this.fonts.get(fontName);
        this.usedFonts.put(fontName, metrics);
        return metrics;
    }

    public FontTriplet getTripletFor(String fontName) {
        ArrayList foundTriplets = new ArrayList();
        Iterator iter = this.triplets.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry tripletEntry = iter.next();
            if (!fontName.equals((String)tripletEntry.getValue())) continue;
            foundTriplets.add(tripletEntry.getKey());
        }
        if (foundTriplets.size() > 0) {
            Collections.sort(foundTriplets);
            return (FontTriplet)foundTriplets.get(0);
        }
        return null;
    }

    public String getFontStyleFor(String fontName) {
        FontTriplet triplet = this.getTripletFor(fontName);
        if (triplet != null) {
            return triplet.getStyle();
        }
        return "";
    }

    public int getFontWeightFor(String fontName) {
        FontTriplet triplet = this.getTripletFor(fontName);
        if (triplet != null) {
            return triplet.getWeight();
        }
        return 0;
    }

    public void dumpAllTripletsToSystemOut() {
        TreeSet<String> entries = new TreeSet<String>();
        Iterator<Object> iter = this.triplets.keySet().iterator();
        while (iter.hasNext()) {
            FontTriplet triplet = (FontTriplet)iter.next();
            String key = this.getInternalFontKey(triplet);
            FontMetrics metrics = this.getMetricsFor(key);
            entries.add(triplet.toString() + " -> " + key + " -> " + metrics.getFontName());
        }
        iter = entries.iterator();
        while (iter.hasNext()) {
            System.out.println(iter.next());
        }
    }
}

