/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.fop.datatypes.URISpecification;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyMaker;
import org.apache.fop.util.CompareUtil;

public class URIProperty
extends Property {
    private URI resolvedURI;

    protected URIProperty(URI uri) {
        this.resolvedURI = uri;
    }

    private URIProperty(String uri, boolean resolve) {
        if (resolve && uri != null && !"".equals(uri)) {
            this.resolvedURI = URI.create(uri);
        } else {
            this.setSpecifiedValue(uri);
        }
    }

    public String getString() {
        if (this.resolvedURI == null) {
            return this.getSpecifiedValue();
        }
        return this.resolvedURI.toString();
    }

    public String toString() {
        return this.getString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + CompareUtil.getHashCode(this.getSpecifiedValue());
        result = 31 * result + CompareUtil.getHashCode(this.resolvedURI);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof URIProperty)) {
            return false;
        }
        URIProperty other = (URIProperty)obj;
        return CompareUtil.equal(this.getSpecifiedValue(), other.getSpecifiedValue()) && CompareUtil.equal(this.resolvedURI, other.resolvedURI);
    }

    public static class Maker
    extends PropertyMaker {
        public Maker(int propId) {
            super(propId);
        }

        public Property make(PropertyList propertyList, String value, FObj fo) throws PropertyException {
            URIProperty p = null;
            if (value.matches("(?s)^(url\\(('|\")?)?data:.*$")) {
                p = new URIProperty(value, false);
            } else {
                try {
                    URI specifiedURI = new URI(URISpecification.escapeURI(value));
                    URIProperty xmlBase = (URIProperty)propertyList.get(274, true, false);
                    if (xmlBase == null) {
                        if (this.propId == 274) {
                            p = new URIProperty(specifiedURI);
                            p.setSpecifiedValue(value);
                        } else {
                            p = new URIProperty(value, false);
                        }
                    } else {
                        p = new URIProperty(xmlBase.resolvedURI.resolve(specifiedURI));
                        p.setSpecifiedValue(value);
                    }
                }
                catch (URISyntaxException use) {
                    throw new PropertyException("Invalid URI specified");
                }
            }
            return p;
        }
    }
}

