/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.fonts;

public class CharacterSetOrientation {
    private int ascender;
    private int descender;
    private int capHeight;
    private int[] charsWidths = new int[256];
    private int xHeight;
    private int firstChar;
    private int lastChar;
    private int orientation = 0;

    public CharacterSetOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getAscender() {
        return this.ascender;
    }

    public int getCapHeight() {
        return this.capHeight;
    }

    public int getDescender() {
        return this.descender;
    }

    public int getFirstChar() {
        return this.firstChar;
    }

    public int getLastChar() {
        return this.lastChar;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int[] getWidths() {
        int[] arr = new int[this.getLastChar() - this.getFirstChar() + 1];
        System.arraycopy(this.charsWidths, this.getFirstChar(), arr, 0, this.getLastChar() - this.getFirstChar() + 1);
        return arr;
    }

    public int getXHeight() {
        return this.xHeight;
    }

    public int getWidth(int characterIndex) {
        if (characterIndex >= this.charsWidths.length) {
            throw new IllegalArgumentException("Invalid character index: " + characterIndex + ", maximum is " + (this.charsWidths.length - 1));
        }
        return this.charsWidths[characterIndex];
    }

    public void setAscender(int ascender) {
        this.ascender = ascender;
    }

    public void setCapHeight(int capHeight) {
        this.capHeight = capHeight;
    }

    public void setDescender(int descender) {
        this.descender = descender;
    }

    public void setFirstChar(int firstChar) {
        this.firstChar = firstChar;
    }

    public void setLastChar(int lastChar) {
        this.lastChar = lastChar;
    }

    public void setWidth(int character, int width) {
        if (character >= this.charsWidths.length) {
            int[] arr = new int[character - this.firstChar + 1];
            System.arraycopy(this.charsWidths, 0, arr, 0, this.charsWidths.length);
            this.charsWidths = arr;
        }
        this.charsWidths[character] = width;
    }

    public void setXHeight(int xHeight) {
        this.xHeight = xHeight;
    }
}

