/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockParent;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.BlockContainer;
import org.apache.fop.fo.flow.ListBlock;
import org.apache.fop.fo.flow.ListItem;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.properties.BreakPropertySet;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.SpaceProperty;
import org.apache.fop.layoutmgr.AbstractLayoutManager;
import org.apache.fop.layoutmgr.BlockLevelEventProducer;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BorderElement;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.KeepUtil;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.PaddingElement;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.RelSide;
import org.apache.fop.layoutmgr.SpaceElement;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.InlineLayoutManager;
import org.apache.fop.layoutmgr.inline.LineLayoutManager;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.util.BreakUtil;
import org.apache.fop.util.ListUtil;

public abstract class BlockStackingLayoutManager
extends AbstractLayoutManager
implements BlockLevelLayoutManager {
    private static Log log = LogFactory.getLog((Class)BlockStackingLayoutManager.class);
    protected BlockParent parentArea = null;
    protected int bpUnit = 0;
    protected int adjustedSpaceBefore = 0;
    protected int adjustedSpaceAfter = 0;
    protected List storedList = null;
    protected boolean breakBeforeServed = false;
    protected boolean firstVisibleMarkServed = false;
    protected int referenceIPD = 0;
    protected int startIndent = 0;
    protected int endIndent = 0;
    protected MinOptMax foSpaceBefore = null;
    protected MinOptMax foSpaceAfter = null;
    private Position auxiliaryPosition;
    private int contentAreaIPD = 0;

    public BlockStackingLayoutManager(FObj node) {
        super(node);
        this.setGeneratesBlockArea(true);
    }

    protected BlockParent getCurrentArea() {
        return this.parentArea;
    }

    protected void setCurrentArea(BlockParent parentArea) {
        this.parentArea = parentArea;
    }

    public void addBlockSpacing(double adjust, MinOptMax minoptmax) {
        int sp = TraitSetter.getEffectiveSpace(adjust, minoptmax);
        if (sp != 0) {
            Block spacer = new Block();
            spacer.setBPD(sp);
            this.parentLM.addChildArea(spacer);
        }
    }

    protected void addChildToArea(Area childArea, BlockParent parentArea) {
        if (!(childArea instanceof Block)) {
            // empty if block
        }
        parentArea.addBlock((Block)childArea);
        this.flush();
    }

    public void addChildArea(Area childArea) {
        this.addChildToArea(childArea, this.getCurrentArea());
    }

    protected void notifyEndOfLayout() {
        super.notifyEndOfLayout();
    }

    protected void flush() {
        if (this.getCurrentArea() != null) {
            this.parentLM.addChildArea(this.getCurrentArea());
        }
    }

    protected Position getAuxiliaryPosition() {
        if (this.auxiliaryPosition == null) {
            this.auxiliaryPosition = new NonLeafPosition(this, null);
        }
        return this.auxiliaryPosition;
    }

    protected int neededUnits(int len) {
        return (int)Math.ceil((float)len / (float)this.bpUnit);
    }

    protected int updateContentAreaIPDwithOverconstrainedAdjust() {
        int ipd = this.referenceIPD - (this.startIndent + this.endIndent);
        if (ipd < 0) {
            log.debug((Object)("Adjusting end-indent based on overconstrained geometry rules for " + this.fobj));
            BlockLevelEventProducer eventProducer = BlockLevelEventProducer.Provider.get(this.getFObj().getUserAgent().getEventBroadcaster());
            eventProducer.overconstrainedAdjustEndIndent(this, this.getFObj().getName(), ipd, this.getFObj().getLocator());
            this.endIndent += ipd;
            ipd = 0;
        }
        this.setContentAreaIPD(ipd);
        return ipd;
    }

    protected int updateContentAreaIPDwithOverconstrainedAdjust(int contentIPD) {
        int ipd = this.referenceIPD - (contentIPD + (this.startIndent + this.endIndent));
        if (ipd < 0) {
            log.debug((Object)("Adjusting end-indent based on overconstrained geometry rules for " + this.fobj));
            BlockLevelEventProducer eventProducer = BlockLevelEventProducer.Provider.get(this.getFObj().getUserAgent().getEventBroadcaster());
            eventProducer.overconstrainedAdjustEndIndent(this, this.getFObj().getName(), ipd, this.getFObj().getLocator());
            this.endIndent += ipd;
        }
        this.setContentAreaIPD(contentIPD);
        return contentIPD;
    }

    public List getNextKnuthElements(LayoutContext context, int alignment) {
        BlockLevelLayoutManager curLM;
        BlockLevelLayoutManager prevLM = null;
        this.referenceIPD = context.getRefIPD();
        this.updateContentAreaIPDwithOverconstrainedAdjust();
        List returnedList = null;
        List contentList = new LinkedList();
        LinkedList<ListElement> returnList = new LinkedList<ListElement>();
        if (!this.breakBeforeServed) {
            this.breakBeforeServed = true;
            if (!context.suppressBreakBefore() && this.addKnuthElementsForBreakBefore(returnList, context)) {
                return returnList;
            }
        }
        if (!this.firstVisibleMarkServed) {
            this.addKnuthElementsForSpaceBefore(returnList, alignment);
            context.updateKeepWithPreviousPending(this.getKeepWithPreviousStrength());
        }
        this.addKnuthElementsForBorderPaddingBefore(returnList, !this.firstVisibleMarkServed);
        this.firstVisibleMarkServed = true;
        this.addPendingMarks(context);
        BreakElement forcedBreakAfterLast = null;
        while ((curLM = (BlockLevelLayoutManager)this.getChildLM()) != null) {
            LayoutContext childLC = new LayoutContext(0);
            childLC.copyPendingMarksFrom(context);
            if (curLM instanceof LineLayoutManager) {
                childLC.setStackLimitBP(context.getStackLimitBP());
                childLC.setStackLimitIP(new MinOptMax(this.getContentAreaIPD()));
                childLC.setRefIPD(this.getContentAreaIPD());
            } else {
                childLC.setStackLimitBP(context.getStackLimitBP());
                childLC.setRefIPD(this.referenceIPD);
            }
            if (curLM == this.childLMs.get(0)) {
                childLC.setFlags(16);
            }
            returnedList = curLM.getNextKnuthElements(childLC, alignment);
            if (contentList.isEmpty() && childLC.isKeepWithPreviousPending()) {
                context.updateKeepWithPreviousPending(childLC.getKeepWithPreviousPending());
                childLC.clearKeepWithPreviousPending();
            }
            if (returnedList != null && returnedList.size() == 1 && ((ListElement)returnedList.get(0)).isForcedBreak()) {
                if (curLM.isFinished() && !this.hasNextChildLM()) {
                    forcedBreakAfterLast = (BreakElement)returnedList.get(0);
                    context.clearPendingMarks();
                    break;
                }
                if (contentList.isEmpty()) {
                    returnList.add(new KnuthBox(0, this.notifyPos(new Position(this)), false));
                }
                contentList.addAll(returnedList);
                if (this.bpUnit > 0) {
                    this.storedList = contentList;
                    contentList = this.createUnitElements(contentList);
                }
                returnedList = new LinkedList();
                this.wrapPositionElements(contentList, returnList);
                return returnList;
            }
            if (returnedList == null || returnedList.isEmpty()) continue;
            if (prevLM != null && !ElementListUtils.startsWithForcedBreak(returnedList)) {
                this.addInBetweenBreak(contentList, context, childLC);
            }
            contentList.addAll(returnedList);
            if (ElementListUtils.endsWithForcedBreak(returnedList)) {
                if (curLM.isFinished() && !this.hasNextChildLM()) {
                    forcedBreakAfterLast = (BreakElement)ListUtil.removeLast(contentList);
                    context.clearPendingMarks();
                    break;
                }
                if (this.bpUnit > 0) {
                    this.storedList = contentList;
                    contentList = this.createUnitElements(contentList);
                }
                returnedList = new LinkedList();
                this.wrapPositionElements(contentList, returnList);
                return returnList;
            }
            context.updateKeepWithNextPending(childLC.getKeepWithNextPending());
            childLC.clearKeepsPending();
            prevLM = curLM;
        }
        if (this.bpUnit > 0) {
            this.storedList = contentList;
            contentList = this.createUnitElements(contentList);
        }
        returnedList = new LinkedList();
        if (!contentList.isEmpty()) {
            this.wrapPositionElements(contentList, returnList);
        } else if (forcedBreakAfterLast == null) {
            returnList.add(new KnuthBox(0, this.notifyPos(new Position(this)), true));
        }
        this.addKnuthElementsForBorderPaddingAfter(returnList, true);
        this.addKnuthElementsForSpaceAfter(returnList, alignment);
        context.clearPendingMarks();
        if (forcedBreakAfterLast == null) {
            this.addKnuthElementsForBreakAfter(returnList, context);
        }
        if (forcedBreakAfterLast != null) {
            forcedBreakAfterLast.clearPendingMarks();
            returnList.add(forcedBreakAfterLast);
        }
        context.updateKeepWithNextPending(this.getKeepWithNextStrength());
        this.setFinished(true);
        return returnList;
    }

    protected void addInBetweenBreak(List contentList, LayoutContext context, LayoutContext childLC) {
        if (this.mustKeepTogether() || context.isKeepWithNextPending() || childLC.isKeepWithPreviousPending()) {
            int strength = this.getKeepTogetherStrength();
            strength = Math.max(strength, context.getKeepWithNextPending());
            context.clearKeepWithNextPending();
            strength = Math.max(strength, childLC.getKeepWithPreviousPending());
            childLC.clearKeepWithPreviousPending();
            int penalty = KeepUtil.getPenaltyForKeep(strength);
            contentList.add(new BreakElement(new Position(this), penalty, context));
            return;
        }
        ListElement last = (ListElement)ListUtil.getLast(contentList);
        if (last.isGlue()) {
            log.warn((Object)"glue-type break possibility not handled properly, yet");
        } else if (!ElementListUtils.endsWithNonInfinitePenalty(contentList)) {
            contentList.add(new BreakElement(new Position(this), 0, context));
        }
    }

    public int negotiateBPDAdjustment(int adj, KnuthElement lastElement) {
        Position innerPosition = lastElement.getPosition().getPosition();
        if (innerPosition == null && lastElement.isGlue()) {
            if (((KnuthGlue)lastElement).getAdjustmentClass() == 0) {
                this.adjustedSpaceBefore += adj;
            } else {
                this.adjustedSpaceAfter += adj;
            }
            return adj;
        }
        if (innerPosition instanceof MappingPosition) {
            MappingPosition mappingPos = (MappingPosition)innerPosition;
            if (lastElement.isGlue()) {
                ListIterator storedListIterator = this.storedList.listIterator(mappingPos.getFirstIndex());
                int newAdjustment = 0;
                while (storedListIterator.nextIndex() <= mappingPos.getLastIndex()) {
                    KnuthElement storedElement = (KnuthElement)storedListIterator.next();
                    if (!storedElement.isGlue()) continue;
                    newAdjustment += ((BlockLevelLayoutManager)storedElement.getLayoutManager()).negotiateBPDAdjustment(adj - newAdjustment, storedElement);
                }
                newAdjustment = newAdjustment > 0 ? this.bpUnit * this.neededUnits(newAdjustment) : -this.bpUnit * this.neededUnits(-newAdjustment);
                return newAdjustment;
            }
            KnuthPenalty storedPenalty = (KnuthPenalty)this.storedList.get(mappingPos.getLastIndex());
            if (storedPenalty.getW() > 0) {
                return ((BlockLevelLayoutManager)storedPenalty.getLayoutManager()).negotiateBPDAdjustment(storedPenalty.getW(), storedPenalty);
            }
            return adj;
        }
        if (innerPosition.getLM() != this) {
            NonLeafPosition savedPos = (NonLeafPosition)lastElement.getPosition();
            lastElement.setPosition(innerPosition);
            int returnValue = ((BlockLevelLayoutManager)lastElement.getLayoutManager()).negotiateBPDAdjustment(adj, lastElement);
            lastElement.setPosition(savedPos);
            return returnValue;
        }
        log.error((Object)"BlockLayoutManager.negotiateBPDAdjustment(): unexpected Position");
        return 0;
    }

    public void discardSpace(KnuthGlue spaceGlue) {
        Position innerPosition = ((NonLeafPosition)spaceGlue.getPosition()).getPosition();
        if (innerPosition == null || innerPosition.getLM() == this) {
            if (spaceGlue.getAdjustmentClass() == 0) {
                this.adjustedSpaceBefore = 0;
                this.foSpaceBefore = new MinOptMax(0);
            } else {
                this.adjustedSpaceAfter = 0;
                this.foSpaceAfter = new MinOptMax(0);
            }
        } else {
            NonLeafPosition savedPos = (NonLeafPosition)spaceGlue.getPosition();
            spaceGlue.setPosition(innerPosition);
            ((BlockLevelLayoutManager)spaceGlue.getLayoutManager()).discardSpace(spaceGlue);
            spaceGlue.setPosition(savedPos);
        }
    }

    public List getChangedKnuthElements(List oldList, int alignment) {
        List workList;
        ListIterator oldListIterator = oldList.listIterator();
        KnuthElement currElement = null;
        ListElement prevElement = null;
        List<KnuthPenalty> returnedList = new LinkedList();
        LinkedList<KnuthElement> returnList = new LinkedList<KnuthElement>();
        int fromIndex = 0;
        KnuthElement oldElement = null;
        while (oldListIterator.hasNext()) {
            oldElement = (KnuthElement)oldListIterator.next();
            Position innerPosition = ((NonLeafPosition)oldElement.getPosition()).getPosition();
            if (innerPosition != null) {
                oldElement.setPosition(innerPosition);
                continue;
            }
            oldElement.setPosition(new Position(this));
        }
        if (this.bpUnit == 0) {
            workList = oldList;
        } else {
            oldListIterator = oldList.listIterator();
            KnuthElement el = (KnuthElement)oldListIterator.next();
            while (!(el.getPosition() instanceof MappingPosition)) {
                el = (KnuthElement)oldListIterator.next();
            }
            int iFirst = ((MappingPosition)el.getPosition()).getFirstIndex();
            oldListIterator = oldList.listIterator(oldList.size());
            el = (KnuthElement)oldListIterator.previous();
            while (!(el.getPosition() instanceof MappingPosition)) {
                el = (KnuthElement)oldListIterator.previous();
            }
            int iLast = ((MappingPosition)el.getPosition()).getLastIndex();
            workList = this.storedList.subList(iFirst, iLast + 1);
        }
        ListIterator workListIterator = workList.listIterator();
        while (workListIterator.hasNext()) {
            currElement = (KnuthElement)workListIterator.next();
            if (prevElement != null && prevElement.getLayoutManager() != currElement.getLayoutManager()) {
                BlockLevelLayoutManager prevLM = (BlockLevelLayoutManager)prevElement.getLayoutManager();
                BlockLevelLayoutManager currLM = (BlockLevelLayoutManager)currElement.getLayoutManager();
                boolean bSomethingAdded = false;
                if (prevLM != this) {
                    returnedList.addAll(prevLM.getChangedKnuthElements(workList.subList(fromIndex, workListIterator.previousIndex()), alignment));
                    bSomethingAdded = true;
                }
                fromIndex = workListIterator.previousIndex();
                if (bSomethingAdded && (this.mustKeepTogether() || prevLM.mustKeepWithNext() || currLM.mustKeepWithPrevious())) {
                    returnedList.add(new KnuthPenalty(0, 1000, false, new Position(this), false));
                } else if (bSomethingAdded && !((KnuthElement)ListUtil.getLast(returnedList)).isGlue()) {
                    returnedList.add(new KnuthPenalty(0, 0, false, new Position(this), false));
                }
            }
            prevElement = currElement;
        }
        if (currElement != null) {
            BlockLevelLayoutManager currLM = (BlockLevelLayoutManager)currElement.getLayoutManager();
            if (currLM != this) {
                returnedList.addAll(currLM.getChangedKnuthElements(workList.subList(fromIndex, workList.size()), alignment));
            } else if (!returnedList.isEmpty()) {
                ListUtil.removeLast(returnedList);
            }
        }
        boolean spaceBeforeIsConditional = true;
        if (this.fobj instanceof org.apache.fop.fo.flow.Block) {
            spaceBeforeIsConditional = ((org.apache.fop.fo.flow.Block)this.fobj).getCommonMarginBlock().spaceBefore.getSpace().isDiscard();
        }
        if (this.bpUnit > 0 || this.adjustedSpaceBefore != 0) {
            if (!spaceBeforeIsConditional) {
                returnList.add(new KnuthBox(0, new NonLeafPosition(this, null), false));
                returnList.add(new KnuthPenalty(0, 1000, false, new NonLeafPosition(this, null), false));
            }
            if (this.bpUnit > 0) {
                returnList.add(new KnuthGlue(0, 0, 0, 0, new NonLeafPosition(this, null), true));
            } else {
                returnList.add(new KnuthGlue(this.adjustedSpaceBefore, 0, 0, 0, new NonLeafPosition(this, null), true));
            }
        }
        if (this.bpUnit > 0) {
            this.storedList = returnedList;
            returnedList = this.createUnitElements(returnedList);
        }
        ListIterator listIter = returnedList.listIterator();
        while (listIter.hasNext()) {
            KnuthElement returnedElement = (KnuthElement)listIter.next();
            returnedElement.setPosition(new NonLeafPosition(this, returnedElement.getPosition()));
            returnList.add(returnedElement);
        }
        boolean spaceAfterIsConditional = true;
        if (this.fobj instanceof org.apache.fop.fo.flow.Block) {
            spaceAfterIsConditional = ((org.apache.fop.fo.flow.Block)this.fobj).getCommonMarginBlock().spaceAfter.getSpace().isDiscard();
        }
        if (this.bpUnit > 0 || this.adjustedSpaceAfter != 0) {
            if (!spaceAfterIsConditional) {
                returnList.add(new KnuthPenalty(0, 1000, false, new NonLeafPosition(this, null), false));
            }
            if (this.bpUnit > 0) {
                returnList.add(new KnuthGlue(0, 0, 0, 1, new NonLeafPosition(this, null), spaceAfterIsConditional));
            } else {
                returnList.add(new KnuthGlue(this.adjustedSpaceAfter, 0, 0, 1, new NonLeafPosition(this, null), spaceAfterIsConditional));
            }
            if (!spaceAfterIsConditional) {
                returnList.add(new KnuthBox(0, new NonLeafPosition(this, null), true));
            }
        }
        return returnList;
    }

    protected int getParentKeepTogetherStrength() {
        int strength = Integer.MIN_VALUE;
        if (this.getParent() instanceof BlockLevelLayoutManager) {
            strength = ((BlockLevelLayoutManager)this.getParent()).getKeepTogetherStrength();
        } else if (this.getParent() instanceof InlineLayoutManager && ((InlineLayoutManager)this.getParent()).mustKeepTogether()) {
            strength = Integer.MAX_VALUE;
        }
        return strength;
    }

    public boolean mustKeepTogether() {
        return this.getKeepTogetherStrength() > Integer.MIN_VALUE;
    }

    public boolean mustKeepWithPrevious() {
        return this.getKeepWithPreviousStrength() > Integer.MIN_VALUE;
    }

    public boolean mustKeepWithNext() {
        return this.getKeepWithNextStrength() > Integer.MIN_VALUE;
    }

    protected void addPendingMarks(LayoutContext context) {
        CommonBorderPaddingBackground borderAndPadding = this.getBorderPaddingBackground();
        if (borderAndPadding != null) {
            if (borderAndPadding.getBorderBeforeWidth(false) > 0) {
                context.addPendingBeforeMark(new BorderElement(this.getAuxiliaryPosition(), borderAndPadding.getBorderInfo(0).getWidth(), RelSide.BEFORE, false, false, this));
            }
            if (borderAndPadding.getPaddingBefore(false, this) > 0) {
                context.addPendingBeforeMark(new PaddingElement(this.getAuxiliaryPosition(), borderAndPadding.getPaddingLengthProperty(0), RelSide.BEFORE, false, false, this));
            }
            if (borderAndPadding.getBorderAfterWidth(false) > 0) {
                context.addPendingAfterMark(new BorderElement(this.getAuxiliaryPosition(), borderAndPadding.getBorderInfo(1).getWidth(), RelSide.AFTER, false, false, this));
            }
            if (borderAndPadding.getPaddingAfter(false, this) > 0) {
                context.addPendingAfterMark(new PaddingElement(this.getAuxiliaryPosition(), borderAndPadding.getPaddingLengthProperty(1), RelSide.AFTER, false, false, this));
            }
        }
    }

    private CommonBorderPaddingBackground getBorderPaddingBackground() {
        if (this.fobj instanceof org.apache.fop.fo.flow.Block) {
            return ((org.apache.fop.fo.flow.Block)this.fobj).getCommonBorderPaddingBackground();
        }
        if (this.fobj instanceof BlockContainer) {
            return ((BlockContainer)this.fobj).getCommonBorderPaddingBackground();
        }
        if (this.fobj instanceof ListBlock) {
            return ((ListBlock)this.fobj).getCommonBorderPaddingBackground();
        }
        if (this.fobj instanceof ListItem) {
            return ((ListItem)this.fobj).getCommonBorderPaddingBackground();
        }
        if (this.fobj instanceof Table) {
            return ((Table)this.fobj).getCommonBorderPaddingBackground();
        }
        return null;
    }

    private SpaceProperty getSpaceBeforeProperty() {
        if (this.fobj instanceof org.apache.fop.fo.flow.Block) {
            return ((org.apache.fop.fo.flow.Block)this.fobj).getCommonMarginBlock().spaceBefore;
        }
        if (this.fobj instanceof BlockContainer) {
            return ((BlockContainer)this.fobj).getCommonMarginBlock().spaceBefore;
        }
        if (this.fobj instanceof ListBlock) {
            return ((ListBlock)this.fobj).getCommonMarginBlock().spaceBefore;
        }
        if (this.fobj instanceof ListItem) {
            return ((ListItem)this.fobj).getCommonMarginBlock().spaceBefore;
        }
        if (this.fobj instanceof Table) {
            return ((Table)this.fobj).getCommonMarginBlock().spaceBefore;
        }
        return null;
    }

    private SpaceProperty getSpaceAfterProperty() {
        if (this.fobj instanceof org.apache.fop.fo.flow.Block) {
            return ((org.apache.fop.fo.flow.Block)this.fobj).getCommonMarginBlock().spaceAfter;
        }
        if (this.fobj instanceof BlockContainer) {
            return ((BlockContainer)this.fobj).getCommonMarginBlock().spaceAfter;
        }
        if (this.fobj instanceof ListBlock) {
            return ((ListBlock)this.fobj).getCommonMarginBlock().spaceAfter;
        }
        if (this.fobj instanceof ListItem) {
            return ((ListItem)this.fobj).getCommonMarginBlock().spaceAfter;
        }
        if (this.fobj instanceof Table) {
            return ((Table)this.fobj).getCommonMarginBlock().spaceAfter;
        }
        return null;
    }

    protected void addKnuthElementsForBorderPaddingBefore(List returnList, boolean isFirst) {
        CommonBorderPaddingBackground borderAndPadding = this.getBorderPaddingBackground();
        if (borderAndPadding != null) {
            if (borderAndPadding.getBorderBeforeWidth(false) > 0) {
                returnList.add(new BorderElement(this.getAuxiliaryPosition(), borderAndPadding.getBorderInfo(0).getWidth(), RelSide.BEFORE, isFirst, false, this));
            }
            if (borderAndPadding.getPaddingBefore(false, this) > 0) {
                returnList.add(new PaddingElement(this.getAuxiliaryPosition(), borderAndPadding.getPaddingLengthProperty(0), RelSide.BEFORE, isFirst, false, this));
            }
        }
    }

    protected void addKnuthElementsForBorderPaddingAfter(List returnList, boolean isLast) {
        CommonBorderPaddingBackground borderAndPadding = this.getBorderPaddingBackground();
        if (borderAndPadding != null) {
            if (borderAndPadding.getPaddingAfter(false, this) > 0) {
                returnList.add(new PaddingElement(this.getAuxiliaryPosition(), borderAndPadding.getPaddingLengthProperty(1), RelSide.AFTER, false, isLast, this));
            }
            if (borderAndPadding.getBorderAfterWidth(false) > 0) {
                returnList.add(new BorderElement(this.getAuxiliaryPosition(), borderAndPadding.getBorderInfo(1).getWidth(), RelSide.AFTER, false, isLast, this));
            }
        }
    }

    protected boolean addKnuthElementsForBreakBefore(List returnList, LayoutContext context) {
        int breakBefore = this.getBreakBefore();
        if (breakBefore == 104 || breakBefore == 28 || breakBefore == 44 || breakBefore == 100) {
            returnList.add(new BreakElement(this.getAuxiliaryPosition(), 0, -1000, breakBefore, context));
            return true;
        }
        return false;
    }

    private int getBreakBefore() {
        LayoutManager lm;
        int breakBefore = 9;
        if (this.fobj instanceof BreakPropertySet) {
            breakBefore = ((BreakPropertySet)((Object)this.fobj)).getBreakBefore();
        }
        if ((lm = this.getChildLM()) instanceof BlockStackingLayoutManager) {
            BlockStackingLayoutManager bslm = (BlockStackingLayoutManager)lm;
            breakBefore = BreakUtil.compareBreakClasses(breakBefore, bslm.getBreakBefore());
        }
        return breakBefore;
    }

    protected boolean addKnuthElementsForBreakAfter(List returnList, LayoutContext context) {
        int breakAfter = -1;
        if (this.fobj instanceof BreakPropertySet) {
            breakAfter = ((BreakPropertySet)((Object)this.fobj)).getBreakAfter();
        }
        if (breakAfter == 104 || breakAfter == 28 || breakAfter == 44 || breakAfter == 100) {
            returnList.add(new BreakElement(this.getAuxiliaryPosition(), 0, -1000, breakAfter, context));
            return true;
        }
        return false;
    }

    protected void addKnuthElementsForSpaceBefore(List returnList, int alignment) {
        SpaceProperty spaceBefore = this.getSpaceBeforeProperty();
        if (spaceBefore != null && (spaceBefore.getMinimum(this).getLength().getValue(this) != 0 || spaceBefore.getMaximum(this).getLength().getValue(this) != 0)) {
            returnList.add(new SpaceElement(this.getAuxiliaryPosition(), spaceBefore, RelSide.BEFORE, true, false, this));
        }
    }

    protected void addKnuthElementsForSpaceAfter(List returnList, int alignment) {
        SpaceProperty spaceAfter = this.getSpaceAfterProperty();
        if (spaceAfter != null && (spaceAfter.getMinimum(this).getLength().getValue(this) != 0 || spaceAfter.getMaximum(this).getLength().getValue(this) != 0)) {
            returnList.add(new SpaceElement(this.getAuxiliaryPosition(), spaceAfter, RelSide.AFTER, false, true, this));
        }
    }

    protected List createUnitElements(List oldList) {
        LayoutManager lm = ((KnuthElement)oldList.get(0)).getLayoutManager();
        boolean bAddedBoxBefore = false;
        boolean bAddedBoxAfter = false;
        if (this.adjustedSpaceBefore > 0) {
            oldList.add(0, new KnuthBox(this.adjustedSpaceBefore, new Position(lm), true));
            bAddedBoxBefore = true;
        }
        if (this.adjustedSpaceAfter > 0) {
            oldList.add(new KnuthBox(this.adjustedSpaceAfter, new Position(lm), true));
            bAddedBoxAfter = true;
        }
        MinOptMax totalLength = new MinOptMax(0);
        MinOptMax totalUnits = new MinOptMax(0);
        LinkedList<KnuthElement> newList = new LinkedList<KnuthElement>();
        ListIterator oldListIterator = oldList.listIterator();
        while (oldListIterator.hasNext()) {
            KnuthElement element = (KnuthElement)oldListIterator.next();
            if (element.isBox()) {
                totalLength.add(new MinOptMax(element.getW()));
                continue;
            }
            if (!element.isGlue()) continue;
            totalLength.min -= element.getZ();
            totalLength.max += element.getY();
        }
        totalUnits = new MinOptMax(this.neededUnits(totalLength.min), this.neededUnits(totalLength.opt), this.neededUnits(totalLength.max));
        oldListIterator = oldList.listIterator();
        boolean bPrevIsBox = false;
        MinOptMax lengthBeforeBreak = new MinOptMax(0);
        MinOptMax lengthAfterBreak = (MinOptMax)totalLength.clone();
        MinOptMax unsuppressibleUnits = new MinOptMax(0);
        int firstIndex = 0;
        int lastIndex = -1;
        while (oldListIterator.hasNext()) {
            KnuthElement element = (KnuthElement)oldListIterator.next();
            ++lastIndex;
            if (element.isBox()) {
                lengthBeforeBreak.add(new MinOptMax(element.getW()));
                lengthAfterBreak.subtract(new MinOptMax(element.getW()));
                bPrevIsBox = true;
            } else if (element.isGlue()) {
                lengthBeforeBreak.min -= element.getZ();
                lengthAfterBreak.min += element.getZ();
                lengthBeforeBreak.max += element.getY();
                lengthAfterBreak.max -= element.getY();
                bPrevIsBox = false;
            } else {
                lengthBeforeBreak.add(new MinOptMax(element.getW()));
                bPrevIsBox = false;
            }
            if (element.isPenalty() && element.getP() < 1000 || element.isGlue() && bPrevIsBox || !oldListIterator.hasNext()) {
                int iStepsForward = 0;
                while (oldListIterator.hasNext()) {
                    KnuthElement el = (KnuthElement)oldListIterator.next();
                    ++iStepsForward;
                    if (el.isGlue()) {
                        lengthAfterBreak.min += el.getZ();
                        lengthAfterBreak.max -= el.getY();
                        continue;
                    }
                    if (el.isPenalty()) continue;
                }
                MinOptMax unitsBeforeBreak = new MinOptMax(this.neededUnits(lengthBeforeBreak.min), this.neededUnits(lengthBeforeBreak.opt), this.neededUnits(lengthBeforeBreak.max));
                MinOptMax unitsAfterBreak = new MinOptMax(this.neededUnits(lengthAfterBreak.min), this.neededUnits(lengthAfterBreak.opt), this.neededUnits(lengthAfterBreak.max));
                for (int i = 0; i < iStepsForward; ++i) {
                    KnuthElement el = (KnuthElement)oldListIterator.previous();
                    if (!el.isGlue()) continue;
                    lengthAfterBreak.min -= el.getZ();
                    lengthAfterBreak.max += el.getY();
                }
                int uLengthChange = unitsBeforeBreak.opt + unitsAfterBreak.opt - totalUnits.opt;
                int uStretchChange = unitsBeforeBreak.max + unitsAfterBreak.max - totalUnits.max - (unitsBeforeBreak.opt + unitsAfterBreak.opt - totalUnits.opt);
                int uShrinkChange = unitsBeforeBreak.opt + unitsAfterBreak.opt - totalUnits.opt - (unitsBeforeBreak.min + unitsAfterBreak.min - totalUnits.min);
                int uNewNormal = unitsBeforeBreak.opt - unsuppressibleUnits.opt;
                int uNewStretch = unitsBeforeBreak.max - unitsBeforeBreak.opt - (unsuppressibleUnits.max - unsuppressibleUnits.opt);
                int uNewShrink = unitsBeforeBreak.opt - unitsBeforeBreak.min - (unsuppressibleUnits.opt - unsuppressibleUnits.min);
                int firstIndexCorrection = 0;
                int lastIndexCorrection = 0;
                if (bAddedBoxBefore) {
                    if (firstIndex != 0) {
                        ++firstIndexCorrection;
                    }
                    ++lastIndexCorrection;
                }
                if (bAddedBoxAfter && lastIndex == oldList.size() - 1) {
                    ++lastIndexCorrection;
                }
                MappingPosition mappingPos = new MappingPosition(this, firstIndex - firstIndexCorrection, lastIndex - lastIndexCorrection);
                newList.add(new KnuthBox((uNewNormal - uLengthChange) * this.bpUnit, mappingPos, false));
                unsuppressibleUnits.add(new MinOptMax(uNewNormal - uLengthChange));
                if (uNewStretch - uStretchChange > 0 || uNewShrink - uShrinkChange > 0) {
                    int iStretchUnits = uNewStretch - uStretchChange > 0 ? uNewStretch - uStretchChange : 0;
                    int iShrinkUnits = uNewShrink - uShrinkChange > 0 ? uNewShrink - uShrinkChange : 0;
                    newList.add(new KnuthPenalty(0, 1000, false, mappingPos, false));
                    newList.add(new KnuthGlue(0, iStretchUnits * this.bpUnit, iShrinkUnits * this.bpUnit, 2, mappingPos, false));
                    unsuppressibleUnits.max += iStretchUnits;
                    unsuppressibleUnits.min -= iShrinkUnits;
                    if (!oldListIterator.hasNext()) {
                        newList.add(new KnuthBox(0, mappingPos, false));
                    }
                }
                if (uStretchChange != 0 || uShrinkChange != 0) {
                    newList.add(new KnuthPenalty(0, 1000, false, mappingPos, false));
                    newList.add(new KnuthGlue(0, uStretchChange * this.bpUnit, uShrinkChange * this.bpUnit, 2, mappingPos, false));
                    newList.add(new KnuthPenalty(uLengthChange * this.bpUnit, 0, false, element.getPosition(), false));
                    newList.add(new KnuthGlue(0, -uStretchChange * this.bpUnit, -uShrinkChange * this.bpUnit, 2, mappingPos, false));
                } else if (oldListIterator.hasNext()) {
                    newList.add(new KnuthPenalty(uLengthChange * this.bpUnit, 0, false, mappingPos, false));
                }
                firstIndex = lastIndex + 1;
            }
            if (!element.isPenalty()) continue;
            lengthBeforeBreak.add(new MinOptMax(-element.getW()));
        }
        if (this.adjustedSpaceBefore > 0) {
            oldList.remove(0);
        }
        if (this.adjustedSpaceAfter > 0) {
            ListUtil.removeLast(oldList);
        }
        boolean correctFirstElement = false;
        if (this.fobj instanceof org.apache.fop.fo.flow.Block) {
            correctFirstElement = ((org.apache.fop.fo.flow.Block)this.fobj).getCommonMarginBlock().spaceBefore.getSpace().isDiscard();
        }
        if (correctFirstElement) {
            KnuthBox wrongBox = (KnuthBox)newList.removeFirst();
            int decreasedLength = (this.neededUnits(totalLength.opt) - this.neededUnits(totalLength.opt - this.adjustedSpaceBefore)) * this.bpUnit;
            newList.addFirst(new KnuthBox(wrongBox.getW() - decreasedLength, wrongBox.getPosition(), false));
            newList.addFirst(new KnuthGlue(decreasedLength, 0, 0, 0, wrongBox.getPosition(), false));
        }
        boolean correctLastElement = false;
        if (this.fobj instanceof org.apache.fop.fo.flow.Block) {
            correctLastElement = ((org.apache.fop.fo.flow.Block)this.fobj).getCommonMarginBlock().spaceAfter.getSpace().isDiscard();
        }
        if (correctLastElement) {
            KnuthBox wrongBox = (KnuthBox)newList.removeLast();
            LinkedList<KnuthElement> preserveList = new LinkedList<KnuthElement>();
            if (wrongBox.getW() == 0) {
                preserveList.add(wrongBox);
                preserveList.addFirst((KnuthGlue)newList.removeLast());
                preserveList.addFirst((KnuthPenalty)newList.removeLast());
                wrongBox = (KnuthBox)newList.removeLast();
            }
            int decreasedLength = (this.neededUnits(totalLength.opt) - this.neededUnits(totalLength.opt - this.adjustedSpaceAfter)) * this.bpUnit;
            newList.addLast(new KnuthBox(wrongBox.getW() - decreasedLength, wrongBox.getPosition(), false));
            if (!preserveList.isEmpty()) {
                newList.addAll(preserveList);
            }
            newList.addLast(new KnuthGlue(decreasedLength, 0, 0, 1, wrongBox.getPosition(), false));
        }
        return newList;
    }

    protected void wrapPositionElements(List sourceList, List targetList) {
        this.wrapPositionElements(sourceList, targetList, false);
    }

    protected void wrapPositionElements(List sourceList, List targetList, boolean force) {
        ListIterator listIter = sourceList.listIterator();
        while (listIter.hasNext()) {
            Object tempElement = listIter.next();
            if (tempElement instanceof ListElement) {
                this.wrapPositionElement((ListElement)tempElement, targetList, force);
                continue;
            }
            if (!(tempElement instanceof List)) continue;
            this.wrapPositionElements((List)tempElement, targetList, force);
        }
    }

    protected void wrapPositionElement(ListElement el, List targetList, boolean force) {
        if (force || el.getLayoutManager() != this) {
            el.setPosition(this.notifyPos(new NonLeafPosition(this, el.getPosition())));
        }
        targetList.add(el);
    }

    protected int getIPIndents() {
        return this.startIndent + this.endIndent;
    }

    public int getContentAreaIPD() {
        return this.contentAreaIPD;
    }

    protected void setContentAreaIPD(int contentAreaIPD) {
        this.contentAreaIPD = contentAreaIPD;
    }

    public int getContentAreaBPD() {
        return -1;
    }

    protected static class MappingPosition
    extends Position {
        private int iFirstIndex;
        private int iLastIndex;

        public MappingPosition(LayoutManager lm, int first, int last) {
            super(lm);
            this.iFirstIndex = first;
            this.iLastIndex = last;
        }

        public int getFirstIndex() {
            return this.iFirstIndex;
        }

        public int getLastIndex() {
            return this.iLastIndex;
        }
    }

    protected static class StackingIter
    extends PositionIterator {
        StackingIter(Iterator parentIter) {
            super(parentIter);
        }

        protected LayoutManager getLM(Object nextObj) {
            return ((Position)nextObj).getLM();
        }

        protected Position getPos(Object nextObj) {
            return (Position)nextObj;
        }
    }
}

