/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.Property;

public class KeepUtil {
    public static int getKeepStrength(Property keep) {
        if (keep.isAuto()) {
            return Integer.MIN_VALUE;
        }
        if (keep.getEnum() == 7) {
            return Integer.MAX_VALUE;
        }
        return keep.getNumber().intValue();
    }

    public static int getCombinedBlockLevelKeepStrength(KeepProperty keep) {
        return Math.max(KeepUtil.getKeepStrength(keep.getWithinPage()), KeepUtil.getKeepStrength(keep.getWithinColumn()));
    }

    public static boolean hasKeep(int strength) {
        return strength > Integer.MIN_VALUE;
    }

    public static int getPenaltyForKeep(int keepStrength) {
        if (keepStrength == Integer.MIN_VALUE) {
            return 0;
        }
        int penalty = 1000;
        if (keepStrength < Integer.MAX_VALUE) {
            --penalty;
        }
        return penalty;
    }

    public static String keepStrengthToString(int keepStrength) {
        if (keepStrength == Integer.MIN_VALUE) {
            return "auto";
        }
        if (keepStrength == Integer.MAX_VALUE) {
            return "always";
        }
        return Integer.toString(keepStrength);
    }
}

