/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.fop.afp.AFPDitheredRectanglePainter;
import org.apache.fop.afp.AFPPaintingState;
import org.apache.fop.afp.AFPRectanglePainter;
import org.apache.fop.afp.AFPResourceLevelDefaults;
import org.apache.fop.afp.AFPResourceManager;
import org.apache.fop.afp.AFPUnitConverter;
import org.apache.fop.afp.AbstractAFPPainter;
import org.apache.fop.afp.DataStream;
import org.apache.fop.afp.fonts.AFPFontCollection;
import org.apache.fop.afp.fonts.AFPPageFonts;
import org.apache.fop.fonts.FontCollection;
import org.apache.fop.fonts.FontEventAdapter;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.render.afp.AFPCustomizable;
import org.apache.fop.render.afp.AFPPainter;
import org.apache.fop.render.afp.AFPRendererConfigurator;
import org.apache.fop.render.afp.AFPShadingMode;
import org.apache.fop.render.afp.extensions.AFPInvokeMediumMap;
import org.apache.fop.render.afp.extensions.AFPPageSetup;
import org.apache.fop.render.intermediate.AbstractBinaryWritingIFDocumentHandler;
import org.apache.fop.render.intermediate.IFDocumentHandlerConfigurator;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFPainter;

public class AFPDocumentHandler
extends AbstractBinaryWritingIFDocumentHandler
implements AFPCustomizable {
    private AFPResourceManager resourceManager;
    private final AFPPaintingState paintingState;
    private final AFPUnitConverter unitConv;
    private DataStream dataStream;
    private Map pageSegmentMap = new HashMap();
    private static final int LOC_ELSEWHERE = 0;
    private static final int LOC_FOLLOWING_PAGE_SEQUENCE = 1;
    private static final int LOC_IN_PAGE_HEADER = 2;
    private int location = 0;
    private AFPShadingMode shadingMode = AFPShadingMode.COLOR;

    public AFPDocumentHandler() {
        this.resourceManager = new AFPResourceManager();
        this.paintingState = new AFPPaintingState();
        this.unitConv = this.paintingState.getUnitConverter();
    }

    public boolean supportsPagesOutOfOrder() {
        return false;
    }

    public String getMimeType() {
        return "application/x-afp";
    }

    public IFDocumentHandlerConfigurator getConfigurator() {
        return new AFPRendererConfigurator(this.getUserAgent());
    }

    public void setDefaultFontInfo(FontInfo fontInfo) {
        FontManager fontManager = this.getUserAgent().getFactory().getFontManager();
        FontCollection[] fontCollections = new FontCollection[]{new AFPFontCollection(this.getUserAgent().getEventBroadcaster(), null)};
        FontInfo fi = fontInfo != null ? fontInfo : new FontInfo();
        fi.setEventListener(new FontEventAdapter(this.getUserAgent().getEventBroadcaster()));
        fontManager.setup(fi, fontCollections);
        this.setFontInfo(fi);
    }

    AFPPaintingState getPaintingState() {
        return this.paintingState;
    }

    DataStream getDataStream() {
        return this.dataStream;
    }

    AFPResourceManager getResourceManager() {
        return this.resourceManager;
    }

    AbstractAFPPainter createRectanglePainter() {
        if (AFPShadingMode.DITHERED.equals(this.shadingMode)) {
            return new AFPDitheredRectanglePainter(this.getPaintingState(), this.getDataStream(), this.getResourceManager());
        }
        return new AFPRectanglePainter(this.getPaintingState(), this.getDataStream());
    }

    public void startDocument() throws IFException {
        super.startDocument();
        try {
            this.paintingState.setColor(Color.WHITE);
            this.dataStream = this.resourceManager.createDataStream(this.paintingState, this.outputStream);
            this.dataStream.startDocument();
        }
        catch (IOException e) {
            throw new IFException("I/O error in startDocument()", e);
        }
    }

    public void endDocumentHeader() throws IFException {
    }

    public void endDocument() throws IFException {
        try {
            this.dataStream.endDocument();
            this.dataStream = null;
            this.resourceManager.writeToStream();
            this.resourceManager = null;
        }
        catch (IOException ioe) {
            throw new IFException("I/O error in endDocument()", ioe);
        }
        super.endDocument();
    }

    public void startPageSequence(String id) throws IFException {
        try {
            this.dataStream.startPageGroup();
        }
        catch (IOException ioe) {
            throw new IFException("I/O error in startPageSequence()", ioe);
        }
        this.location = 1;
    }

    public void endPageSequence() throws IFException {
    }

    private AffineTransform getBaseTransform() {
        AffineTransform baseTransform = new AffineTransform();
        double scale = this.unitConv.mpt2units(1.0f);
        baseTransform.scale(scale, scale);
        return baseTransform;
    }

    public void startPage(int index, String name, String pageMasterName, Dimension size) throws IFException {
        this.location = 0;
        this.paintingState.clear();
        this.pageSegmentMap.clear();
        AffineTransform baseTransform = this.getBaseTransform();
        this.paintingState.concatenate(baseTransform);
        int pageWidth = Math.round(this.unitConv.mpt2units(size.width));
        this.paintingState.setPageWidth(pageWidth);
        int pageHeight = Math.round(this.unitConv.mpt2units(size.height));
        this.paintingState.setPageHeight(pageHeight);
        int pageRotation = this.paintingState.getPageRotation();
        int resolution = this.paintingState.getResolution();
        this.dataStream.startPage(pageWidth, pageHeight, pageRotation, resolution, resolution);
    }

    public void startPageHeader() throws IFException {
        super.startPageHeader();
        this.location = 2;
    }

    public void endPageHeader() throws IFException {
        this.location = 0;
        super.endPageHeader();
    }

    public IFPainter startPageContent() throws IFException {
        return new AFPPainter(this);
    }

    public void endPageContent() throws IFException {
    }

    public void endPage() throws IFException {
        try {
            AFPPageFonts pageFonts = this.paintingState.getPageFonts();
            if (pageFonts != null && !pageFonts.isEmpty()) {
                this.dataStream.addFontsToCurrentPage(pageFonts);
            }
            this.dataStream.endPage();
        }
        catch (IOException ioe) {
            throw new IFException("I/O error in endPage()", ioe);
        }
    }

    public void handleExtensionObject(Object extension) throws IFException {
        if (extension instanceof AFPPageSetup) {
            AFPPageSetup aps = (AFPPageSetup)extension;
            String element = aps.getElementName();
            if ("tag-logical-element".equals(element)) {
                if (this.location != 2 && this.location != 1) {
                    throw new IFException("TLE extension must be in the page header or between page-sequence and the first page: " + aps, null);
                }
                String name = aps.getName();
                String value = aps.getValue();
                this.dataStream.createTagLogicalElement(name, value);
            } else {
                String content;
                if (this.location != 2) {
                    throw new IFException("AFP page setup extension encountered outside the page header: " + aps, null);
                }
                if ("include-page-overlay".equals(element)) {
                    String overlay = aps.getName();
                    if (overlay != null) {
                        this.dataStream.createIncludePageOverlay(overlay);
                    }
                } else if ("include-page-segment".equals(element)) {
                    String name = aps.getName();
                    String source = aps.getValue();
                    this.pageSegmentMap.put(source, name);
                } else if ("no-operation".equals(element) && (content = aps.getContent()) != null) {
                    this.dataStream.createNoOperation(content);
                }
            }
        } else if (extension instanceof AFPInvokeMediumMap) {
            if (this.location != 1) {
                throw new IFException("AFP IMM extension must be between page-sequence and the first page: " + extension, null);
            }
            AFPInvokeMediumMap imm = (AFPInvokeMediumMap)extension;
            String mediumMap = imm.getName();
            if (mediumMap != null) {
                this.dataStream.createInvokeMediumMap(mediumMap);
            }
        }
    }

    public void setBitsPerPixel(int bitsPerPixel) {
        this.paintingState.setBitsPerPixel(bitsPerPixel);
    }

    public void setColorImages(boolean colorImages) {
        this.paintingState.setColorImages(colorImages);
    }

    public void setNativeImagesSupported(boolean nativeImages) {
        this.paintingState.setNativeImagesSupported(nativeImages);
    }

    public void setShadingMode(AFPShadingMode shadingMode) {
        this.shadingMode = shadingMode;
    }

    public void setResolution(int resolution) {
        this.paintingState.setResolution(resolution);
    }

    public int getResolution() {
        return this.paintingState.getResolution();
    }

    public void setDefaultResourceGroupFilePath(String filePath) {
        this.resourceManager.setDefaultResourceGroupFilePath(filePath);
    }

    public void setResourceLevelDefaults(AFPResourceLevelDefaults defaults) {
        this.resourceManager.setResourceLevelDefaults(defaults);
    }

    String getPageSegmentNameFor(String uri) {
        return (String)this.pageSegmentMap.get(uri);
    }
}

