/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.util.Map;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageLoader;
import org.apache.xmlgraphics.image.loader.impl.ImageRawJPEG;
import org.apache.xmlgraphics.image.loader.impl.JPEGConstants;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.java2d.CMYKColorSpace;

public class ImageLoaderRawJPEG
extends AbstractImageLoader
implements JPEGConstants {
    protected static Log log = LogFactory.getLog((Class)ImageLoaderRawJPEG.class);

    public ImageFlavor getTargetFlavor() {
        return ImageFlavor.RAW_JPEG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Image loadImage(ImageInfo info, Map hints, ImageSessionContext session) throws ImageException, IOException {
        block31: {
            if (!"image/jpeg".equals(info.getMimeType())) {
                throw new IllegalArgumentException("ImageInfo must be from a image with MIME type: image/jpeg");
            }
            colorSpace = null;
            appeFound = false;
            sofType = 0;
            iccStream = null;
            src = session.needSource(info.getOriginalURI());
            in = ImageUtil.needImageInputStream(src);
            in.mark();
            block20: while (true) {
                block21: while (true) {
                    segID = this.readMarkerSegment(in);
                    if (ImageLoaderRawJPEG.log.isDebugEnabled()) {
                        ImageLoaderRawJPEG.log.debug((Object)("Seg Marker: " + Integer.toHexString(segID)));
                    }
                    switch (segID) {
                        case 217: {
                            ImageLoaderRawJPEG.log.debug((Object)"EOI found. Stopping.");
                            ** break;
lbl20:
                            // 1 sources

                            break block31;
                        }
                        case 218: {
                            ImageLoaderRawJPEG.log.debug((Object)"SOS found. Stopping early.");
                            ** break;
lbl24:
                            // 1 sources

                            break block31;
                        }
                        case 0: 
                        case 216: {
                            continue block20;
                        }
                        case 192: 
                        case 194: 
                        case 202: {
                            sofType = segID;
                            if (ImageLoaderRawJPEG.log.isDebugEnabled()) {
                                ImageLoaderRawJPEG.log.debug((Object)("SOF: " + Integer.toHexString(sofType)));
                            }
                            in.mark();
                            try {
                                reclen = in.readUnsignedShort();
                                in.skipBytes(1);
                                in.skipBytes(2);
                                in.skipBytes(2);
                                numComponents = in.readUnsignedByte();
                                if (numComponents != 1) ** GOTO lbl44
                                colorSpace = ColorSpace.getInstance(1003);
                                ** GOTO lbl54
lbl44:
                                // 1 sources

                                if (numComponents != 3) ** GOTO lbl47
                                colorSpace = ColorSpace.getInstance(1004);
                                ** GOTO lbl54
lbl47:
                                // 1 sources

                                if (numComponents != 4) ** GOTO lbl50
                                colorSpace = CMYKColorSpace.getInstance();
                                ** GOTO lbl54
lbl50:
                                // 1 sources

                                throw new ImageException("Unsupported ColorSpace for image " + info + ". The number of components supported are 1, 3 and 4.");
                            }
                            finally {
                                in.reset();
                            }
lbl54:
                            // 3 sources

                            in.skipBytes(reclen);
                            continue block20;
                        }
                        case 226: {
                            in.mark();
                            try {
                                reclen = in.readUnsignedShort();
                                iccString = new byte[11];
                                in.readFully(iccString);
                                in.skipBytes(1);
                                if ("ICC_PROFILE".equals(new String(iccString, "US-ASCII"))) {
                                    ImageLoaderRawJPEG.log.debug((Object)"JPEG has an ICC profile");
                                    in.skipBytes(2);
                                    if (iccStream == null) {
                                        iccStream = new ByteArrayOutputStream();
                                    }
                                    buf = new byte[reclen - 18];
                                    in.readFully(buf);
                                    iccStream.write(buf);
                                }
                            }
                            finally {
                                in.reset();
                            }
                            in.skipBytes(reclen);
                            continue block20;
                        }
                        case 238: {
                            in.mark();
                            try {
                                reclen = in.readUnsignedShort();
                                adobeHeader = new byte[5];
                                in.readFully(adobeHeader);
                                if ("Adobe".equals(new String(adobeHeader, "US-ASCII"))) {
                                    appeFound = true;
                                }
                            }
                            finally {
                                in.reset();
                            }
                            in.skipBytes(reclen);
                            continue block20;
                        }
                        default: {
                            reclen = in.readUnsignedShort();
                            in.skipBytes(reclen - 2);
                            continue block21;
                        }
                    }
                    break;
                }
                break;
            }
            finally {
                in.reset();
            }
        }
        iccProfile = this.buildICCProfile(info, colorSpace, iccStream);
        if (iccProfile == null && colorSpace == null) {
            throw new ImageException("ColorSpace not be identified for JPEG image " + info);
        }
        invertImage = false;
        if (appeFound && colorSpace.getType() == 9) {
            if (ImageLoaderRawJPEG.log.isDebugEnabled()) {
                ImageLoaderRawJPEG.log.debug((Object)("JPEG has an Adobe APPE marker. Note: CMYK Image will be inverted. (" + info.getOriginalURI() + ")"));
            }
            invertImage = true;
        }
        rawImage = new ImageRawJPEG(info, ImageUtil.needInputStream(src), sofType, colorSpace, iccProfile, invertImage);
        return rawImage;
    }

    private ICC_Profile buildICCProfile(ImageInfo info, ColorSpace colorSpace, ByteArrayOutputStream iccStream) throws IOException, ImageException {
        if (iccStream != null && iccStream.size() > 0) {
            int padding = (8 - iccStream.size() % 8) % 8;
            if (padding != 0) {
                try {
                    iccStream.write(new byte[padding]);
                }
                catch (IOException ioe) {
                    throw new IOException("Error while aligning ICC stream: " + ioe.getMessage());
                }
            }
            ICC_Profile iccProfile = null;
            try {
                iccProfile = ICC_Profile.getInstance(iccStream.toByteArray());
                log.debug((Object)("JPEG has an ICC profile: " + iccProfile.toString()));
            }
            catch (IllegalArgumentException iae) {
                log.warn((Object)("An ICC profile is present but it is invalid (" + iae.getMessage() + "). The color profile will be ignored. (" + info.getOriginalURI() + ")"));
                return null;
            }
            if (iccProfile.getNumComponents() != colorSpace.getNumComponents()) {
                log.warn((Object)("The number of components of the ICC profile (" + iccProfile.getNumComponents() + ") doesn't match the image (" + colorSpace.getNumComponents() + "). Ignoring the ICC color profile."));
                return null;
            }
            return iccProfile;
        }
        return null;
    }

    private int readMarkerSegment(ImageInputStream in) throws IOException {
        int marker;
        int count = 0;
        long startPos = in.getStreamPosition();
        do {
            marker = in.read();
            ++count;
        } while (marker != 255);
        if (count > 1) {
            log.warn((Object)("no direct marker found: " + count + " at pos " + startPos));
        }
        int segID = in.read();
        return segID;
    }
}

