/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.azure.ad.authentication;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.squareup.moshi.Json;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.attribute.BasePersonAttributeDao;
import org.apereo.cas.authentication.attribute.SimplePersonAttributes;
import org.apereo.cas.authentication.attribute.SimpleUsernameAttributeProvider;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDaoFilter;
import org.apereo.cas.authentication.principal.attribute.PersonAttributes;
import org.apereo.cas.authentication.principal.attribute.UsernameAttributeProvider;
import org.apereo.cas.util.function.FunctionUtils;
import org.springframework.util.ReflectionUtils;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.moshi.MoshiConverterFactory;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

public class MicrosoftGraphPersonAttributeDao
extends BasePersonAttributeDao {
    private final UsernameAttributeProvider usernameAttributeProvider = new SimpleUsernameAttributeProvider();
    private String tenant;
    private String resource = "https://graph.microsoft.com/";
    private String scope;
    private String grantType = "client_credentials";
    private String clientId;
    private String clientSecret;
    private String properties;
    private String apiBaseUrl = "https://graph.microsoft.com/v1.0/";
    private String loginBaseUrl = "https://login.microsoftonline.com/%s/";
    private String domain;
    private String loggingLevel = "BASIC";

    public PersonAttributes getPerson(String uid, Set<PersonAttributes> resultPeople, PersonAttributeDaoFilter filter) {
        return (PersonAttributes)FunctionUtils.doUnchecked(() -> {
            HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
            loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.valueOf((String)this.loggingLevel.toUpperCase(Locale.ENGLISH)));
            String token = this.getToken();
            OkHttpClient client = new OkHttpClient.Builder().addInterceptor(chain -> {
                Request request = chain.request().newBuilder().header("Authorization", "Bearer " + token).build();
                return chain.proceed(request);
            }).addInterceptor((Interceptor)loggingInterceptor).build();
            Retrofit retrofit = new Retrofit.Builder().baseUrl(this.apiBaseUrl).addConverterFactory((Converter.Factory)MoshiConverterFactory.create()).client(client).build();
            GraphApiService service = (GraphApiService)retrofit.create(GraphApiService.class);
            String user = this.domain == null ? uid : uid + "@" + this.domain;
            Call<User> call = service.getUserByUserPrincipalName(user, (String)StringUtils.defaultIfBlank((CharSequence)this.properties, (CharSequence)String.join((CharSequence)",", User.getDefaultFieldQuery())));
            Response userCallResult = call.execute();
            if (userCallResult.isSuccessful()) {
                User response = (User)userCallResult.body();
                Map<String, Object> attributes = response.buildAttributes();
                return new SimplePersonAttributes(uid, this.stuffAttributesIntoList(attributes, filter));
            }
            ResponseBody errorBody = userCallResult.errorBody();
            try {
                throw new RuntimeException("error requesting token (" + userCallResult.code() + "): " + String.valueOf(errorBody));
            }
            catch (Throwable throwable) {
                if (errorBody != null) {
                    try {
                        errorBody.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        });
    }

    public Set<PersonAttributes> getPeople(Map<String, Object> query, PersonAttributeDaoFilter filter, Set<PersonAttributes> resultPeople) {
        return this.getPeopleWithMultivaluedAttributes(this.stuffAttributesIntoList(query, filter), filter, resultPeople);
    }

    public Set<PersonAttributes> getPeopleWithMultivaluedAttributes(Map<String, List<Object>> query, PersonAttributeDaoFilter filter, Set<PersonAttributes> resultPeople) {
        LinkedHashSet<PersonAttributes> people = new LinkedHashSet<PersonAttributes>();
        String username = this.usernameAttributeProvider.getUsernameFromQuery(query);
        PersonAttributes person = this.getPerson(username, resultPeople, filter);
        if (person != null) {
            people.add(person);
        }
        return people;
    }

    private String getToken() throws Exception {
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.valueOf((String)this.loggingLevel.toUpperCase(Locale.ENGLISH)));
        OkHttpClient client = new OkHttpClient.Builder().addInterceptor((Interceptor)loggingInterceptor).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(String.format(this.loginBaseUrl, this.tenant)).addConverterFactory((Converter.Factory)MoshiConverterFactory.create()).client(client).build();
        GraphAuthApiService service = (GraphAuthApiService)retrofit.create(GraphAuthApiService.class);
        Response response = service.getOauth2Token(this.grantType, this.clientId, this.clientSecret, this.scope, this.resource).execute();
        if (response.isSuccessful()) {
            OAuthTokenInfo info = (OAuthTokenInfo)response.body();
            return Objects.requireNonNull(info).accessToken;
        }
        ResponseBody errorBody = response.errorBody();
        try {
            throw new RuntimeException("error requesting token (" + response.code() + "): " + String.valueOf(errorBody));
        }
        catch (Throwable throwable) {
            if (errorBody != null) {
                try {
                    errorBody.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Generated
    public UsernameAttributeProvider getUsernameAttributeProvider() {
        return this.usernameAttributeProvider;
    }

    @Generated
    public String getTenant() {
        return this.tenant;
    }

    @Generated
    public String getResource() {
        return this.resource;
    }

    @Generated
    public String getScope() {
        return this.scope;
    }

    @Generated
    public String getGrantType() {
        return this.grantType;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public String getProperties() {
        return this.properties;
    }

    @Generated
    public String getApiBaseUrl() {
        return this.apiBaseUrl;
    }

    @Generated
    public String getLoginBaseUrl() {
        return this.loginBaseUrl;
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public String getLoggingLevel() {
        return this.loggingLevel;
    }

    @Generated
    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    @Generated
    public void setResource(String resource) {
        this.resource = resource;
    }

    @Generated
    public void setScope(String scope) {
        this.scope = scope;
    }

    @Generated
    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    @Generated
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Generated
    public void setProperties(String properties) {
        this.properties = properties;
    }

    @Generated
    public void setApiBaseUrl(String apiBaseUrl) {
        this.apiBaseUrl = apiBaseUrl;
    }

    @Generated
    public void setLoginBaseUrl(String loginBaseUrl) {
        this.loginBaseUrl = loginBaseUrl;
    }

    @Generated
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Generated
    public void setLoggingLevel(String loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    private static interface GraphAuthApiService {
        @FormUrlEncoded
        @POST(value="oauth2/token")
        public Call<OAuthTokenInfo> getOauth2Token(@Field(value="grant_type") String var1, @Field(value="client_id") String var2, @Field(value="client_secret") String var3, @Field(value="scope") String var4, @Field(value="resource") String var5);
    }

    private static final class OAuthTokenInfo
    implements Serializable {
        private static final long serialVersionUID = -8586825191767772463L;
        @Json(name="token_type")
        private String tokenType;
        @Json(name="scope")
        private String scope;
        @Json(name="expires_in")
        private int expiresIn;
        @Json(name="expires_on")
        private int expiresOn;
        @Json(name="not_before")
        private int notBefore;
        @Json(name="resource")
        private String resource;
        @Json(name="access_token")
        private String accessToken;

        private OAuthTokenInfo() {
        }

        @Generated
        public String getTokenType() {
            return this.tokenType;
        }

        @Generated
        public String getScope() {
            return this.scope;
        }

        @Generated
        public int getExpiresIn() {
            return this.expiresIn;
        }

        @Generated
        public int getExpiresOn() {
            return this.expiresOn;
        }

        @Generated
        public int getNotBefore() {
            return this.notBefore;
        }

        @Generated
        public String getResource() {
            return this.resource;
        }

        @Generated
        public String getAccessToken() {
            return this.accessToken;
        }

        @Generated
        public void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }

        @Generated
        public void setScope(String scope) {
            this.scope = scope;
        }

        @Generated
        public void setExpiresIn(int expiresIn) {
            this.expiresIn = expiresIn;
        }

        @Generated
        public void setExpiresOn(int expiresOn) {
            this.expiresOn = expiresOn;
        }

        @Generated
        public void setNotBefore(int notBefore) {
            this.notBefore = notBefore;
        }

        @Generated
        public void setResource(String resource) {
            this.resource = resource;
        }

        @Generated
        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }
    }

    private static interface GraphApiService {
        @GET(value="users/{upn}")
        public Call<User> getUserByUserPrincipalName(@Path(value="upn") String var1, @Query(value="$select", encoded=true) String var2);
    }

    private static final class User
    implements Serializable {
        private static final long serialVersionUID = 8497244140827305607L;
        private String userPrincipalName;
        private String id;
        private boolean accountEnabled;
        private String displayName;
        private String mail;
        private String jobTitle;
        private String officeLocation;
        private String preferredLanguage;
        private String mobilePhone;
        private String surname;
        private String givenName;
        private String passwordPolicies;
        private String preferredName;
        private List<String> businessPhones = new ArrayList<String>(0);
        private List<String> schools = new ArrayList<String>(0);
        private List<String> skills = new ArrayList<String>(0);
        private String postalCode;
        private String consentProvidedForMinor;
        private String aboutMe;
        private String streetAddress;
        private String userType;
        private String usageLocation;
        private String state;
        private String ageGroup;
        private String otherMails;
        private String city;
        private String country;
        private String countryName;
        private String department;
        private String employeeId;
        private String faxNumber;
        private String mailNickname;
        private String onPremisesSamAccountName;

        private User() {
        }

        static List<String> getDefaultFieldQuery() {
            return List.of("businessPhones,displayName,givenName,id,jobTitle,mail,givenName,employeeId,mobilePhone,officeLocation,accountEnabledpreferredLanguage,surname,userPrincipalName");
        }

        @JsonIgnore
        private Map<String, Object> buildAttributes() {
            HashMap<String, Object> fields = new HashMap<String, Object>();
            ReflectionUtils.doWithFields(this.getClass(), field -> {
                field.setAccessible(true);
                fields.put(field.getName(), field.get(this));
            });
            return fields;
        }

        @Generated
        public String getUserPrincipalName() {
            return this.userPrincipalName;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public boolean isAccountEnabled() {
            return this.accountEnabled;
        }

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public String getMail() {
            return this.mail;
        }

        @Generated
        public String getJobTitle() {
            return this.jobTitle;
        }

        @Generated
        public String getOfficeLocation() {
            return this.officeLocation;
        }

        @Generated
        public String getPreferredLanguage() {
            return this.preferredLanguage;
        }

        @Generated
        public String getMobilePhone() {
            return this.mobilePhone;
        }

        @Generated
        public String getSurname() {
            return this.surname;
        }

        @Generated
        public String getGivenName() {
            return this.givenName;
        }

        @Generated
        public String getPasswordPolicies() {
            return this.passwordPolicies;
        }

        @Generated
        public String getPreferredName() {
            return this.preferredName;
        }

        @Generated
        public List<String> getBusinessPhones() {
            return this.businessPhones;
        }

        @Generated
        public List<String> getSchools() {
            return this.schools;
        }

        @Generated
        public List<String> getSkills() {
            return this.skills;
        }

        @Generated
        public String getPostalCode() {
            return this.postalCode;
        }

        @Generated
        public String getConsentProvidedForMinor() {
            return this.consentProvidedForMinor;
        }

        @Generated
        public String getAboutMe() {
            return this.aboutMe;
        }

        @Generated
        public String getStreetAddress() {
            return this.streetAddress;
        }

        @Generated
        public String getUserType() {
            return this.userType;
        }

        @Generated
        public String getUsageLocation() {
            return this.usageLocation;
        }

        @Generated
        public String getState() {
            return this.state;
        }

        @Generated
        public String getAgeGroup() {
            return this.ageGroup;
        }

        @Generated
        public String getOtherMails() {
            return this.otherMails;
        }

        @Generated
        public String getCity() {
            return this.city;
        }

        @Generated
        public String getCountry() {
            return this.country;
        }

        @Generated
        public String getCountryName() {
            return this.countryName;
        }

        @Generated
        public String getDepartment() {
            return this.department;
        }

        @Generated
        public String getEmployeeId() {
            return this.employeeId;
        }

        @Generated
        public String getFaxNumber() {
            return this.faxNumber;
        }

        @Generated
        public String getMailNickname() {
            return this.mailNickname;
        }

        @Generated
        public String getOnPremisesSamAccountName() {
            return this.onPremisesSamAccountName;
        }

        @Generated
        public void setUserPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setAccountEnabled(boolean accountEnabled) {
            this.accountEnabled = accountEnabled;
        }

        @Generated
        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Generated
        public void setMail(String mail) {
            this.mail = mail;
        }

        @Generated
        public void setJobTitle(String jobTitle) {
            this.jobTitle = jobTitle;
        }

        @Generated
        public void setOfficeLocation(String officeLocation) {
            this.officeLocation = officeLocation;
        }

        @Generated
        public void setPreferredLanguage(String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
        }

        @Generated
        public void setMobilePhone(String mobilePhone) {
            this.mobilePhone = mobilePhone;
        }

        @Generated
        public void setSurname(String surname) {
            this.surname = surname;
        }

        @Generated
        public void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        @Generated
        public void setPasswordPolicies(String passwordPolicies) {
            this.passwordPolicies = passwordPolicies;
        }

        @Generated
        public void setPreferredName(String preferredName) {
            this.preferredName = preferredName;
        }

        @Generated
        public void setBusinessPhones(List<String> businessPhones) {
            this.businessPhones = businessPhones;
        }

        @Generated
        public void setSchools(List<String> schools) {
            this.schools = schools;
        }

        @Generated
        public void setSkills(List<String> skills) {
            this.skills = skills;
        }

        @Generated
        public void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Generated
        public void setConsentProvidedForMinor(String consentProvidedForMinor) {
            this.consentProvidedForMinor = consentProvidedForMinor;
        }

        @Generated
        public void setAboutMe(String aboutMe) {
            this.aboutMe = aboutMe;
        }

        @Generated
        public void setStreetAddress(String streetAddress) {
            this.streetAddress = streetAddress;
        }

        @Generated
        public void setUserType(String userType) {
            this.userType = userType;
        }

        @Generated
        public void setUsageLocation(String usageLocation) {
            this.usageLocation = usageLocation;
        }

        @Generated
        public void setState(String state) {
            this.state = state;
        }

        @Generated
        public void setAgeGroup(String ageGroup) {
            this.ageGroup = ageGroup;
        }

        @Generated
        public void setOtherMails(String otherMails) {
            this.otherMails = otherMails;
        }

        @Generated
        public void setCity(String city) {
            this.city = city;
        }

        @Generated
        public void setCountry(String country) {
            this.country = country;
        }

        @Generated
        public void setCountryName(String countryName) {
            this.countryName = countryName;
        }

        @Generated
        public void setDepartment(String department) {
            this.department = department;
        }

        @Generated
        public void setEmployeeId(String employeeId) {
            this.employeeId = employeeId;
        }

        @Generated
        public void setFaxNumber(String faxNumber) {
            this.faxNumber = faxNumber;
        }

        @Generated
        public void setMailNickname(String mailNickname) {
            this.mailNickname = mailNickname;
        }

        @Generated
        public void setOnPremisesSamAccountName(String onPremisesSamAccountName) {
            this.onPremisesSamAccountName = onPremisesSamAccountName;
        }
    }
}

