/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.bypass.AuthenticationMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.CredentialMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.DefaultChainingMultifactorAuthenticationBypassProvider;
import org.apereo.cas.authentication.bypass.GroovyMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.HttpRequestMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.PrincipalMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RegisteredServiceMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RestMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderBypassProperties;
import org.apereo.cas.configuration.model.support.mfa.gauth.GoogleAuthenticatorMultifactorProperties;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.GoogleAuthenticator})
@Configuration(value="GoogleAuthenticatorAuthenticationMultifactorProviderBypassConfiguration", proxyBeanMethods=false)
class GoogleAuthenticatorAuthenticationMultifactorProviderBypassConfiguration {
    GoogleAuthenticatorAuthenticationMultifactorProviderBypassConfiguration() {
    }

    @ConditionalOnMissingBean(name={"googleAuthenticatorBypassEvaluator"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorBypassEvaluator(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="googleAuthenticatorPrincipalMultifactorAuthenticationProviderBypass") MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorPrincipalMultifactorAuthenticationProviderBypass, @Qualifier(value="googleAuthenticatorRegisteredServiceMultifactorAuthenticationProviderBypass") MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorRegisteredServiceMultifactorAuthenticationProviderBypass, @Qualifier(value="googleAuthenticatorRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator") MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator, @Qualifier(value="googleAuthenticatorAuthenticationMultifactorAuthenticationProviderBypass") MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorAuthenticationMultifactorAuthenticationProviderBypass, @Qualifier(value="googleAuthenticatorCredentialMultifactorAuthenticationProviderBypass") MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorCredentialMultifactorAuthenticationProviderBypass, @Qualifier(value="googleAuthenticatorHttpRequestMultifactorAuthenticationProviderBypass") MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorHttpRequestMultifactorAuthenticationProviderBypass, @Qualifier(value="googleAuthenticatorGroovyMultifactorAuthenticationProviderBypass") MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorGroovyMultifactorAuthenticationProviderBypass, @Qualifier(value="googleAuthenticatorRestMultifactorAuthenticationProviderBypass") MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorRestMultifactorAuthenticationProviderBypass) {
        DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider(applicationContext);
        MultifactorAuthenticationProviderBypassProperties props = casProperties.getAuthn().getMfa().getGauth().getBypass();
        if (StringUtils.isNotBlank((CharSequence)props.getPrincipalAttributeName())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(googleAuthenticatorPrincipalMultifactorAuthenticationProviderBypass);
        }
        bypass.addMultifactorAuthenticationProviderBypassEvaluator(googleAuthenticatorRegisteredServiceMultifactorAuthenticationProviderBypass);
        bypass.addMultifactorAuthenticationProviderBypassEvaluator(googleAuthenticatorRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator);
        if (StringUtils.isNotBlank((CharSequence)props.getAuthenticationAttributeName()) || StringUtils.isNotBlank((CharSequence)props.getAuthenticationHandlerName()) || StringUtils.isNotBlank((CharSequence)props.getAuthenticationMethodName())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(googleAuthenticatorAuthenticationMultifactorAuthenticationProviderBypass);
        }
        if (StringUtils.isNotBlank((CharSequence)props.getCredentialClassType())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(googleAuthenticatorCredentialMultifactorAuthenticationProviderBypass);
        }
        if (StringUtils.isNotBlank((CharSequence)props.getHttpRequestHeaders()) || StringUtils.isNotBlank((CharSequence)props.getHttpRequestRemoteAddress())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(googleAuthenticatorHttpRequestMultifactorAuthenticationProviderBypass);
        }
        if (props.getGroovy().getLocation() != null) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(googleAuthenticatorGroovyMultifactorAuthenticationProviderBypass);
        }
        if (StringUtils.isNotBlank((CharSequence)props.getRest().getUrl())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(googleAuthenticatorRestMultifactorAuthenticationProviderBypass);
        }
        return bypass;
    }

    @ConditionalOnMissingBean(name={"googleAuthenticatorRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        GoogleAuthenticatorMultifactorProperties gauth = casProperties.getAuthn().getMfa().getGauth();
        return new RegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator(gauth.getId(), applicationContext);
    }

    @ConditionalOnMissingBean(name={"googleAuthenticatorRestMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorRestMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        GoogleAuthenticatorMultifactorProperties gauth = casProperties.getAuthn().getMfa().getGauth();
        MultifactorAuthenticationProviderBypassProperties props = gauth.getBypass();
        return new RestMultifactorAuthenticationProviderBypassEvaluator(props, gauth.getId(), applicationContext);
    }

    @ConditionalOnMissingBean(name={"googleAuthenticatorGroovyMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorGroovyMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(BeanCondition.on((String)"cas.authn.mfa.gauth.bypass.groovy.location").exists().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            GoogleAuthenticatorMultifactorProperties gauth = casProperties.getAuthn().getMfa().getGauth();
            MultifactorAuthenticationProviderBypassProperties props = gauth.getBypass();
            return new GroovyMultifactorAuthenticationProviderBypassEvaluator(props, gauth.getId(), applicationContext);
        }).otherwiseProxy().get();
    }

    @ConditionalOnMissingBean(name={"googleAuthenticatorHttpRequestMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorHttpRequestMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        GoogleAuthenticatorMultifactorProperties gauth = casProperties.getAuthn().getMfa().getGauth();
        MultifactorAuthenticationProviderBypassProperties props = gauth.getBypass();
        return new HttpRequestMultifactorAuthenticationProviderBypassEvaluator(props, gauth.getId(), (ApplicationContext)applicationContext);
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"googleAuthenticatorCredentialMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorCredentialMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        GoogleAuthenticatorMultifactorProperties gauth = casProperties.getAuthn().getMfa().getGauth();
        MultifactorAuthenticationProviderBypassProperties props = gauth.getBypass();
        return new CredentialMultifactorAuthenticationProviderBypassEvaluator(props, gauth.getId(), applicationContext);
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"googleAuthenticatorRegisteredServiceMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorRegisteredServiceMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        GoogleAuthenticatorMultifactorProperties gauth = casProperties.getAuthn().getMfa().getGauth();
        return new RegisteredServiceMultifactorAuthenticationProviderBypassEvaluator(gauth.getId(), applicationContext);
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"googleAuthenticatorPrincipalMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorPrincipalMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        GoogleAuthenticatorMultifactorProperties gauth = casProperties.getAuthn().getMfa().getGauth();
        MultifactorAuthenticationProviderBypassProperties props = gauth.getBypass();
        return new PrincipalMultifactorAuthenticationProviderBypassEvaluator(props, gauth.getId(), (ApplicationContext)applicationContext);
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"googleAuthenticatorAuthenticationMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator googleAuthenticatorAuthenticationMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        GoogleAuthenticatorMultifactorProperties gauth = casProperties.getAuthn().getMfa().getGauth();
        MultifactorAuthenticationProviderBypassProperties props = gauth.getBypass();
        return new AuthenticationMultifactorAuthenticationProviderBypassEvaluator(props, gauth.getId(), applicationContext);
    }
}

