/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.LdapAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authorization.EndpointLdapAuthenticationProvider;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.monitor.LdapSecurityActuatorEndpointsMonitorProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapAuthenticationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.ldap.LdapAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.CasWebSecurityConfigurer;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.auth.Authenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.LDAP}, module="authentication")
@AutoConfiguration
public class LdapAuthenticationConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapAuthenticationConfiguration.class);

    @Configuration(value="LdapSpringSecurityAuthenticationConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class LdapSpringSecurityAuthenticationConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"ldapHttpWebSecurityConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebSecurityConfigurer<HttpSecurity> ldapHttpWebSecurityConfigurer(SecurityProperties securityProperties, CasConfigurationProperties casProperties) {
            return new LdapHttpSecurityCasWebSecurityConfigurer(casProperties, securityProperties);
        }

        private static final class LdapHttpSecurityCasWebSecurityConfigurer
        implements CasWebSecurityConfigurer<HttpSecurity> {
            private final CasConfigurationProperties casProperties;
            private final SecurityProperties securityProperties;
            private EndpointLdapAuthenticationProvider endpointLdapAuthenticationProvider;

            public void destroy() {
                FunctionUtils.doIfNotNull((Object)this.endpointLdapAuthenticationProvider, EndpointLdapAuthenticationProvider::destroy);
            }

            @CanIgnoreReturnValue
            public CasWebSecurityConfigurer<HttpSecurity> configure(HttpSecurity http) throws Exception {
                LdapSecurityActuatorEndpointsMonitorProperties ldap = this.casProperties.getMonitor().getEndpoints().getLdap();
                if (StringUtils.isNotBlank((CharSequence)ldap.getLdapUrl()) && StringUtils.isNotBlank((CharSequence)ldap.getSearchFilter())) {
                    this.configureLdapAuthenticationProvider(http, ldap);
                } else {
                    LOGGER.trace("No LDAP url or search filter is defined to enable LDAP authentication");
                }
                return this;
            }

            private void configureLdapAuthenticationProvider(HttpSecurity http, LdapSecurityActuatorEndpointsMonitorProperties ldap) {
                if (this.isLdapAuthorizationActive()) {
                    ConnectionFactory connectionFactory = LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)ldap);
                    Authenticator authenticator = LdapUtils.newLdaptiveAuthenticator((AbstractLdapAuthenticationProperties)ldap);
                    this.endpointLdapAuthenticationProvider = new EndpointLdapAuthenticationProvider(ldap, this.securityProperties, connectionFactory, authenticator);
                    http.authenticationProvider((AuthenticationProvider)this.endpointLdapAuthenticationProvider);
                }
            }

            private boolean isLdapAuthorizationActive() {
                LdapSecurityActuatorEndpointsMonitorProperties ldap = this.casProperties.getMonitor().getEndpoints().getLdap();
                return StringUtils.isNotBlank((CharSequence)ldap.getBaseDn()) && StringUtils.isNotBlank((CharSequence)ldap.getLdapUrl()) && StringUtils.isNotBlank((CharSequence)ldap.getSearchFilter()) && (StringUtils.isNotBlank((CharSequence)ldap.getLdapAuthz().getRoleAttribute()) || StringUtils.isNotBlank((CharSequence)ldap.getLdapAuthz().getGroupAttribute()));
            }

            @Generated
            public LdapHttpSecurityCasWebSecurityConfigurer(CasConfigurationProperties casProperties, SecurityProperties securityProperties) {
                this.casProperties = casProperties;
                this.securityProperties = securityProperties;
            }
        }
    }

    @Configuration(value="LdapAuthenticationPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class LdapAuthenticationPlanConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"ldapAuthenticationHandlers"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BeanContainer<AuthenticationHandler> ldapAuthenticationHandlers(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="ldapPrincipalFactory") PrincipalFactory ldapPrincipalFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            List handlers = casProperties.getAuthn().getLdap().stream().filter(prop -> {
                if (prop.getType() == null || StringUtils.isBlank((CharSequence)prop.getLdapUrl())) {
                    LOGGER.warn("Skipping LDAP authentication entry since no type or LDAP url is defined");
                    return false;
                }
                return true;
            }).map(prop -> {
                LdapAuthenticationHandler handler = LdapUtils.createLdapAuthenticationHandler((LdapAuthenticationProperties)prop, (ApplicationContext)applicationContext, (ServicesManager)servicesManager, (PrincipalFactory)ldapPrincipalFactory);
                handler.setState(prop.getState());
                return handler;
            }).collect(Collectors.toList());
            return BeanContainer.of(handlers);
        }

        @ConditionalOnMissingBean(name={"ldapAuthenticationEventExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationEventExecutionPlanConfigurer ldapAuthenticationEventExecutionPlanConfigurer(@Qualifier(value="ldapAuthenticationHandlers") BeanContainer<AuthenticationHandler> ldapAuthenticationHandlers, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver) {
            return plan -> ldapAuthenticationHandlers.toList().forEach(handler -> {
                LOGGER.info("Registering LDAP authentication for [{}]", (Object)handler.getName());
                plan.registerAuthenticationHandlerWithPrincipalResolver(handler, defaultPrincipalResolver);
            });
        }
    }

    @Configuration(value="LdapCoreAuthenticationConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class LdapCoreAuthenticationConfiguration {
        @ConditionalOnMissingBean(name={"ldapPrincipalFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalFactory ldapPrincipalFactory() {
            return PrincipalFactoryUtils.newPrincipalFactory();
        }
    }
}

