/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import java.util.stream.Collectors;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationPostProcessor;
import org.apereo.cas.authentication.LdapPasswordSynchronizationAuthenticationPostProcessor;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.passwordsync.LdapPasswordSynchronizationProperties;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.LDAP}, module="password-sync")
@Configuration(value="LdapPasswordSynchronizationConfiguration", proxyBeanMethods=false)
class LdapPasswordSynchronizationConfiguration {
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.password-sync.enabled").isTrue().evenIfMissing();

    LdapPasswordSynchronizationConfiguration() {
    }

    @ConditionalOnMissingBean(name={"ldapPasswordSynchronizationAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public AuthenticationEventExecutionPlanConfigurer ldapPasswordSynchronizationAuthenticationEventExecutionPlanConfigurer(@Qualifier(value="ldapPasswordSynchronizers") BeanContainer<AuthenticationPostProcessor> ldapPasswordSynchronizers, ConfigurableApplicationContext applicationContext) {
        return (AuthenticationEventExecutionPlanConfigurer)BeanSupplier.of(AuthenticationEventExecutionPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> ldapPasswordSynchronizers.forEach(arg_0 -> ((AuthenticationEventExecutionPlan)plan).registerAuthenticationPostProcessor(arg_0))).otherwiseProxy().get();
    }

    @ConditionalOnMissingBean(name={"ldapPasswordSynchronizers"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public BeanContainer<AuthenticationPostProcessor> ldapPasswordSynchronizers(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        return (BeanContainer)BeanSupplier.of(BeanContainer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            List ldap = casProperties.getAuthn().getPasswordSync().getLdap();
            List processors = ldap.stream().filter(LdapPasswordSynchronizationProperties::isEnabled).map(LdapPasswordSynchronizationAuthenticationPostProcessor::new).collect(Collectors.toList());
            return BeanContainer.of(processors);
        }).otherwise(BeanContainer::empty).get();
    }
}

