/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.oidc.audit.OidcIdTokenAuditResourceResolver;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.DefaultAuditActionResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.OpenIDConnect}, module="audit")
@AutoConfiguration
public class OidcAuditConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcAuditConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(name={"oidcIdTokenResourceResolver"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public AuditResourceResolver oidcIdTokenResourceResolver(CasConfigurationProperties casProperties) {
        return new OidcIdTokenAuditResourceResolver(casProperties.getAudit().getEngine());
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcAuditTrailRecordResolutionPlanConfigurer"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public AuditTrailRecordResolutionPlanConfigurer oidcAuditTrailRecordResolutionPlanConfigurer(@Qualifier(value="oidcIdTokenResourceResolver") AuditResourceResolver oidcIdTokenResourceResolver, CasConfigurationProperties casProperties) {
        return plan -> {
            plan.registerAuditActionResolver("OIDC_ID_TOKEN_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver("_CREATED"));
            plan.registerAuditResourceResolver("OIDC_ID_TOKEN_RESOURCE_RESOLVER", oidcIdTokenResourceResolver);
        };
    }
}

