/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions.logout;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.net.URIBuilder;
import org.apereo.cas.pac4j.client.DelegatedIdentityProviders;
import org.apereo.cas.support.pac4j.authentication.DelegatedAuthenticationClientLogoutRequest;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.TransientSessionTicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.flow.DelegationWebflowUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.jooq.lambda.Unchecked;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.http.adapter.JEEHttpActionAdapter;
import org.pac4j.saml.client.SAML2Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DelegatedSaml2ClientFinishLogoutAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedSaml2ClientFinishLogoutAction.class);
    private final DelegatedIdentityProviders identityProviders;
    private final SessionStore sessionStore;
    private final OpenSamlConfigBean openSamlConfigBean;
    private final TicketRegistry ticketRegistry;
    private final TicketFactory ticketFactory;

    protected Event doExecuteInternal(RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        JEEContext context = new JEEContext(request, response);
        String clientName = DelegationWebflowUtils.getDelegatedAuthenticationClientName((RequestContext)requestContext);
        if (clientName == null) {
            clientName = requestContext.getRequestParameters().get("RelayState");
            if (StringUtils.isNotBlank((CharSequence)clientName)) {
                this.identityProviders.findClient(clientName).filter(SAML2Client.class::isInstance).map(SAML2Client.class::cast).ifPresent(client -> FunctionUtils.doAndHandle(__ -> {
                    client.init();
                    LOGGER.debug("Located client from relay-state [{}]", client);
                    CallContext callContext = new CallContext((WebContext)context, this.sessionStore);
                    client.getCredentialsExtractor().extract(callContext).ifPresent(logoutCredentials -> {
                        HttpAction result = client.getLogoutProcessor().processLogout(callContext, logoutCredentials);
                        JEEHttpActionAdapter.INSTANCE.adapt(result, (WebContext)context);
                    });
                }));
            }
        } else {
            String logoutRedirect = (String)WebUtils.getLogoutRedirectUrl((RequestContext)requestContext, String.class);
            DelegatedAuthenticationClientLogoutRequest delegatedClientLogoutRequest = (DelegatedAuthenticationClientLogoutRequest)DelegationWebflowUtils.getDelegatedAuthenticationLogoutRequest((RequestContext)requestContext, DelegatedAuthenticationClientLogoutRequest.class);
            this.identityProviders.findClient(clientName).filter(SAML2Client.class::isInstance).map(SAML2Client.class::cast).ifPresent(client -> {
                client.init();
                Optional.ofNullable(delegatedClientLogoutRequest).filter(__ -> StringUtils.isNotBlank((CharSequence)logoutRedirect)).filter(__ -> StringUtils.isNotBlank((CharSequence)delegatedClientLogoutRequest.getLocation())).ifPresent(Unchecked.consumer(__ -> {
                    try {
                        URIBuilder urlBuilder = new URIBuilder(delegatedClientLogoutRequest.getLocation());
                        Optional<NameValuePair> samlRequestParam = Optional.ofNullable(urlBuilder.getFirstQueryParam("SAMLRequest"));
                        samlRequestParam.ifPresent(Unchecked.consumer(samlRequest -> {
                            LogoutRequest logoutRequest = (LogoutRequest)SamlUtils.convertToSamlObject((OpenSamlConfigBean)this.openSamlConfigBean, (String)samlRequest.getValue(), LogoutRequest.class);
                            String logoutRequestTicketId = TransientSessionTicketFactory.normalizeTicketId((String)logoutRequest.getID());
                            TransientSessionTicketFactory transientFactory = (TransientSessionTicketFactory)this.ticketFactory.get(TransientSessionTicket.class);
                            TransientSessionTicket transientSessionTicket = transientFactory.create(logoutRequestTicketId, Map.of(DelegatedAuthenticationClientLogoutRequest.class.getName(), delegatedClientLogoutRequest));
                            Ticket storedTicket = this.ticketRegistry.addTicket((Ticket)transientSessionTicket);
                            DelegationWebflowUtils.putDelegatedAuthenticationLogoutRequestTicket((RequestContext)requestContext, (Ticket)storedTicket);
                        }));
                    }
                    finally {
                        LOGGER.debug("Captured post logout url: [{}]", (Object)logoutRedirect);
                        WebUtils.putLogoutRedirectUrl((RequestContext)requestContext, null);
                    }
                }));
            });
        }
        return null;
    }

    @Generated
    public DelegatedSaml2ClientFinishLogoutAction(DelegatedIdentityProviders identityProviders, SessionStore sessionStore, OpenSamlConfigBean openSamlConfigBean, TicketRegistry ticketRegistry, TicketFactory ticketFactory) {
        this.identityProviders = identityProviders;
        this.sessionStore = sessionStore;
        this.openSamlConfigBean = openSamlConfigBean;
        this.ticketRegistry = ticketRegistry;
        this.ticketFactory = ticketFactory;
    }
}

