/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions.logout;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apereo.cas.authentication.principal.ClientCredential;
import org.apereo.cas.logout.slo.SingleLogoutRequestExecutor;
import org.apereo.cas.support.pac4j.authentication.DelegatedAuthenticationClientLogoutRequest;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.TransientSessionTicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.flow.DelegationWebflowUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.saml.credentials.SAML2Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DelegatedSaml2ClientLogoutAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedSaml2ClientLogoutAction.class);
    private final TicketRegistry ticketRegistry;
    private final SingleLogoutRequestExecutor singleLogoutRequestExecutor;

    private void removeSsoSessionsForSessionIndexes(HttpServletRequest request, HttpServletResponse response, LogoutRequest logoutRequest) {
        logoutRequest.getSessionIndexes().forEach(sessionIndex -> this.ticketRegistry.getSessionsWithAttributes(Map.of("sessionindex", List.of(Objects.requireNonNull(sessionIndex.getValue())))).filter(ticket -> !ticket.isExpired()).map(TicketGrantingTicket.class::cast).findFirst().ifPresent(ticket -> this.singleLogoutRequestExecutor.execute(ticket.getId(), request, response)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Event doExecuteInternal(RequestContext requestContext) throws Throwable {
        Credentials credentials;
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        ClientCredential clientCredential = (ClientCredential)WebUtils.getCredential((RequestContext)requestContext, ClientCredential.class);
        if (clientCredential != null && (credentials = clientCredential.getCredentials()) instanceof SAML2Credentials) {
            SAML2Credentials saml2Credentials = (SAML2Credentials)credentials;
            Object message = saml2Credentials.getContext().getMessageContext().getMessage();
            if (message instanceof LogoutRequest) {
                LogoutRequest logoutRequest = (LogoutRequest)message;
                if (this.isDirectLogoutRequest(request)) {
                    HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
                    this.removeSsoSessionsForSessionIndexes(request, response, logoutRequest);
                }
            }
            if (message instanceof LogoutResponse) {
                LogoutResponse logoutResponse = (LogoutResponse)message;
                String logoutRequestTicketId = TransientSessionTicketFactory.normalizeTicketId((String)logoutResponse.getInResponseTo());
                try {
                    TransientSessionTicket logoutRequestTicket = (TransientSessionTicket)this.ticketRegistry.getTicket(logoutRequestTicketId, TransientSessionTicket.class);
                    if (logoutRequestTicket != null && !logoutRequestTicket.isExpired()) {
                        DelegatedAuthenticationClientLogoutRequest delegatedAuthLogoutRequest = (DelegatedAuthenticationClientLogoutRequest)logoutRequestTicket.getProperty(DelegatedAuthenticationClientLogoutRequest.class.getName(), DelegatedAuthenticationClientLogoutRequest.class);
                        DelegationWebflowUtils.putDelegatedAuthenticationLogoutRequest((RequestContext)requestContext, (Serializable)delegatedAuthLogoutRequest);
                    }
                }
                catch (InvalidTicketException e) {
                    LOGGER.info("Delegated authentication logout request ticket [{}] is not found", (Object)logoutRequestTicketId);
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                }
                finally {
                    this.ticketRegistry.deleteTicket(logoutRequestTicketId);
                    DelegationWebflowUtils.putDelegatedAuthenticationLogoutRequestTicket((RequestContext)requestContext, null);
                }
            }
        }
        return this.success();
    }

    protected boolean isDirectLogoutRequest(HttpServletRequest request) {
        return HttpMethod.POST.matches(request.getMethod()) || request.getParameter("logoutRequest") != null;
    }

    @Generated
    public DelegatedSaml2ClientLogoutAction(TicketRegistry ticketRegistry, SingleLogoutRequestExecutor singleLogoutRequestExecutor) {
        this.ticketRegistry = ticketRegistry;
        this.singleLogoutRequestExecutor = singleLogoutRequestExecutor;
    }
}

