/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.hazelcast.core.HazelcastInstance;
import com.mongodb.client.MongoClient;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.mongo.BaseMongoDbProperties;
import org.apereo.cas.configuration.support.CloseableDataSource;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.jpa.JpaBeanFactory;
import org.apereo.cas.mongo.CasMongoOperations;
import org.apereo.cas.mongo.MongoDbConnectionFactory;
import org.apereo.cas.pac4j.client.DelegatedIdentityProviders;
import org.apereo.cas.support.pac4j.authentication.clients.DelegatedClientFactoryCustomizer;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.SamlIdPResponseCustomizer;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.saml2.DelegatedAuthenticationSamlIdPResponseCustomizer;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.metadata.SAML2MetadataGenerator;
import org.pac4j.saml.metadata.jdbc.SAML2JdbcMetadataGenerator;
import org.pac4j.saml.metadata.mongo.SAML2MongoMetadataGenerator;
import org.pac4j.saml.store.HazelcastSAMLMessageStoreFactory;
import org.pac4j.saml.store.SAMLMessageStoreFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.jdbc.core.JdbcTemplate;

@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.DelegatedAuthentication}, module="saml")
@AutoConfiguration
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class DelegatedAuthenticationSAMLConfiguration {

    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.DelegatedAuthentication}, module="saml-mongodb", enabledByDefault=false)
    @Configuration(value="DelegatedAuthenticationSAMLMongoDbConfiguration", proxyBeanMethods=false)
    @ConditionalOnClass(value={CasMongoOperations.class})
    public static class DelegatedAuthenticationSAMLMongoDbConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"delegatedSaml2ClientMongoDbMetadataCustomizer"})
        public DelegatedClientFactoryCustomizer delegatedSaml2ClientMongoDbMetadataCustomizer(CasConfigurationProperties casProperties, @Qualifier(value="casSslContext") CasSSLContext casSslContext) {
            return client -> {
                if (client instanceof SAML2Client) {
                    SAML2Client saml2Client = (SAML2Client)client;
                    SAML2Configuration configuration = saml2Client.getConfiguration();
                    casProperties.getAuthn().getPac4j().getSaml().stream().map(saml -> saml.getMetadata().getServiceProvider().getMongo()).filter(saml -> StringUtils.isNotBlank((CharSequence)saml.getCollection())).forEach(mongo -> {
                        MongoDbConnectionFactory factory = new MongoDbConnectionFactory(casSslContext.getSslContext());
                        MongoClient mongoClient = factory.buildMongoDbClient((BaseMongoDbProperties)mongo);
                        CasMongoOperations mongoTemplate = factory.buildMongoTemplate(mongoClient, (BaseMongoDbProperties)mongo);
                        MongoDbConnectionFactory.createCollection((MongoOperations)mongoTemplate, (String)mongo.getCollection(), (boolean)mongo.isDropCollection());
                        SAML2MongoMetadataGenerator metadataGenerator = new SAML2MongoMetadataGenerator(mongoClient, configuration.getServiceProviderEntityId());
                        metadataGenerator.setMetadataCollection(mongo.getCollection());
                        metadataGenerator.setMetadataDatabase(mongo.getDatabaseName());
                        configuration.setServiceProviderMetadataResource(ResourceUtils.NULL_RESOURCE);
                        configuration.setMetadataGenerator((SAML2MetadataGenerator)metadataGenerator);
                    });
                }
            };
        }
    }

    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.DelegatedAuthentication}, module="saml-jdbc", enabledByDefault=false)
    @Configuration(value="DelegatedAuthenticationSAMLJdbcConfiguration", proxyBeanMethods=false)
    @ConditionalOnClass(value={JpaBeanFactory.class})
    public static class DelegatedAuthenticationSAMLJdbcConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"delegatedSaml2ClientJdbcMetadataCustomizer"})
        public DelegatedClientFactoryCustomizer delegatedSaml2ClientJdbcMetadataCustomizer(CasConfigurationProperties casProperties) {
            return client -> {
                if (client instanceof SAML2Client) {
                    SAML2Client saml2Client = (SAML2Client)client;
                    SAML2Configuration configuration = saml2Client.getConfiguration();
                    casProperties.getAuthn().getPac4j().getSaml().stream().map(saml -> saml.getMetadata().getServiceProvider().getJdbc()).filter(saml -> StringUtils.isNotBlank((CharSequence)saml.getUrl()) && StringUtils.isNotBlank((CharSequence)saml.getTableName())).forEach(saml -> {
                        CloseableDataSource datasource = JpaBeans.newDataSource((AbstractJpaProperties)saml);
                        SAML2JdbcMetadataGenerator metadataGenerator = new SAML2JdbcMetadataGenerator(new JdbcTemplate((DataSource)datasource), configuration.getServiceProviderEntityId());
                        metadataGenerator.setTableName(saml.getTableName());
                        configuration.setServiceProviderMetadataResource(ResourceUtils.NULL_RESOURCE);
                        configuration.setMetadataGenerator((SAML2MetadataGenerator)metadataGenerator);
                    });
                }
            };
        }
    }

    @ConditionalOnClass(value={HazelcastInstance.class})
    @Configuration(value="DelegatedAuthenticationSAMLHazelcastConfiguration", proxyBeanMethods=false)
    public static class DelegatedAuthenticationSAMLHazelcastConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnBean(name={"casTicketRegistryHazelcastInstance"})
        @ConditionalOnMissingBean(name={"delegatedSaml2ClientSAMLMessageStoreFactory"})
        public SAMLMessageStoreFactory delegatedSaml2ClientSAMLMessageStoreFactory(@Qualifier(value="casTicketRegistryHazelcastInstance") ObjectProvider<HazelcastInstance> casTicketRegistryHazelcastInstance) {
            return new HazelcastSAMLMessageStoreFactory((HazelcastInstance)casTicketRegistryHazelcastInstance.getObject());
        }
    }

    @ConditionalOnClass(value={SamlIdPResponseCustomizer.class})
    @Configuration(value="DelegatedAuthenticationSAML2IdPConfiguration", proxyBeanMethods=false)
    public static class DelegatedAuthenticationSAML2IdPConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"delegatedSaml2IdPResponseCustomizer"})
        public SamlIdPResponseCustomizer delegatedSaml2IdPResponseCustomizer(@Qualifier(value="delegatedIdentityProviders") DelegatedIdentityProviders identityProviders) {
            return new DelegatedAuthenticationSamlIdPResponseCustomizer(identityProviders);
        }
    }
}

