/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.ClientCredential;
import org.apereo.cas.authentication.principal.DelegatedAuthenticationCandidateProfile;
import org.apereo.cas.authentication.principal.DelegatedClientAuthenticationCredentialResolver;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.model.support.replication.SessionReplicationProperties;
import org.apereo.cas.logout.slo.SingleLogoutContinuation;
import org.apereo.cas.pac4j.client.DelegatedClientAuthenticationFailureEvaluator;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.web.flow.DelegatedAuthenticationSingleSignOnEvaluator;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationConfigurationContext;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationWebflowManager;
import org.apereo.cas.web.flow.DelegationWebflowUtils;
import org.apereo.cas.web.flow.actions.AbstractAuthenticationAction;
import org.apereo.cas.web.support.WebUtils;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.Client;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.http.AutomaticFormPostAction;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.exception.http.WithContentAction;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.http.HttpMethod;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DelegatedClientAuthenticationAction
extends AbstractAuthenticationAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedClientAuthenticationAction.class);
    protected final DelegatedClientAuthenticationConfigurationContext configContext;
    private final DelegatedClientAuthenticationWebflowManager delegatedClientAuthenticationWebflowManager;
    private final DelegatedClientAuthenticationFailureEvaluator failureEvaluator;
    private final DelegatedAuthenticationSingleSignOnEvaluator ssoEvaluator;

    public DelegatedClientAuthenticationAction(DelegatedClientAuthenticationConfigurationContext context, DelegatedClientAuthenticationWebflowManager delegatedClientAuthenticationWebflowManager, DelegatedClientAuthenticationFailureEvaluator failureEvaluator) {
        super(context.getInitialAuthenticationAttemptWebflowEventResolver(), context.getServiceTicketRequestWebflowEventResolver(), context.getAdaptiveAuthenticationPolicy());
        this.configContext = context;
        this.failureEvaluator = failureEvaluator;
        this.delegatedClientAuthenticationWebflowManager = delegatedClientAuthenticationWebflowManager;
        this.ssoEvaluator = new DelegatedAuthenticationSingleSignOnEvaluator(context);
    }

    protected Event doExecuteInternal(RequestContext context) {
        HttpServletResponse response;
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        JEEContext webContext = new JEEContext(request, response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context));
        String clientName = this.retrieveClientName((WebContext)webContext);
        Service service = StringUtils.isNotBlank((CharSequence)clientName) ? this.restoreAuthenticationRequestInContext(context, clientName) : null;
        Optional<ClientCredential> clientCredential = this.extractClientCredential(context, clientName);
        boolean isLogoutRequest = DelegatedClientAuthenticationAction.isLogoutRequest(clientCredential);
        try {
            boolean isSingleSignOnSessionActive;
            LOGGER.trace("Delegated authentication is handled by client name [{}]", (Object)clientName);
            boolean bl = isSingleSignOnSessionActive = StringUtils.isNotBlank((CharSequence)clientName) && !isLogoutRequest && !DelegationWebflowUtils.hasDelegatedClientAuthenticationCandidateProfile((RequestContext)context) && this.ssoEvaluator.singleSignOnSessionExists(context);
            if (isSingleSignOnSessionActive) {
                LOGGER.trace("Found an existing single sign-on session");
                service = this.populateContextWithService(context, service);
                if (this.ssoEvaluator.singleSignOnSessionAuthorizedForService(context)) {
                    return (Event)FunctionUtils.doUnchecked(() -> {
                        Set providers = this.configContext.getDelegatedClientIdentityProvidersProducer().produce(context);
                        LOGGER.debug("Skipping delegation and routing back to CAS authentication flow with providers [{}]", (Object)providers);
                        return super.doExecuteInternal(context);
                    });
                }
                FunctionUtils.doUnchecked(__ -> {
                    Service resolvedService = this.ssoEvaluator.resolveServiceFromRequestContext(context);
                    LOGGER.debug("Single sign-on session in unauthorized for service [{}]", (Object)resolvedService);
                    this.removeTicketGrantingTicketIfAny(context, clientName, resolvedService);
                }, (Object[])new Object[0]);
            } else if (StringUtils.isNotBlank((CharSequence)clientName) && !DelegatedClientAuthenticationAction.isLogoutRequest(clientCredential)) {
                LOGGER.debug("Single sign-on session in inactive for service [{}]", (Object)service);
                this.removeTicketGrantingTicketIfAny(context, clientName, service);
            }
            if (this.failureEvaluator.evaluate(request, response.getStatus()).isPresent()) {
                throw new IllegalArgumentException("Delegated authentication has failed with client " + clientName);
            }
            if (DelegationWebflowUtils.hasDelegatedClientAuthenticationCandidateProfile((RequestContext)context)) {
                DelegatedAuthenticationCandidateProfile profile = (DelegatedAuthenticationCandidateProfile)DelegationWebflowUtils.getDelegatedClientAuthenticationCandidateProfile((RequestContext)context, DelegatedAuthenticationCandidateProfile.class);
                UserProfile up = profile.toUserProfile(clientName);
                ClientCredential clientCredentialSelected = new ClientCredential(clientName, up);
                WebUtils.putCredential((RequestContext)context, (Credential)clientCredentialSelected);
                return super.doExecuteInternal(context);
            }
            if (clientCredential.isPresent()) {
                service = this.populateContextWithService(context, service);
                BaseClient client = this.findDelegatedClientByName(clientName);
                this.verifyClientIsAuthorizedForService(context, service, client);
                DelegationWebflowUtils.putDelegatedAuthenticationClientName((RequestContext)context, (String)client.getName());
                if (DelegatedClientAuthenticationAction.isLogoutRequest(clientCredential)) {
                    CallContext callContext = new CallContext((WebContext)webContext, this.configContext.getSessionStore());
                    throw client.processLogout(callContext, clientCredential.get().getCredentials());
                }
                return this.finalizeDelegatedClientAuthentication(context, clientCredential.get());
            }
            if (StringUtils.isNotBlank((CharSequence)clientName)) {
                String msg = "Client %s failed to validate credentials".formatted(clientName);
                LoggingUtils.error((Logger)LOGGER, (String)msg);
                return this.stopWebflow((Throwable)new AuthenticationException(msg), context);
            }
        }
        catch (HttpAction e) {
            FunctionUtils.doIf((boolean)LOGGER.isDebugEnabled(), o -> LOGGER.debug(e.getMessage(), (Throwable)e), o -> LOGGER.info(e.getMessage())).accept(e);
            SingleLogoutContinuation.SingleLogoutContinuationBuilder continuation = SingleLogoutContinuation.builder();
            clientCredential.ifPresent(cc -> continuation.context(CollectionUtils.wrap((String)ClientCredential.class.getName(), (Object)cc)));
            if (e instanceof AutomaticFormPostAction) {
                AutomaticFormPostAction formPostAction = (AutomaticFormPostAction)e;
                continuation.method(HttpMethod.POST).url(formPostAction.getUrl()).data(formPostAction.getData());
            }
            if (e instanceof WithContentAction) {
                WithContentAction withContentAction = (WithContentAction)e;
                continuation.content(withContentAction.getContent());
            }
            webContext.setRequestAttribute(SingleLogoutContinuation.class.getName(), (Object)continuation.build());
            return DelegatedClientAuthenticationAction.isLogoutRequest(clientCredential) ? this.getLogoutEvent(e) : this.success();
        }
        catch (UnauthorizedServiceException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return this.stopWebflow(e, context);
        }
        return this.getFinalEvent();
    }

    private void removeTicketGrantingTicketIfAny(RequestContext context, String clientName, Service resolvedService) throws Exception {
        String tgt = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        if (tgt != null) {
            this.configContext.getTicketRegistry().deleteTicket(tgt);
            BaseClient client = this.findDelegatedClientByName(clientName);
            this.verifyClientIsAuthorizedForService(context, resolvedService, client);
        }
    }

    private static boolean isLogoutRequest(Optional<ClientCredential> clientCredential) {
        return clientCredential.isPresent() && !clientCredential.get().getCredentials().isForAuthentication();
    }

    protected Optional<ClientCredential> extractClientCredential(RequestContext context, String clientName) {
        return (Optional)FunctionUtils.doIfNotBlank((CharSequence)clientName, () -> {
            BaseClient client = this.findDelegatedClientByName(clientName);
            DelegationWebflowUtils.putDelegatedAuthenticationClientName((RequestContext)context, (String)client.getName());
            Credential currentCredential = WebUtils.getCredential((RequestContext)context);
            if (currentCredential instanceof ClientCredential) {
                ClientCredential clientCredential = (ClientCredential)currentCredential;
                return Optional.of(clientCredential);
            }
            return this.populateContextWithClientCredential(client, context);
        }, Optional::empty);
    }

    protected Event finalizeDelegatedClientAuthentication(RequestContext context, ClientCredential credentials) throws Throwable {
        ArrayList strategies = new ArrayList(this.configContext.getApplicationContext().getBeansOfType(DelegatedClientAuthenticationCredentialResolver.class).values());
        AnnotationAwareOrderComparator.sortIfNecessary(strategies);
        List candidateMatches = strategies.stream().filter(BeanSupplier::isNotProxy).filter(strategy -> strategy.supports(credentials)).map(Unchecked.function(strategy -> strategy.resolve(context, credentials))).flatMap(Collection::stream).collect(Collectors.toList());
        if (candidateMatches.isEmpty()) {
            return super.doExecuteInternal(context);
        }
        DelegationWebflowUtils.putDelegatedClientAuthenticationResolvedCredentials((RequestContext)context, candidateMatches);
        return new Event((Object)this, "select");
    }

    private Event getLogoutEvent(HttpAction action) {
        return new Event((Object)this, "logout", (AttributeMap)new LocalAttributeMap("action", (Object)action));
    }

    private Event getFinalEvent() {
        return new Event((Object)this, "generate");
    }

    protected String retrieveClientName(WebContext webContext) {
        return this.configContext.getDelegatedClientNameExtractor().extract(webContext).orElse("");
    }

    protected Event doPreExecute(RequestContext context) throws Exception {
        SessionReplicationProperties replicationProps = this.configContext.getCasProperties().getAuthn().getPac4j().getCore().getSessionReplication();
        if (replicationProps.isReplicateSessions() && replicationProps.getCookie().isAutoConfigureCookiePath()) {
            String contextPath = context.getExternalContext().getContextPath();
            Object cookiePath = StringUtils.isNotBlank((CharSequence)contextPath) ? contextPath + "/" : "/";
            String path = this.configContext.getDelegatedClientDistributedSessionCookieGenerator().getCookiePath();
            if (StringUtils.isBlank((CharSequence)path)) {
                LOGGER.debug("Setting path for cookies for distributed session cookie generator to: [{}]", cookiePath);
                this.configContext.getDelegatedClientDistributedSessionCookieGenerator().setCookiePath((String)cookiePath);
            } else {
                LOGGER.trace("Delegated authentication cookie domain is [{}] with path [{}]", (Object)this.configContext.getDelegatedClientDistributedSessionCookieGenerator().getCookieDomain(), (Object)path);
            }
        }
        return super.doPreExecute(context);
    }

    protected Service populateContextWithService(RequestContext context, Service service) throws Throwable {
        if (service != null) {
            Service resolvedService = this.configContext.getAuthenticationRequestServiceSelectionStrategies().resolveService(service);
            LOGGER.trace("Authentication is resolved by service request from [{}]", (Object)service);
            RegisteredService registeredService = this.configContext.getServicesManager().findServiceBy(resolvedService);
            LOGGER.trace("Located registered service [{}] mapped to resolved service [{}]", (Object)registeredService, (Object)resolvedService);
            WebUtils.putRegisteredService((RequestContext)context, (RegisteredService)registeredService);
            WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)service);
        }
        return service;
    }

    protected Optional<ClientCredential> populateContextWithClientCredential(BaseClient client, RequestContext requestContext) {
        return this.configContext.getCredentialExtractors().stream().filter(BeanSupplier::isNotProxy).map(extractor -> extractor.extract(client, requestContext)).flatMap(Optional::stream).findFirst();
    }

    protected BaseClient findDelegatedClientByName(String clientName) {
        Optional clientResult = this.configContext.getIdentityProviders().findClient(clientName);
        if (clientResult.isEmpty()) {
            LOGGER.warn("Delegated client [{}] can not be located", (Object)clientName);
            throw UnauthorizedServiceException.denied((String)"Denied: %s".formatted(clientName));
        }
        BaseClient client = (BaseClient)clientResult.get();
        client.init();
        return client;
    }

    private void verifyClientIsAuthorizedForService(RequestContext requestContext, Service service, BaseClient client) {
        LOGGER.debug("Delegated authentication client is [{}] with service [{}]", (Object)client, (Object)service);
        if (service != null) {
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
            request.setAttribute("service", (Object)service);
        }
        if (!this.isDelegatedClientAuthorizedForService((Client)client, service, requestContext)) {
            LOGGER.error("Delegated client [{}] is not authorized by service [{}]", (Object)client, (Object)service);
            throw UnauthorizedServiceException.denied((String)"Denied: %s".formatted(service));
        }
    }

    protected Event stopWebflow(Throwable e, RequestContext requestContext) {
        requestContext.getFlashScope().put("rootCauseException", (Object)e);
        return new Event((Object)this, "stop", (AttributeMap)new LocalAttributeMap("error", (Object)e));
    }

    protected Service restoreAuthenticationRequestInContext(RequestContext requestContext, String givenClientName) {
        try {
            BaseClient clientResult = this.configContext.getIdentityProviders().findClient(givenClientName).map(BaseClient.class::cast).orElseThrow(() -> new IllegalArgumentException("Unable to find client " + givenClientName + " to restore authentication context"));
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
            HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
            JEEContext webContext = new JEEContext(request, response);
            return this.delegatedClientAuthenticationWebflowManager.retrieve(requestContext, (WebContext)webContext, (Client)clientResult);
        }
        catch (Throwable e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            throw UnauthorizedServiceException.denied((String)"Denied: %s".formatted(givenClientName));
        }
    }

    protected boolean isDelegatedClientAuthorizedForService(Client client, Service service, RequestContext requestContext) {
        return this.configContext.getDelegatedClientIdentityProviderAuthorizers().stream().allMatch(Unchecked.predicate(authz -> authz.isDelegatedClientAuthorizedForService(client, service, requestContext)));
    }

    @Generated
    public DelegatedClientAuthenticationConfigurationContext getConfigContext() {
        return this.configContext;
    }

    @Generated
    public DelegatedClientAuthenticationWebflowManager getDelegatedClientAuthenticationWebflowManager() {
        return this.delegatedClientAuthenticationWebflowManager;
    }

    @Generated
    public DelegatedClientAuthenticationFailureEvaluator getFailureEvaluator() {
        return this.failureEvaluator;
    }

    @Generated
    public DelegatedAuthenticationSingleSignOnEvaluator getSsoEvaluator() {
        return this.ssoEvaluator;
    }
}

