/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apereo.cas.pm.PasswordManagementQuery;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.web.flow.PasswordManagementWebflowUtils;
import org.apereo.cas.pm.web.flow.actions.BasePasswordManagementAction;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class VerifySecurityQuestionsAction
extends BasePasswordManagementAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(VerifySecurityQuestionsAction.class);
    private final PasswordManagementService passwordManagementService;

    protected Event doExecuteInternal(RequestContext requestContext) {
        return (Event)FunctionUtils.doUnchecked(() -> {
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
            String username = PasswordManagementWebflowUtils.getPasswordResetUsername(requestContext);
            PasswordManagementQuery query = PasswordManagementQuery.builder().username(username).build();
            Map questions = this.passwordManagementService.getSecurityQuestions(query);
            List canonicalQuestions = PasswordManagementService.canonicalizeSecurityQuestions((Map)questions);
            LOGGER.debug("Canonical security questions are [{}]", (Object)canonicalQuestions);
            AtomicInteger index = new AtomicInteger(0);
            long count = canonicalQuestions.stream().filter(question -> {
                String answer = request.getParameter("q" + index.getAndIncrement());
                String answerOnRecord = (String)questions.get(question);
                LOGGER.trace("Validating security question [{}] with answer [{}] against provided answer [{}] by username [{}]", new Object[]{question, answerOnRecord, answer, username});
                return this.passwordManagementService.isValidSecurityQuestionAnswer(query, question, answerOnRecord, answer);
            }).count();
            if (count == (long)questions.size()) {
                return this.success();
            }
            LOGGER.error("Unable to validate answers to all security questions; only validated [{}] question(s) successfully", (Object)count);
            return this.error();
        });
    }

    @Generated
    public VerifySecurityQuestionsAction(PasswordManagementService passwordManagementService) {
        this.passwordManagementService = passwordManagementService;
    }
}

