/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import java.util.Map;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.pm.PasswordManagementQuery;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.web.flow.PasswordManagementWebflowUtils;
import org.apereo.cas.ticket.AuthenticationAwareTicket;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class AccountProfilePreparePasswordManagementAction
extends BaseCasWebflowAction {
    private final PasswordManagementService passwordManagementService;
    private final CasConfigurationProperties casProperties;

    protected Event doExecuteInternal(RequestContext requestContext) throws Exception {
        WebUtils.putPasswordManagementEnabled((RequestContext)requestContext, (Boolean)this.casProperties.getAuthn().getPm().getCore().isEnabled());
        WebUtils.putForgotUsernameEnabled((RequestContext)requestContext, (Boolean)this.casProperties.getAuthn().getPm().getForgotUsername().isEnabled());
        WebUtils.putAccountProfileManagementEnabled((RequestContext)requestContext, (Boolean)true);
        boolean secQuestionsEnabled = this.casProperties.getAuthn().getPm().getReset().isSecurityQuestionsEnabled() && this.casProperties.getAuthn().getPm().getCore().isEnabled();
        WebUtils.putSecurityQuestionsEnabled((RequestContext)requestContext, (Boolean)secQuestionsEnabled);
        Ticket tgt = WebUtils.getTicketGrantingTicket((RequestContext)requestContext);
        return (Event)FunctionUtils.doUnchecked(() -> {
            if (secQuestionsEnabled && tgt instanceof AuthenticationAwareTicket) {
                AuthenticationAwareTicket aat = (AuthenticationAwareTicket)tgt;
                Principal principal = aat.getAuthentication().getPrincipal();
                PasswordManagementQuery query = PasswordManagementQuery.builder().username(principal.getId()).build();
                Map questions = this.passwordManagementService.getSecurityQuestions(query);
                PasswordManagementWebflowUtils.putPasswordResetSecurityQuestions(requestContext, questions);
            }
            return null;
        });
    }

    @Generated
    public AccountProfilePreparePasswordManagementAction(PasswordManagementService passwordManagementService, CasConfigurationProperties casProperties) {
        this.passwordManagementService = passwordManagementService;
        this.casProperties = casProperties;
    }

    @Generated
    public PasswordManagementService getPasswordManagementService() {
        return this.passwordManagementService;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }
}

