/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache;

import com.github.benmanes.caffeine.cache.CacheLoader;
import java.time.Clock;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.CachedMetadataResolverResult;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCacheKey;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.SamlRegisteredServiceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.plan.SamlRegisteredServiceMetadataResolutionPlan;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.concurrent.CasReentrantLock;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.jooq.lambda.Unchecked;
import org.opensaml.saml.metadata.resolver.ChainingMetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlRegisteredServiceMetadataResolverCacheLoader
implements CacheLoader<SamlRegisteredServiceCacheKey, CachedMetadataResolverResult> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlRegisteredServiceMetadataResolverCacheLoader.class);
    protected final OpenSamlConfigBean configBean;
    protected final HttpClient httpClient;
    private final CasReentrantLock lock = new CasReentrantLock();
    private final SamlRegisteredServiceMetadataResolutionPlan metadataResolutionPlan;

    public CachedMetadataResolverResult load(SamlRegisteredServiceCacheKey cacheKey) {
        return (CachedMetadataResolverResult)this.lock.tryLock(() -> {
            List<MetadataResolver> metadataResolvers = this.loadMetadataResolvers(cacheKey);
            if (metadataResolvers.isEmpty()) {
                SamlRegisteredService registeredService = cacheKey.getRegisteredService();
                String metadataLocation = SpringExpressionLanguageValueResolver.getInstance().resolve(registeredService.getMetadataLocation());
                throw new SamlException("No metadata resolvers could be configured for service " + registeredService.getName() + " with metadata location " + metadataLocation);
            }
            MetadataResolver metadataResolver = this.initializeChainingMetadataResolver(metadataResolvers);
            LOGGER.debug("Metadata resolvers active for this request are [{}]", metadataResolvers);
            return CachedMetadataResolverResult.builder().cachedInstant(Instant.now(Clock.systemUTC())).metadataResolver(metadataResolver).build();
        });
    }

    protected MetadataResolver initializeChainingMetadataResolver(List<MetadataResolver> metadataResolvers) {
        return (MetadataResolver)FunctionUtils.doUnchecked(() -> {
            ChainingMetadataResolver metadataResolver = new ChainingMetadataResolver();
            metadataResolver.setId(ChainingMetadataResolver.class.getCanonicalName());
            LOGGER.trace("There are [{}] eligible metadata resolver(s) for this request", (Object)metadataResolvers.size());
            metadataResolver.setResolvers(metadataResolvers);
            metadataResolver.initialize();
            return metadataResolver;
        });
    }

    protected List<MetadataResolver> loadMetadataResolvers(SamlRegisteredServiceCacheKey cacheKey) {
        Collection<SamlRegisteredServiceMetadataResolver> availableResolvers = this.metadataResolutionPlan.getRegisteredMetadataResolvers();
        LOGGER.debug("There are [{}] metadata resolver(s) available in the chain", (Object)availableResolvers.size());
        SamlRegisteredService registeredService = cacheKey.getRegisteredService();
        return availableResolvers.stream().filter(Objects::nonNull).filter(resolver -> {
            LOGGER.trace("Evaluating whether metadata resolver [{}] can support service [{}]", (Object)resolver.getName(), (Object)registeredService.getName());
            return resolver.supports(registeredService);
        }).map(Unchecked.function(resolver -> {
            LOGGER.trace("Metadata resolver [{}] has started to process metadata for [{}]", (Object)resolver.getName(), (Object)registeredService.getName());
            return resolver.resolve(registeredService, cacheKey.getCriteriaSet());
        })).flatMap(Collection::stream).filter(Objects::nonNull).peek(Unchecked.consumer(givenResolver -> {
            AbstractIdentifiableInitializableComponent metadataResolver;
            if (givenResolver instanceof AbstractIdentifiableInitializableComponent && !(metadataResolver = (AbstractIdentifiableInitializableComponent)givenResolver).isInitialized()) {
                FunctionUtils.doIfBlank((CharSequence)metadataResolver.getId(), __ -> metadataResolver.setId(registeredService.getName() + "-" + RandomUtils.generateSecureRandomId()));
                LOGGER.trace("Metadata resolver [{}] will be forcefully initialized", (Object)metadataResolver.getId());
                metadataResolver.initialize();
            }
        })).collect(Collectors.toList());
    }

    @Generated
    public SamlRegisteredServiceMetadataResolverCacheLoader(OpenSamlConfigBean configBean, HttpClient httpClient, SamlRegisteredServiceMetadataResolutionPlan metadataResolutionPlan) {
        this.configBean = configBean;
        this.httpClient = httpClient;
        this.metadataResolutionPlan = metadataResolutionPlan;
    }
}

