/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.MutableCredential;
import org.apereo.cas.authentication.SurrogateAuthenticationPrincipalBuilder;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationService;
import org.apereo.cas.authentication.surrogate.SurrogateCredentialTrait;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class LoadSurrogatesListAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadSurrogatesListAction.class);
    private final SurrogateAuthenticationService surrogateService;
    private final SurrogateAuthenticationPrincipalBuilder surrogatePrincipalBuilder;

    private boolean loadSurrogates(RequestContext requestContext) throws Throwable {
        Credential credential = WebUtils.getCredential((RequestContext)requestContext, Credential.class);
        if (credential instanceof MutableCredential) {
            MutableCredential mc = (MutableCredential)credential;
            String username = mc.getId();
            LOGGER.debug("Loading eligible accounts for [{}] to proxy", (Object)username);
            Optional<WebApplicationService> service = Optional.ofNullable(WebUtils.getService((RequestContext)requestContext));
            ArrayList surrogates = this.surrogateService.getImpersonationAccounts(username, service).stream().sorted().distinct().collect(Collectors.toCollection(ArrayList::new));
            LOGGER.debug("Surrogate accounts found are [{}]", (Object)surrogates);
            if (!surrogates.isEmpty()) {
                if (!surrogates.contains(username) && !this.surrogateService.isWildcardedAccount((Collection)surrogates, service)) {
                    surrogates.addFirst(username);
                }
                WebUtils.putSurrogateAuthenticationAccounts((RequestContext)requestContext, (List)surrogates);
                return true;
            }
            LOGGER.debug("No surrogate accounts could be located for [{}]", (Object)username);
        } else {
            LOGGER.debug("Credential is not supported for surrogate authentication");
        }
        return false;
    }

    protected Event doExecuteInternal(RequestContext requestContext) {
        try {
            MutableCredential mc;
            if (WebUtils.hasSurrogateAuthenticationRequest((RequestContext)requestContext)) {
                WebUtils.removeSurrogateAuthenticationRequest((RequestContext)requestContext);
                return this.loadSurrogateAccounts(requestContext);
            }
            Credential currentCredential = WebUtils.getCredential((RequestContext)requestContext, Credential.class);
            if (currentCredential instanceof MutableCredential && (mc = (MutableCredential)currentCredential).getCredentialMetadata().getTrait(SurrogateCredentialTrait.class).stream().anyMatch(trait -> StringUtils.isNotBlank((CharSequence)trait.getSurrogateUsername()))) {
                AuthenticationResultBuilder authenticationResultBuilder = WebUtils.getAuthenticationResultBuilder((RequestContext)requestContext);
                RegisteredService registeredService = WebUtils.getRegisteredService((RequestContext)requestContext);
                Optional result = this.surrogatePrincipalBuilder.buildSurrogateAuthenticationResult(authenticationResultBuilder, currentCredential, registeredService);
                result.ifPresent(builder -> WebUtils.putAuthenticationResultBuilder((AuthenticationResultBuilder)builder, (RequestContext)requestContext));
            }
            return this.success();
        }
        catch (Throwable e) {
            requestContext.getMessageContext().addMessage(new MessageBuilder().error().source((Object)"surrogate").code("screen.surrogates.account.selection.error").defaultText("Unable to accept or authorize selection").build());
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return this.error(new RuntimeException(e));
        }
    }

    protected Event loadSurrogateAccounts(RequestContext requestContext) throws Throwable {
        LOGGER.trace("Attempting to load surrogates...");
        EventFactorySupport eventFactorySupport = new EventFactorySupport();
        if (this.loadSurrogates(requestContext)) {
            Optional<WebApplicationService> service;
            List accounts = WebUtils.getSurrogateAuthenticationAccounts((RequestContext)requestContext);
            if (this.surrogateService.isWildcardedAccount((Collection)accounts, service = Optional.ofNullable(WebUtils.getService((RequestContext)requestContext)))) {
                return eventFactorySupport.event((Object)this, "surrogateWildcardView");
            }
            return eventFactorySupport.event((Object)this, "surrogateListView");
        }
        return eventFactorySupport.event((Object)this, "skipSurrogateView");
    }

    @Generated
    public LoadSurrogatesListAction(SurrogateAuthenticationService surrogateService, SurrogateAuthenticationPrincipalBuilder surrogatePrincipalBuilder) {
        this.surrogateService = surrogateService;
        this.surrogatePrincipalBuilder = surrogatePrincipalBuilder;
    }
}

