/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.syncope;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.exceptions.AccountDisabledException;
import org.apereo.cas.authentication.exceptions.AccountPasswordMustChangeException;
import org.apereo.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.configuration.model.support.syncope.SyncopeAuthenticationProperties;
import org.apereo.cas.monitor.Monitorable;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.syncope.SyncopeUtils;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpExecutionRequest;
import org.apereo.cas.util.http.HttpUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

@Monitorable
public class SyncopeAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncopeAuthenticationHandler.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private final SyncopeAuthenticationProperties properties;
    private final String syncopeDomain;

    public SyncopeAuthenticationHandler(SyncopeAuthenticationProperties properties, ServicesManager servicesManager, PrincipalFactory principalFactory, String syncopeDomain) {
        super(properties.getName(), servicesManager, principalFactory, Integer.valueOf(properties.getOrder()));
        this.properties = properties;
        this.syncopeDomain = syncopeDomain;
    }

    protected AuthenticationHandlerExecutionResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential, String originalPassword) throws Throwable {
        Optional<JsonNode> result = this.authenticateSyncopeUser(credential);
        if (result.isPresent()) {
            JsonNode user = result.get();
            LOGGER.debug("Received user object as [{}]", (Object)user);
            if (user.has("suspended") && user.get("suspended").asBoolean()) {
                throw new AccountDisabledException("Could not authenticate forbidden account for " + credential.getUsername());
            }
            if (user.has("mustChangePassword") && user.get("mustChangePassword").asBoolean()) {
                throw new AccountPasswordMustChangeException("Account password must change for " + credential.getUsername());
            }
            Principal principal = this.principalFactory.createPrincipal(user.get("username").asText(), SyncopeUtils.convertFromUserEntity(user, this.properties.getAttributeMappings()));
            return this.createHandlerResult((Credential)credential, principal, new ArrayList(0));
        }
        throw new FailedLoginException("Could not authenticate account for " + credential.getUsername());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Optional<JsonNode> authenticateSyncopeUser(UsernamePasswordCredential credential) {
        HttpResponse response;
        block2: {
            Optional<JsonNode> optional;
            response = null;
            try {
                String syncopeRestUrl = StringUtils.appendIfMissing((String)SpringExpressionLanguageValueResolver.getInstance().resolve(this.properties.getUrl()), (CharSequence)"/rest/users/self", (CharSequence[])new CharSequence[0]);
                HttpExecutionRequest exec = HttpExecutionRequest.builder().method(HttpMethod.GET).url(syncopeRestUrl).basicAuthUsername(credential.getUsername()).basicAuthPassword(credential.toPassword()).headers(CollectionUtils.wrap((String)"X-Syncope-Domain", (Object)this.syncopeDomain)).build();
                response = Objects.requireNonNull(HttpUtils.execute((HttpExecutionRequest)exec));
                LOGGER.debug("Received http response status as [{}]", (Object)response.getReasonPhrase());
                if (response.getCode() != 200) break block2;
                optional = SyncopeAuthenticationHandler.parseResponseResults((HttpEntityContainer)response);
            }
            catch (Throwable throwable) {
                HttpUtils.close(response);
                throw throwable;
            }
            HttpUtils.close((HttpResponse)response);
            return optional;
        }
        HttpUtils.close((HttpResponse)response);
        return Optional.empty();
    }

    private static Optional<JsonNode> parseResponseResults(HttpEntityContainer response) {
        return (Optional)FunctionUtils.doUnchecked(() -> {
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            LOGGER.debug("Received user object as [{}]", (Object)result);
            return Optional.of(MAPPER.readTree(result));
        });
    }
}

