/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import jakarta.annotation.Nonnull;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.web.view.ViewProperties;
import org.apereo.cas.configuration.model.support.cookie.TicketGrantingCookieProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.web.AggregateCasThemeSource;
import org.apereo.cas.services.web.ChainingThemeResolver;
import org.apereo.cas.services.web.DefaultCasThemeSource;
import org.apereo.cas.services.web.RegisteredServiceThemeResolver;
import org.apereo.cas.services.web.RequestHeaderThemeResolver;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafProperties;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.io.Resource;
import org.springframework.ui.context.ThemeSource;
import org.springframework.web.servlet.ThemeResolver;
import org.springframework.web.servlet.config.annotation.ResourceChainRegistration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.resource.PathResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.theme.CookieThemeResolver;
import org.springframework.web.servlet.theme.FixedThemeResolver;
import org.springframework.web.servlet.theme.SessionThemeResolver;

@EnableConfigurationProperties(value={CasConfigurationProperties.class, ThymeleafProperties.class, WebProperties.class})
@AutoConfigureOrder(value=0x7FFFFFFF)
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Thymeleaf})
@AutoConfiguration
public class CasThemesAutoConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasThemesAutoConfiguration.class);

    @ConditionalOnMissingBean(name={"casThemeSource"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public ThemeSource themeSource(CasConfigurationProperties casProperties) {
        if (casProperties.getView().getThemeSourceType() == ViewProperties.ThemeSourceTypes.AGGREGATE) {
            return new AggregateCasThemeSource(casProperties);
        }
        return new DefaultCasThemeSource(casProperties);
    }

    @ConditionalOnMissingBean(name={"casThemeResolver"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public ThemeResolver themeResolver(ObjectProvider<CasConfigurationProperties> casProperties, @Qualifier(value="authenticationServiceSelectionPlan") ObjectProvider<AuthenticationServiceSelectionPlan> authenticationRequestServiceSelectionStrategies, @Qualifier(value="servicesManager") ObjectProvider<ServicesManager> servicesManager) {
        String defaultThemeName = ((CasConfigurationProperties)casProperties.getObject()).getTheme().getDefaultThemeName();
        FixedThemeResolver fixedResolver = new FixedThemeResolver();
        fixedResolver.setDefaultThemeName(defaultThemeName);
        SessionThemeResolver sessionThemeResolver = new SessionThemeResolver();
        sessionThemeResolver.setDefaultThemeName(defaultThemeName);
        TicketGrantingCookieProperties tgc = ((CasConfigurationProperties)casProperties.getObject()).getTgc();
        CookieThemeResolver cookieThemeResolver = new CookieThemeResolver();
        cookieThemeResolver.setDefaultThemeName(defaultThemeName);
        cookieThemeResolver.setCookieDomain(tgc.getDomain());
        cookieThemeResolver.setCookieHttpOnly(tgc.isHttpOnly());
        cookieThemeResolver.setCookieMaxAge(Integer.valueOf(tgc.getMaxAge()));
        cookieThemeResolver.setCookiePath(tgc.getPath());
        cookieThemeResolver.setCookieSecure(tgc.isSecure());
        RegisteredServiceThemeResolver serviceThemeResolver = new RegisteredServiceThemeResolver(servicesManager, authenticationRequestServiceSelectionStrategies, casProperties);
        serviceThemeResolver.setDefaultThemeName(defaultThemeName);
        RequestHeaderThemeResolver header = new RequestHeaderThemeResolver(((CasConfigurationProperties)casProperties.getObject()).getTheme().getParamName());
        header.setDefaultThemeName(defaultThemeName);
        ChainingThemeResolver chainingThemeResolver = new ChainingThemeResolver();
        chainingThemeResolver.addResolver((ThemeResolver)cookieThemeResolver).addResolver((ThemeResolver)sessionThemeResolver).addResolver((ThemeResolver)header).addResolver((ThemeResolver)serviceThemeResolver).addResolver((ThemeResolver)fixedResolver);
        chainingThemeResolver.setDefaultThemeName(defaultThemeName);
        return chainingThemeResolver;
    }

    @Bean
    @ConditionalOnMissingBean(name={"themesStaticResourcesWebMvcConfigurer"})
    public WebMvcConfigurer themesStaticResourcesWebMvcConfigurer(final CasConfigurationProperties casProperties, final WebProperties webProperties, final ThymeleafProperties thymeleafProperties) {
        return new WebMvcConfigurer(){

            public void addResourceHandlers(@Nonnull ResourceHandlerRegistry registry) {
                List templatePrefixes = casProperties.getView().getTemplatePrefixes();
                if (!templatePrefixes.isEmpty()) {
                    ResourceHandlerRegistration registration = registry.addResourceHandler(new String[]{"/**"});
                    String[] locations = (String[])templatePrefixes.stream().map(prefix -> StringUtils.appendIfMissing((String)prefix, (CharSequence)"/", (CharSequence[])new CharSequence[0])).toArray(String[]::new);
                    registration.addResourceLocations(locations);
                    registration.addResourceLocations(webProperties.getResources().getStaticLocations());
                    FunctionUtils.doIfNotNull((Object)webProperties.getResources().getCache().getPeriod(), period -> registration.setCachePeriod(Integer.valueOf((int)period.getSeconds())));
                    registration.setCacheControl(webProperties.getResources().getCache().getCachecontrol().toHttpCacheControl());
                    registration.setUseLastModified(true);
                    boolean cache = thymeleafProperties != null && thymeleafProperties.isCache();
                    ResourceChainRegistration chainRegistration = registration.resourceChain(cache);
                    PathResourceResolver resolver = new PathResourceResolver();
                    Resource[] resources = (Resource[])templatePrefixes.stream().map(prefix -> StringUtils.appendIfMissing((String)prefix, (CharSequence)"/", (CharSequence[])new CharSequence[0])).map(Unchecked.function(ResourceUtils::getRawResourceFrom)).toArray(Resource[]::new);
                    LOGGER.debug("Adding resource handler for resources [{}]", (Object[])resources);
                    resolver.setAllowedLocations(resources);
                    chainRegistration.addResolver((ResourceResolver)resolver);
                }
            }
        };
    }
}

