/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.trusted.authentication.DefaultMultifactorAuthenticationTrustedDeviceBypassEvaluator;
import org.apereo.cas.trusted.authentication.MultifactorAuthenticationTrustedDeviceBypassEvaluator;
import org.apereo.cas.trusted.authentication.MultifactorAuthenticationTrustedDeviceNamingStrategy;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.trusted.web.flow.DefaultMultifactorAuthenticationTrustedDeviceProviderAction;
import org.apereo.cas.trusted.web.flow.MultifactorAuthenticationPrepareTrustDeviceViewAction;
import org.apereo.cas.trusted.web.flow.MultifactorAuthenticationRemoveTrustedDeviceAction;
import org.apereo.cas.trusted.web.flow.MultifactorAuthenticationSetTrustAction;
import org.apereo.cas.trusted.web.flow.MultifactorAuthenticationTrustProviderSelectionCriteria;
import org.apereo.cas.trusted.web.flow.MultifactorAuthenticationTrustedDeviceAccountProfileWebflowConfigurer;
import org.apereo.cas.trusted.web.flow.MultifactorAuthenticationVerifyTrustAction;
import org.apereo.cas.trusted.web.flow.fingerprint.DeviceFingerprintStrategy;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.actions.MultifactorAuthenticationTrustedDeviceProviderAction;
import org.apereo.cas.web.flow.actions.WebflowActionBeanSupplier;
import org.apereo.cas.web.flow.actions.composite.MultifactorProviderSelectionCriteria;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.MultifactorAuthenticationTrustedDevices})
@Configuration(value="MultifactorAuthnTrustWebflowConfiguration", proxyBeanMethods=false)
class MultifactorAuthnTrustWebflowConfiguration {
    MultifactorAuthnTrustWebflowConfiguration() {
    }

    @Configuration(value="TrustedAuthenticationAccountProfileWebflowConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.AccountManagement}, enabledByDefault=false)
    @AutoConfigureOrder(value=0x7FFFFFFF)
    static class MultifactorAuthnTrustAccountProfileWebflowConfiguration {
        MultifactorAuthnTrustAccountProfileWebflowConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"accountProfileMultifactorTrustedDeviceWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer accountProfileMultifactorTrustedDeviceWebflowExecutionPlanConfigurer(@Qualifier(value="accountProfileMultifactorTrustedDeviceWebflowConfigurer") CasWebflowConfigurer accountProfileMultifactorTrustedDeviceWebflowConfigurer) {
            return plan -> plan.registerWebflowConfigurer(accountProfileMultifactorTrustedDeviceWebflowConfigurer);
        }

        @ConditionalOnMissingBean(name={"accountProfileMultifactorTrustedDeviceWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer accountProfileMultifactorTrustedDeviceWebflowConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry flowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            return (CasWebflowConfigurer)BeanSupplier.of(CasWebflowConfigurer.class).alwaysMatch().supply(() -> new MultifactorAuthenticationTrustedDeviceAccountProfileWebflowConfigurer(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties)).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"multifactorAuthenticationTrustedDeviceProviderAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrustedDeviceProviderAction multifactorAuthenticationTrustedDeviceProviderAction(@Qualifier(value="mfaTrustEngine") MultifactorAuthenticationTrustStorage mfaTrustEngine, ConfigurableApplicationContext applicationContext) {
            return new DefaultMultifactorAuthenticationTrustedDeviceProviderAction(applicationContext, mfaTrustEngine);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"accountProfileRemoveMultifactorTrustedDeviceAction"})
        public Action accountProfileRemoveMultifactorTrustedDeviceAction(@Qualifier(value="mfaTrustEngine") MultifactorAuthenticationTrustStorage mfaTrustEngine, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new MultifactorAuthenticationRemoveTrustedDeviceAction(applicationContext, mfaTrustEngine)).withId("accountProfileRemoveMultifactorTrustedDeviceAction").build().get();
        }
    }

    @Configuration(value="MultifactorAuthnTrustCoreWebflowConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class MultifactorAuthnTrustCoreWebflowConfiguration {
        MultifactorAuthnTrustCoreWebflowConfiguration() {
        }

        @ConditionalOnMissingBean(name={"mfaTrustedDeviceBypassEvaluator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrustedDeviceBypassEvaluator mfaTrustedDeviceBypassEvaluator(@Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer) {
            return new DefaultMultifactorAuthenticationTrustedDeviceBypassEvaluator(registeredServiceAccessStrategyEnforcer);
        }

        @ConditionalOnMissingBean(name={"mfaSetTrustAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action mfaSetTrustAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="mfaTrustedDeviceBypassEvaluator") MultifactorAuthenticationTrustedDeviceBypassEvaluator mfaTrustedDeviceBypassEvaluator, @Qualifier(value="deviceFingerprintStrategy") DeviceFingerprintStrategy deviceFingerprintStrategy, @Qualifier(value="mfaTrustEngine") MultifactorAuthenticationTrustStorage mfaTrustEngine, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new MultifactorAuthenticationSetTrustAction(mfaTrustEngine, deviceFingerprintStrategy, casProperties.getAuthn().getMfa().getTrusted(), registeredServiceAccessStrategyEnforcer, mfaTrustedDeviceBypassEvaluator)).withId("mfaSetTrustAction").build().get();
        }

        @ConditionalOnMissingBean(name={"mfaVerifyTrustAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action mfaVerifyTrustAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="mfaTrustedDeviceBypassEvaluator") MultifactorAuthenticationTrustedDeviceBypassEvaluator mfaTrustedDeviceBypassEvaluator, @Qualifier(value="deviceFingerprintStrategy") DeviceFingerprintStrategy deviceFingerprintStrategy, @Qualifier(value="mfaTrustEngine") MultifactorAuthenticationTrustStorage mfaTrustEngine, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new MultifactorAuthenticationVerifyTrustAction(mfaTrustEngine, deviceFingerprintStrategy, casProperties.getAuthn().getMfa().getTrusted(), registeredServiceAccessStrategyEnforcer, mfaTrustedDeviceBypassEvaluator)).withId("mfaVerifyTrustAction").build().get();
        }

        @ConditionalOnMissingBean(name={"mfaPrepareTrustDeviceViewAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action mfaPrepareTrustDeviceViewAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="mfaTrustedDeviceBypassEvaluator") MultifactorAuthenticationTrustedDeviceBypassEvaluator mfaTrustedDeviceBypassEvaluator, @Qualifier(value="deviceFingerprintStrategy") DeviceFingerprintStrategy deviceFingerprintStrategy, @Qualifier(value="mfaTrustDeviceNamingStrategy") MultifactorAuthenticationTrustedDeviceNamingStrategy mfaTrustDeviceNamingStrategy, @Qualifier(value="mfaTrustEngine") MultifactorAuthenticationTrustStorage mfaTrustEngine, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new MultifactorAuthenticationPrepareTrustDeviceViewAction(mfaTrustEngine, deviceFingerprintStrategy, casProperties.getAuthn().getMfa().getTrusted(), registeredServiceAccessStrategyEnforcer, servicesManager, mfaTrustedDeviceBypassEvaluator, mfaTrustDeviceNamingStrategy)).withId("mfaPrepareTrustDeviceViewAction").build().get();
        }

        @ConditionalOnMissingBean(name={"mfaTrustProviderSelectionCriteria"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorProviderSelectionCriteria mfaTrustProviderSelectionCriteria(CasConfigurationProperties casProperties, @Qualifier(value="deviceFingerprintCookieGenerator") CasCookieBuilder deviceFingerprintCookieGenerator, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="mfaTrustEngine") MultifactorAuthenticationTrustStorage mfaTrustEngine, @Qualifier(value="mfaTrustDeviceNamingStrategy") MultifactorAuthenticationTrustedDeviceNamingStrategy mfaTrustDeviceNamingStrategy, @Qualifier(value="deviceFingerprintStrategy") DeviceFingerprintStrategy deviceFingerprintStrategy) {
            return new MultifactorAuthenticationTrustProviderSelectionCriteria(servicesManager, mfaTrustEngine, mfaTrustDeviceNamingStrategy, deviceFingerprintStrategy, deviceFingerprintCookieGenerator, casProperties);
        }
    }
}

