/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.client;

import java.lang.reflect.Method;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.artificer.atom.err.ArtificerAtomException;
import org.artificer.atom.i18n.Messages;
import org.artificer.atom.providers.ArtificerConflictExceptionProvider;
import org.artificer.atom.providers.ArtificerNotFoundExceptionProvider;
import org.artificer.atom.providers.ArtificerServerExceptionProvider;
import org.artificer.atom.providers.ArtificerWrongModelExceptionProvider;
import org.artificer.atom.providers.HttpResponseProvider;
import org.artificer.common.error.ArtificerConflictException;
import org.artificer.common.error.ArtificerNotFoundException;
import org.artificer.common.error.ArtificerServerException;
import org.artificer.common.error.ArtificerWrongModelException;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ClientRequest
extends org.jboss.resteasy.client.ClientRequest {
    private static final ResteasyProviderFactory providerFactory = new ResteasyProviderFactory();
    private static Method uriBuilderMethod;

    private static UriBuilder getBuilder(String uriTemplate) {
        try {
            return (UriBuilder)uriBuilderMethod.invoke(null, uriTemplate);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ClientRequest(String uriTemplate) {
        super(ClientRequest.getBuilder(uriTemplate), ClientRequest.getDefaultExecutor(), providerFactory);
    }

    public ClientRequest(String uriTemplate, ClientExecutor clientExecutor) {
        super(ClientRequest.getBuilder(uriTemplate), clientExecutor, providerFactory);
    }

    public <T> ClientResponse<T> post(Class<T> returnType) throws Exception {
        ClientResponse response = super.post(returnType);
        this.handlePotentialServerError(response);
        return response;
    }

    public ClientResponse post() throws Exception {
        ClientResponse response = super.post();
        this.handlePotentialServerError(response);
        return response;
    }

    public <T> ClientResponse<T> get(Class<T> returnType) throws Exception {
        ClientResponse response = super.get(returnType);
        this.handlePotentialServerError(response);
        return response;
    }

    public ClientResponse get() throws Exception {
        ClientResponse response = super.get();
        this.handlePotentialServerError(response);
        return response;
    }

    public <T> ClientResponse<T> put(Class<T> returnType) throws Exception {
        ClientResponse response = super.put(returnType);
        this.handlePotentialServerError(response);
        return response;
    }

    public ClientResponse put() throws Exception {
        ClientResponse response = super.put();
        this.handlePotentialServerError(response);
        return response;
    }

    public <T> ClientResponse<T> delete(Class<T> returnType) throws Exception {
        ClientResponse response = super.delete(returnType);
        this.handlePotentialServerError(response);
        return response;
    }

    public ClientResponse delete() throws Exception {
        ClientResponse response = super.delete();
        this.handlePotentialServerError(response);
        return response;
    }

    private <T> void handlePotentialServerError(ClientResponse<T> response) throws Exception {
        String contentType = String.valueOf(response.getMetadata().getFirst((Object)"Content-Type"));
        Response.Status status = Response.Status.fromStatusCode((int)response.getStatus());
        if ("application/artificer-server-exception".equals(contentType)) {
            throw (ArtificerServerException)((Object)response.getEntity(ArtificerServerException.class));
        }
        if ("application/artificer-conflict-exception".equals(contentType)) {
            throw (ArtificerConflictException)response.getEntity(ArtificerConflictException.class);
        }
        if ("application/artificer-notfound-exception".equals(contentType)) {
            throw (ArtificerNotFoundException)response.getEntity(ArtificerNotFoundException.class);
        }
        if ("application/artificer-wrongmodel-exception".equals(contentType)) {
            throw (ArtificerWrongModelException)response.getEntity(ArtificerWrongModelException.class);
        }
        switch (status) {
            case INTERNAL_SERVER_ERROR: {
                throw new Exception(Messages.i18n.format("UNKNOWN_ARTIFICER_ERROR", new Object[0]));
            }
            case NOT_FOUND: 
            case UNSUPPORTED_MEDIA_TYPE: {
                throw new ArtificerAtomException(Messages.i18n.format("ENDPOINT_NOT_FOUND", new Object[0]));
            }
            case FORBIDDEN: {
                throw new ArtificerAtomException(Messages.i18n.format("AUTHORIZATION_FAILED", new Object[0]));
            }
            case UNAUTHORIZED: {
                throw new ArtificerAtomException(Messages.i18n.format("AUTHENTICATION_FAILED", new Object[0]));
            }
        }
    }

    static {
        RegisterBuiltin.register((ResteasyProviderFactory)providerFactory);
        providerFactory.registerProvider(ArtificerServerExceptionProvider.class);
        providerFactory.registerProvider(ArtificerConflictExceptionProvider.class);
        providerFactory.registerProvider(ArtificerNotFoundExceptionProvider.class);
        providerFactory.registerProvider(ArtificerWrongModelExceptionProvider.class);
        providerFactory.registerProvider(HttpResponseProvider.class);
        uriBuilderMethod = null;
        try {
            Class<?> uriBuilderClass = ClientRequest.class.getClassLoader().loadClass("org.jboss.resteasy.specimpl.ResteasyUriBuilder");
            uriBuilderMethod = uriBuilderClass.getMethod("fromUri", String.class);
        }
        catch (Exception e) {
            try {
                Class<?> uriBuilderClass = ClientRequest.class.getClassLoader().loadClass("org.jboss.resteasy.specimpl.UriBuilderImpl");
                uriBuilderMethod = uriBuilderClass.getMethod("fromUri", String.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

