/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.client.query;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.artificer.atom.ArtificerAtomUtils;
import org.artificer.common.ArtifactType;
import org.artificer.common.ArtificerModelUtils;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Person;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;

public class ArtifactSummary {
    private final Entry entry;
    private BaseArtifactType artifact;

    public ArtifactSummary(Entry entry) {
        this.entry = entry;
    }

    public ArtifactType getType() {
        return ArtificerAtomUtils.getArtifactType((Entry)this.entry);
    }

    public String getUuid() {
        return this.entry.getId().toString().replace("urn:uuid:", "");
    }

    public Date getLastModifiedTimestamp() {
        return this.entry.getUpdated();
    }

    public String getName() {
        return this.entry.getTitle();
    }

    public Date getCreatedTimestamp() {
        return this.entry.getPublished();
    }

    public String getCreatedBy() {
        return ((Person)this.entry.getAuthors().get(0)).getName();
    }

    public String getDescription() {
        return this.entry.getSummary();
    }

    public boolean isExtendedType() {
        return this.getType().isExtendedType();
    }

    public boolean isDerived() {
        return this.getType().isDerived();
    }

    public String getCustomPropertyValue(String propertyName) {
        if (this.artifact == null) {
            this.artifact = ArtificerAtomUtils.unwrapSrampArtifact((Entry)this.entry);
        }
        if (this.artifact != null) {
            return ArtificerModelUtils.getCustomProperty((BaseArtifactType)this.artifact, (String)propertyName);
        }
        return null;
    }

    public Map<String, String> getCustomPropertiesByPrefix(String prefix) {
        Map<String, String> result = new HashMap<String, String>();
        if (this.artifact == null) {
            this.artifact = ArtificerAtomUtils.unwrapSrampArtifact((Entry)this.entry);
        }
        if (this.artifact != null) {
            result = ArtificerModelUtils.getCustomPropertiesByPrefix((BaseArtifactType)this.artifact, (String)prefix);
        }
        return result;
    }

    public Object getExtensionAttribute(Object name) {
        return this.entry.getExtensionAttributes().get(name);
    }
}

