/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.integration.switchyard.artifactbuilder;

import java.io.IOException;
import java.util.Collection;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.artificer.common.ArtifactType;
import org.artificer.common.ArtifactTypeEnum;
import org.artificer.common.ArtificerModelUtils;
import org.artificer.common.query.xpath.StaticNamespaceContext;
import org.artificer.integration.artifactbuilder.QNameRelationshipSource;
import org.artificer.integration.artifactbuilder.XmlArtifactBuilder;
import org.artificer.integration.switchyard.artifactbuilder.JavaRelationshipSource;
import org.artificer.integration.switchyard.model.SwitchYardModel;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Relationship;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SwitchYardXmlArtifactBuilder
extends XmlArtifactBuilder {
    protected void configureNamespaceMappings(StaticNamespaceContext namespaceContext) {
        super.configureNamespaceMappings(namespaceContext);
        SwitchYardModel.addNamespaceMappings(namespaceContext);
    }

    protected void derive() throws IOException {
        try {
            String targetNS = this.rootElement.getAttribute("targetNamespace");
            ArtificerModelUtils.setCustomProperty((BaseArtifactType)this.getPrimaryArtifact(), (String)"targetNamespace", (String)targetNS);
            if ("switchyard.xml".equals(this.getPrimaryArtifact().getName()) && this.rootElement.hasAttribute("name")) {
                String name = this.rootElement.getAttribute("name");
                this.getPrimaryArtifact().setName(name);
            }
            this.processComponents();
            this.processServices();
            this.processTransformers();
            this.processValidators();
        }
        catch (XPathExpressionException e) {
            throw new IOException(e);
        }
    }

    private void processServices() throws XPathExpressionException {
        NodeList nodes = (NodeList)this.query(this.rootElement, "./sca:composite/sca:service", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element iface;
            Element node = (Element)nodes.item(idx);
            String name = node.getAttribute("name");
            ExtendedArtifactType serviceArtifact = SwitchYardModel.newServiceArtifact(name);
            this.getDerivedArtifacts().add(serviceArtifact);
            if (node.hasAttribute("promote")) {
                String promote = node.getAttribute("promote");
                BaseArtifactType component = this.findComponentByName(this.getDerivedArtifacts(), promote);
                if (component != null) {
                    ArtificerModelUtils.addGenericRelationship((BaseArtifactType)serviceArtifact, (String)"promotes", (String)component.getUuid());
                }
            }
            if ((iface = (Element)this.query(node, "sca:interface.java", XPathConstants.NODE)) != null && iface.hasAttribute("interface")) {
                String ifaceName = iface.getAttribute("interface");
                Relationship relationship = ArtificerModelUtils.addGenericRelationship((BaseArtifactType)serviceArtifact, (String)"implements", null);
                this.relationshipSources.add(new JavaRelationshipSource(ifaceName, null, relationship.getRelationshipTarget(), "ext", "JavaInterface"));
            }
            if ((iface = (Element)this.query(node, "sca:interface.wsdl", XPathConstants.NODE)) == null || !iface.hasAttribute("interface")) continue;
            String wsdlInfo = iface.getAttribute("interface");
            Relationship relationship = ArtificerModelUtils.addGenericRelationship((BaseArtifactType)serviceArtifact, (String)"implements", null);
        }
    }

    private void processComponents() throws XPathExpressionException {
        NodeList nodes = (NodeList)this.query(this.rootElement, "./sca:composite/sca:component", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element implCamel;
            Element node = (Element)nodes.item(idx);
            String name = node.getAttribute("name");
            ExtendedArtifactType componentArtifact = SwitchYardModel.newComponentArtifact(name);
            this.getDerivedArtifacts().add(componentArtifact);
            Element implBean = (Element)this.query(node, "bean:implementation.bean", XPathConstants.NODE);
            if (implBean != null) {
                if (implBean.hasAttribute("class")) {
                    String implClassName = implBean.getAttribute("class");
                    Relationship relationship = ArtificerModelUtils.addGenericRelationship((BaseArtifactType)componentArtifact, (String)"implementedBy", null);
                    this.relationshipSources.add(new JavaRelationshipSource(implClassName, null, relationship.getRelationshipTarget(), "ext", "JavaClass"));
                }
                if (implBean.hasAttribute("requires")) {
                    String requires = implBean.getAttribute("requires");
                    ArtificerModelUtils.setCustomProperty((BaseArtifactType)componentArtifact, (String)"requires", (String)requires);
                }
            }
            if ((implCamel = (Element)this.query(node, "camel:implementation.camel", XPathConstants.NODE)) != null) {
                Element xml = (Element)this.query(implCamel, "camel:xml", XPathConstants.NODE);
                if (xml != null) {
                    String path = xml.getAttribute("path");
                    Relationship relationship = ArtificerModelUtils.addGenericRelationship((BaseArtifactType)componentArtifact, (String)"implementedBy", null);
                }
                if (implCamel.hasAttribute("requires")) {
                    String requires = implCamel.getAttribute("requires");
                    ArtificerModelUtils.setCustomProperty((BaseArtifactType)componentArtifact, (String)"requires", (String)requires);
                }
            }
            NodeList refs = (NodeList)this.query(node, "sca:reference", XPathConstants.NODESET);
            for (int jdx = 0; jdx < refs.getLength(); ++jdx) {
                Relationship relationship;
                Element ref = (Element)refs.item(jdx);
                Element iface = (Element)this.query(ref, "sca:interface.java", XPathConstants.NODE);
                if (iface != null && iface.hasAttribute("interface")) {
                    String ifaceName = iface.getAttribute("interface");
                    relationship = ArtificerModelUtils.addGenericRelationship((BaseArtifactType)componentArtifact, (String)"references", null);
                    this.relationshipSources.add(new JavaRelationshipSource(ifaceName, null, relationship.getRelationshipTarget(), "ext", "JavaInterface"));
                }
                if ((iface = (Element)this.query(ref, "sca:interface.wsdl", XPathConstants.NODE)) == null || !iface.hasAttribute("interface")) continue;
                String wsdlInfo = iface.getAttribute("interface");
                relationship = ArtificerModelUtils.addGenericRelationship((BaseArtifactType)componentArtifact, (String)"references", null);
            }
            NodeList services = (NodeList)this.query(node, "sca:service", XPathConstants.NODESET);
            for (int jdx = 0; jdx < services.getLength(); ++jdx) {
                Element componentSvc = (Element)services.item(jdx);
                name = componentSvc.getAttribute("name");
                ExtendedArtifactType componentServiceArtifact = SwitchYardModel.newComponentServiceArtifact(name);
                componentServiceArtifact.setUuid(UUID.randomUUID().toString());
                this.getDerivedArtifacts().add(componentServiceArtifact);
                ArtificerModelUtils.addGenericRelationship((BaseArtifactType)componentArtifact, (String)"offers", (String)componentServiceArtifact.getUuid());
                Element iface = (Element)this.query(componentSvc, "sca:interface.java", XPathConstants.NODE);
                if (iface != null && iface.hasAttribute("interface")) {
                    String ifaceName = iface.getAttribute("interface");
                    Relationship relationship = ArtificerModelUtils.addGenericRelationship((BaseArtifactType)componentServiceArtifact, (String)"implements", null);
                    this.relationshipSources.add(new JavaRelationshipSource(ifaceName, null, relationship.getRelationshipTarget(), "ext", "JavaInterface"));
                }
                if ((iface = (Element)this.query(componentSvc, "sca:interface.wsdl", XPathConstants.NODE)) != null && iface.hasAttribute("interface")) {
                    String wsdlInfo = iface.getAttribute("interface");
                    Relationship relationship = ArtificerModelUtils.addGenericRelationship((BaseArtifactType)componentServiceArtifact, (String)"implements", null);
                }
                if (!componentSvc.hasAttribute("requires")) continue;
                String requires = componentSvc.getAttribute("requires");
                ArtificerModelUtils.setCustomProperty((BaseArtifactType)componentServiceArtifact, (String)"requires", (String)requires);
            }
        }
    }

    private void processTransformers() throws XPathExpressionException {
        NodeList nodes = (NodeList)this.query(this.rootElement, "./swyd:transforms/tf:transform.java | ./swyd:transforms/tf:transform.xslt | ./swyd:transforms/tf:transform.json | ./swyd:transforms/tf:transform.smooks | ./swyd:transforms/tf:transform.jaxb", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Relationship relationship;
            Element node = (Element)nodes.item(idx);
            String name = node.getAttribute("name");
            if (name == null || name.trim().length() == 0) {
                if (node.hasAttribute("from") && node.hasAttribute("to")) {
                    String from = node.getAttribute("from");
                    String to = node.getAttribute("to");
                    if (from.startsWith("{")) {
                        name = from.substring(from.lastIndexOf("}") + 1);
                    } else if (from.startsWith("java:")) {
                        name = from.substring(from.lastIndexOf(46) + 1);
                    }
                    if (to.startsWith("{")) {
                        name = name + "->" + to.substring(to.lastIndexOf("}") + 1);
                    } else if (to.startsWith("java:")) {
                        name = name + "->" + to.substring(to.lastIndexOf(46) + 1);
                    }
                } else {
                    name = node.getLocalName();
                }
            }
            ExtendedArtifactType transformerArtifact = SwitchYardModel.newTransformerArtifact(name);
            String type = node.getLocalName();
            type = type.substring(type.lastIndexOf(46) + 1);
            ArtificerModelUtils.setCustomProperty((BaseArtifactType)transformerArtifact, (String)"transformer-type", (String)type);
            if (node.hasAttribute("class")) {
                relationship = ArtificerModelUtils.addGenericRelationship((BaseArtifactType)transformerArtifact, (String)"implementedBy", null);
                this.relationshipSources.add(new JavaRelationshipSource(node.getAttribute("class"), null, relationship.getRelationshipTarget(), "ext", "JavaClass"));
            }
            if (node.hasAttribute("bean")) {
                relationship = ArtificerModelUtils.addGenericRelationship((BaseArtifactType)transformerArtifact, (String)"implementedBy", null);
            }
            if (node.hasAttribute("xsltFile")) {
                relationship = ArtificerModelUtils.addGenericRelationship((BaseArtifactType)transformerArtifact, (String)"implementedBy", null);
            }
            if (node.hasAttribute("config")) {
                relationship = ArtificerModelUtils.addGenericRelationship((BaseArtifactType)transformerArtifact, (String)"implementedBy", null);
            }
            if (node.hasAttribute("from")) {
                relationship = ArtificerModelUtils.addGenericRelationship((BaseArtifactType)transformerArtifact, (String)"transformsFrom", null);
                String from = node.getAttribute("from");
                if (from.startsWith("{")) {
                    this.relationshipSources.add(new QNameRelationshipSource(QName.valueOf(from), null, (Collection)relationship.getRelationshipTarget(), ArtifactTypeEnum.ElementDeclaration.getModel(), new String[]{ArtifactTypeEnum.ElementDeclaration.getType()}));
                } else {
                    this.relationshipSources.add(new JavaRelationshipSource(from, null, relationship.getRelationshipTarget(), "ext", "JavaClass"));
                }
            }
            if (node.hasAttribute("to")) {
                relationship = ArtificerModelUtils.addGenericRelationship((BaseArtifactType)transformerArtifact, (String)"transformsTo", null);
                String to = node.getAttribute("to");
                if (to.startsWith("{")) {
                    this.relationshipSources.add(new QNameRelationshipSource(QName.valueOf(to), null, (Collection)relationship.getRelationshipTarget(), ArtifactTypeEnum.ElementDeclaration.getModel(), new String[]{ArtifactTypeEnum.ElementDeclaration.getType()}));
                } else {
                    this.relationshipSources.add(new JavaRelationshipSource(to, null, relationship.getRelationshipTarget(), "ext", "JavaClass"));
                }
            }
            this.getDerivedArtifacts().add(transformerArtifact);
        }
    }

    private void processValidators() throws XPathExpressionException {
        NodeList nodes = (NodeList)this.query(this.rootElement, "./swyd:validates/val:validate.java | ./swyd:validates/val:validate.xml", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element node = (Element)nodes.item(idx);
            if (!node.hasAttribute("name")) continue;
            String name = node.getAttribute("name");
            ExtendedArtifactType validatorArtifact = SwitchYardModel.newValidateArtifact(name);
            String type = node.getLocalName();
            type = type.substring(type.lastIndexOf(46) + 1);
            ArtificerModelUtils.setCustomProperty((BaseArtifactType)validatorArtifact, (String)"validator-type", (String)type);
            Relationship relationship = ArtificerModelUtils.addGenericRelationship((BaseArtifactType)validatorArtifact, (String)"validates", null);
            if (name.startsWith("{")) {
                this.relationshipSources.add(new QNameRelationshipSource(QName.valueOf(name), null, (Collection)relationship.getRelationshipTarget(), ArtifactTypeEnum.ElementDeclaration.getModel(), new String[]{ArtifactTypeEnum.ElementDeclaration.getType()}));
            } else {
                this.relationshipSources.add(new JavaRelationshipSource(name, null, relationship.getRelationshipTarget(), "ext", "JavaInterface"));
            }
            if (node.hasAttribute("class")) {
                relationship = ArtificerModelUtils.addGenericRelationship((BaseArtifactType)validatorArtifact, (String)"implementedBy", null);
                this.relationshipSources.add(new JavaRelationshipSource(node.getAttribute("class"), null, relationship.getRelationshipTarget(), "ext", "JavaClass"));
            }
            if (node.hasAttribute("bean")) {
                relationship = ArtificerModelUtils.addGenericRelationship((BaseArtifactType)validatorArtifact, (String)"implementedBy", null);
            }
            if (node.hasAttribute("schemaType")) {
                // empty if block
            }
            this.getDerivedArtifacts().add(validatorArtifact);
        }
    }

    private BaseArtifactType findComponentByName(Collection<BaseArtifactType> derivedArtifacts, String componentName) {
        for (BaseArtifactType artifact : derivedArtifacts) {
            ArtifactType at = ArtifactType.valueOf((BaseArtifactType)artifact);
            if (!at.getType().equals("SwitchYardComponent") || !artifact.getName().equals(componentName)) continue;
            return artifact;
        }
        return null;
    }
}

