/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.refresh;

import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.asciidoctor.maven.io.AsciidoctorFileScanner;

public class ResourcesPatternBuilder {
    private final String sourceDocumentName;
    private final List<String> sourceDocumentExtensions;

    public ResourcesPatternBuilder(String sourceDocumentName, List<String> sourceDocumentExtensions) {
        this.sourceDocumentName = sourceDocumentName;
        this.sourceDocumentExtensions = sourceDocumentExtensions;
    }

    public String build() {
        StringJoiner filePattern = new StringJoiner("|").add("a((sc(iidoc)?)|d(oc)?)");
        if (!this.sourceDocumentExtensions.isEmpty()) {
            filePattern.add(String.join((CharSequence)"|", this.sourceDocumentExtensions));
        }
        String specialFiles = Arrays.stream(AsciidoctorFileScanner.IGNORED_FILE_NAMES).map(pattern -> pattern.replaceAll("\\*", ".*")).map(pattern -> pattern.replaceAll("\\.", "\\\\.")).collect(Collectors.joining("|"));
        return "^" + ("(?!(" + specialFiles + (StringUtils.isBlank((CharSequence)this.sourceDocumentName) ? "" : "|" + this.sourceDocumentName) + "))") + "[^_.].*\\.(?!(" + filePattern.toString() + ")).*$";
    }
}

