/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.process;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SourceDocumentFinder {
    private static final String STANDARD_FILE_EXTENSIONS_PATTERN = "^[^_.].*\\.a((sc(iidoc)?)|d(oc)?)$";
    public static final String CUSTOM_FILE_EXTENSIONS_PATTERN_PREFIX = "^[^_.].*\\.(";
    public static final String CUSTOM_FILE_EXTENSIONS_PATTERN_SUFFIX = ")$";

    public List<File> find(Path sourceDirectory) {
        return this.find(sourceDirectory, Pattern.compile(STANDARD_FILE_EXTENSIONS_PATTERN));
    }

    public List<File> find(Path sourceDirectory, List<String> sourceDocumentExtensions) {
        String extensionPattern = sourceDocumentExtensions.stream().collect(Collectors.joining("|", CUSTOM_FILE_EXTENSIONS_PATTERN_PREFIX, CUSTOM_FILE_EXTENSIONS_PATTERN_SUFFIX));
        return this.find(sourceDirectory, Pattern.compile(extensionPattern));
    }

    private List<File> find(Path sourceDirectory, Pattern sourceDocumentPattern) {
        List<File> list;
        block8: {
            Stream<Path> sourceDocumentCandidates = Files.walk(sourceDirectory, new FileVisitOption[0]);
            try {
                list = sourceDocumentCandidates.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> sourceDocumentPattern.matcher(path.getFileName().toString()).matches()).filter(path -> {
                    for (Path part : sourceDirectory.relativize((Path)path)) {
                        char firstCharacter = part.toString().charAt(0);
                        if (firstCharacter != '_' && firstCharacter != '.') continue;
                        return false;
                    }
                    return true;
                }).map(Path::toFile).collect(Collectors.toList());
                if (sourceDocumentCandidates == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (sourceDocumentCandidates != null) {
                        try {
                            sourceDocumentCandidates.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Collections.emptyList();
                }
            }
            sourceDocumentCandidates.close();
        }
        return list;
    }
}

