/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor;

import java.io.File;
import java.util.regex.Pattern;
import org.asciidoctor.AbstractDirectoryWalker;

public class AsciiDocDirectoryWalker
extends AbstractDirectoryWalker {
    private static final String ASCIIDOC_REG_EXP_EXTENSION = "^[^_.].*\\.a((sc(iidoc)?)|d(oc)?)$";
    private static final Pattern ASCIIDOC_EXTENSION_PATTERN = Pattern.compile("^[^_.].*\\.a((sc(iidoc)?)|d(oc)?)$");

    public AsciiDocDirectoryWalker(String baseDir) {
        super(baseDir);
    }

    @Override
    protected boolean isAcceptedFile(File file) {
        String fileName = file.getName();
        return this.isAsciidocExtension(fileName);
    }

    private boolean isAsciidocExtension(String fileName) {
        return ASCIIDOC_EXTENSION_PATTERN.matcher(fileName).matches();
    }
}

