/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.ast;

import java.util.ArrayList;
import java.util.List;
import org.asciidoctor.ast.AbstractBlockImpl;
import org.asciidoctor.ast.Cell;
import org.asciidoctor.ast.Column;
import org.asciidoctor.ast.NodeConverter;
import org.asciidoctor.ast.Row;
import org.asciidoctor.ast.RowImpl;
import org.asciidoctor.ast.Table;
import org.asciidoctor.internal.RubyUtils;
import org.jruby.Ruby;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class TableImpl
extends AbstractBlockImpl
implements Table {
    private static final String FRAME_ATTR = "frame";
    private static final String GRID_ATTR = "grid";
    private Table delegate;
    private Rows rows;

    public TableImpl(Table delegate, Ruby rubyRuntime) {
        super(delegate, rubyRuntime);
        this.delegate = delegate;
        IRubyObject rubyTable = JavaEmbedUtils.javaToRuby((Ruby)rubyRuntime, (Object)delegate);
        this.rows = new RowsImpl(RubyUtils.rubyToJava(rubyRuntime, rubyTable.getInstanceVariables().getInstanceVariable("@rows"), Rows.class), rubyRuntime);
    }

    @Override
    public boolean hasHeaderOption() {
        return this.delegate.hasHeaderOption();
    }

    @Override
    public String getFrame() {
        return (String)this.getAttr(FRAME_ATTR, "all");
    }

    @Override
    public void setFrame(String frame) {
        this.setAttr(FRAME_ATTR, frame, true);
    }

    @Override
    public String getGrid() {
        return (String)this.getAttr(GRID_ATTR, "all");
    }

    @Override
    public void setGrid(String grid) {
        this.setAttr(GRID_ATTR, grid, true);
    }

    @Override
    public List<Column> getColumns() {
        List<Column> rubyColumns = this.delegate.getColumns();
        ArrayList<Column> result = new ArrayList<Column>(rubyColumns.size());
        for (int i = 0; i < rubyColumns.size(); ++i) {
            IRubyObject rubyColumn = (IRubyObject)rubyColumns.get(i);
            result.add((Column)NodeConverter.createASTNode(rubyColumn));
        }
        return result;
    }

    @Override
    public List<Row> getFooter() {
        return this.rows.getFoot();
    }

    @Override
    public List<Row> getBody() {
        return this.rows.getBody();
    }

    @Override
    public List<Row> getHeader() {
        return this.rows.getHead();
    }

    public static class RowsImpl
    implements Rows {
        private final Rows delegate;
        private final Ruby rubyRuntime;

        public RowsImpl(Rows delegate, Ruby rubyRuntime) {
            this.delegate = delegate;
            this.rubyRuntime = rubyRuntime;
        }

        @Override
        public List<Row> getHead() {
            return this.convertRows(this.delegate.getHead());
        }

        @Override
        public List<Row> getFoot() {
            return this.convertRows(this.delegate.getFoot());
        }

        @Override
        public List<Row> getBody() {
            return this.convertRows(this.delegate.getBody());
        }

        private List<Row> convertRows(List<?> rows) {
            ArrayList<Row> result = new ArrayList<Row>(rows.size());
            for (int i = 0; i < rows.size(); ++i) {
                List rubyRow = (List)rows.get(i);
                result.add(this.convertRow(rubyRow));
            }
            return result;
        }

        private Row convertRow(List<? extends IRubyObject> rubyRow) {
            ArrayList<Cell> cells = new ArrayList<Cell>(rubyRow.size());
            for (int j = 0; j < rubyRow.size(); ++j) {
                IRubyObject rubyCell = rubyRow.get(j);
                cells.add((Cell)NodeConverter.createASTNode(rubyCell));
            }
            return new RowImpl(cells, this.rubyRuntime);
        }
    }

    public static interface Rows {
        public List<Row> getHead();

        public List<Row> getFoot();

        public List<Row> getBody();
    }
}

