/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.atmosphere.cache.AbstractBroadcasterCache;
import org.atmosphere.cache.BroadcastMessage;
import org.atmosphere.cache.CacheMessage;
import org.atmosphere.cpr.AtmosphereResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionBroadcasterCache
extends AbstractBroadcasterCache {
    private static final Logger logger = LoggerFactory.getLogger(SessionBroadcasterCache.class);
    private static final String ERROR_MESSAGE = "Session was null. The request has been recycled by the underlying container";

    @Override
    public CacheMessage addToCache(String broadcasterId, String uuid, BroadcastMessage message) {
        long now = System.nanoTime();
        CacheMessage cacheMessage = this.put(message, now, uuid);
        if (uuid.equals("null")) {
            return cacheMessage;
        }
        try {
            HttpSession session = this.config.resourcesFactory().find(uuid).session();
            if (session == null) {
                logger.error(ERROR_MESSAGE);
                return cacheMessage;
            }
            session.setAttribute(broadcasterId, (Object)String.valueOf(now));
        }
        catch (IllegalStateException ex) {
            logger.trace("", (Throwable)ex);
            logger.warn("The Session has been invalidated. Message will be lost.");
        }
        return cacheMessage;
    }

    @Override
    public List<Object> retrieveFromCache(String broadcasterId, String uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException("AtmosphereResource can't be null");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            AtmosphereResource r = this.config.resourcesFactory().find(uuid);
            if (r == null) {
                logger.trace("Invalid UUID {}", (Object)uuid);
                return result;
            }
            HttpSession session = r.session();
            if (session == null) {
                logger.error(ERROR_MESSAGE);
                return result;
            }
            String cacheHeaderTimeStr = (String)session.getAttribute(broadcasterId);
            if (cacheHeaderTimeStr == null) {
                return result;
            }
            long cacheHeaderTime = Long.parseLong(cacheHeaderTimeStr);
            return this.get(cacheHeaderTime);
        }
        catch (IllegalStateException ex) {
            logger.trace("", (Throwable)ex);
            logger.warn("The Session has been invalidated. Unable to retrieve cached messages");
            return Collections.emptyList();
        }
    }
}

