/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import org.atmosphere.container.version.JBossWebSocket;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereRequestImpl;
import org.atmosphere.cpr.AtmosphereResponseImpl;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.jboss.as.websockets.servlet.WebSocketServlet;
import org.atmosphere.jboss.websockets.Frame;
import org.atmosphere.jboss.websockets.frame.BinaryFrame;
import org.atmosphere.jboss.websockets.frame.CloseFrame;
import org.atmosphere.jboss.websockets.frame.TextFrame;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBossWebSocketHandler
extends WebSocketServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(JBossWebSocketHandler.class);
    private static final String JBOSS_WEB_SOCKET_PROCESSOR = "jboss.webSocketProcessor";
    private final AtmosphereConfig config;
    private final WebSocketProcessor webSocketProcessor;
    private WebSocket webSocket;

    public JBossWebSocketHandler(AtmosphereConfig config) {
        this.config = config;
        this.webSocketProcessor = WebSocketProcessorFactory.getDefault().getWebSocketProcessor(config.framework());
    }

    protected void onSocketOpened(org.atmosphere.jboss.as.websockets.WebSocket socket) throws IOException {
        logger.trace("WebSocket.onSocketOpened.");
        if (!this.webSocketProcessor.handshake(socket.getServletRequest())) {
            socket.closeSocket();
            throw new IOException();
        }
        AtmosphereRequest r = AtmosphereRequestImpl.wrap(socket.getServletRequest());
        this.webSocket = new JBossWebSocket(socket, this.config);
        this.webSocketProcessor.open(this.webSocket, r, AtmosphereResponseImpl.newInstance(this.config, r, this.webSocket));
    }

    protected void onSocketClosed(org.atmosphere.jboss.as.websockets.WebSocket socket) {
        logger.trace("WebSocket.onSocketClosed.");
        this.webSocketProcessor.close(this.webSocket, 1005);
    }

    protected void onReceivedFrame(org.atmosphere.jboss.as.websockets.WebSocket socket) throws IOException {
        Frame frame = socket.readFrame();
        if (this.webSocketProcessor != null) {
            if (frame instanceof TextFrame) {
                logger.trace("WebSocket.onReceivedFrame (TextFrame)");
                this.webSocketProcessor.invokeWebSocketProtocol(this.webSocket, ((TextFrame)frame).getText());
            } else if (frame instanceof BinaryFrame) {
                logger.trace("WebSocket.onReceivedFrame (BinaryFrame)");
                BinaryFrame binaryFrame = (BinaryFrame)frame;
                this.webSocketProcessor.invokeWebSocketProtocol(this.webSocket, binaryFrame.getByteArray(), 0, binaryFrame.getByteArray().length);
            } else if (frame instanceof CloseFrame) {
                logger.trace("WebSocket.onReceivedFrame (CloseFrame)");
                this.webSocketProcessor.close(this.webSocket, 1005);
            } else {
                logger.trace("WebSocket.onReceivedFrame skipping: " + frame);
            }
        } else {
            logger.trace("WebSocket.onReceivedFrame but no atmosphere processor in request, skipping: {}", (Object)frame);
        }
    }
}

