/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForkJoinPool
extends AbstractExecutorService {
    private static final Logger logger = LoggerFactory.getLogger(ForkJoinPool.class);
    private final AbstractExecutorService forkJoinPool;
    private final boolean shared;

    public ForkJoinPool(boolean shared, final String threadName) {
        this.shared = shared;
        this.forkJoinPool = new java.util.concurrent.ForkJoinPool(Runtime.getRuntime().availableProcessors(), new ForkJoinPool.ForkJoinWorkerThreadFactory(){
            final /* synthetic */ ForkJoinPool this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ForkJoinWorkerThread newThread(java.util.concurrent.ForkJoinPool pool) {
                return new JDK7ForkJoinWorkerThread(pool, this.this$0.shared, threadName);
            }
        }, null, false);
        logger.info("Using ForkJoinPool  {}. Set the {} to -1 to fully use its power.", (Object)this.forkJoinPool.getClass().getName(), (Object)"org.atmosphere.cpr.broadcaster.maxAsyncWriteThreads");
    }

    public AbstractExecutorService pool() {
        return this.forkJoinPool;
    }

    @Override
    public void shutdown() {
        this.forkJoinPool.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.forkJoinPool.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.forkJoinPool.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.forkJoinPool.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.forkJoinPool.awaitTermination(timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.forkJoinPool.execute(command);
    }

    private static final class JDK7ForkJoinWorkerThread
    extends ForkJoinWorkerThread {
        private final AtomicInteger count = new AtomicInteger();

        protected JDK7ForkJoinWorkerThread(java.util.concurrent.ForkJoinPool pool, boolean shared, String threadName) {
            super(pool);
            this.setName((shared ? "Atmosphere-Shared-" : threadName) + this.count.getAndIncrement());
        }
    }
}

