/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.core.learning;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.events.LearningEvent;
import org.neuroph.core.learning.LearningRule;
import org.neuroph.core.learning.stop.MaxIterationsStop;
import org.neuroph.core.learning.stop.StopCondition;

public abstract class IterativeLearning
extends LearningRule
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected double learningRate = 0.1;
    protected int currentIteration = 0;
    private int maxIterations = Integer.MAX_VALUE;
    private boolean iterationsLimited = false;
    protected List<StopCondition> stopConditions = new ArrayList<StopCondition>();
    private volatile transient boolean pausedLearning = false;

    public double getLearningRate() {
        return this.learningRate;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public void setMaxIterations(int maxIterations) {
        if (maxIterations > 0) {
            this.maxIterations = maxIterations;
            this.iterationsLimited = true;
        }
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public boolean isIterationsLimited() {
        return this.iterationsLimited;
    }

    public int getCurrentIteration() {
        return this.currentIteration;
    }

    public boolean isPausedLearning() {
        return this.pausedLearning;
    }

    public void pause() {
        this.pausedLearning = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        this.pausedLearning = false;
        IterativeLearning iterativeLearning = this;
        synchronized (iterativeLearning) {
            this.notify();
        }
    }

    @Override
    protected void onStart() {
        super.onStart();
        if (this.iterationsLimited) {
            this.stopConditions.add(new MaxIterationsStop(this));
        }
        this.currentIteration = 0;
    }

    protected void beforeEpoch() {
    }

    protected void afterEpoch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void learn(DataSet trainingSet) {
        this.setTrainingSet(trainingSet);
        this.onStart();
        while (!this.isStopped()) {
            this.beforeEpoch();
            this.doLearningEpoch(trainingSet);
            ++this.currentIteration;
            this.afterEpoch();
            if (this.hasReachedStopCondition()) {
                this.stopLearning();
            } else if (!this.iterationsLimited && this.currentIteration == Integer.MAX_VALUE) {
                this.currentIteration = 1;
            }
            this.fireLearningEvent(new LearningEvent(this, LearningEvent.Type.EPOCH_ENDED));
            if (!this.pausedLearning) continue;
            IterativeLearning iterativeLearning = this;
            synchronized (iterativeLearning) {
                while (this.pausedLearning) {
                    try {
                        this.wait();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        this.onStop();
        this.fireLearningEvent(new LearningEvent(this, LearningEvent.Type.LEARNING_STOPPED));
    }

    protected boolean hasReachedStopCondition() {
        for (StopCondition stop : this.stopConditions) {
            if (!stop.isReached()) continue;
            return true;
        }
        return false;
    }

    public void learn(DataSet trainingSet, int maxIterations) {
        this.setMaxIterations(maxIterations);
        this.learn(trainingSet);
    }

    public void doOneLearningIteration(DataSet trainingSet) {
        this.beforeEpoch();
        this.doLearningEpoch(trainingSet);
        this.afterEpoch();
        this.fireLearningEvent(new LearningEvent(this, LearningEvent.Type.LEARNING_STOPPED));
    }

    public abstract void doLearningEpoch(DataSet var1);
}

