/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.core.learning;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.events.LearningEvent;
import org.neuroph.core.events.LearningEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LearningRule
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected NeuralNetwork neuralNetwork;
    private transient DataSet trainingSet;
    private volatile transient boolean stopLearning = false;
    protected transient List<LearningEventListener> listeners = new ArrayList<LearningEventListener>();
    private final Logger LOGGER = LoggerFactory.getLogger(LearningRule.class);

    public void setTrainingSet(DataSet trainingSet) {
        this.trainingSet = trainingSet;
    }

    public DataSet getTrainingSet() {
        return this.trainingSet;
    }

    public NeuralNetwork getNeuralNetwork() {
        return this.neuralNetwork;
    }

    public void setNeuralNetwork(NeuralNetwork neuralNetwork) {
        this.neuralNetwork = neuralNetwork;
    }

    protected void onStart() {
        this.stopLearning = false;
    }

    protected void onStop() {
    }

    public synchronized void stopLearning() {
        this.stopLearning = true;
    }

    public synchronized boolean isStopped() {
        return this.stopLearning;
    }

    public synchronized void addListener(LearningEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null!");
        }
        this.listeners.add(listener);
    }

    public synchronized void removeListener(LearningEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null!");
        }
        this.listeners.remove(listener);
    }

    protected synchronized void fireLearningEvent(LearningEvent evt) {
        for (LearningEventListener listener : this.listeners) {
            listener.handleLearningEvent(evt);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new ArrayList<LearningEventListener>();
    }

    public abstract void learn(DataSet var1);
}

