/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.core.learning.error;

import java.io.Serializable;
import org.neuroph.core.learning.error.ErrorFunction;

public class MeanSquaredError
implements ErrorFunction,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient double totalError;
    private transient double patternCount;

    public MeanSquaredError() {
        this.reset();
    }

    @Override
    public void reset() {
        this.totalError = 0.0;
        this.patternCount = 0.0;
    }

    @Override
    public double getTotalError() {
        return this.totalError / (2.0 * this.patternCount);
    }

    @Override
    public double[] calculatePatternError(double[] predictedOutput, double[] targetOutput) {
        double[] patternError = new double[targetOutput.length];
        for (int i = 0; i < predictedOutput.length; ++i) {
            patternError[i] = targetOutput[i] - predictedOutput[i];
            this.totalError += patternError[i] * patternError[i];
        }
        this.patternCount += 1.0;
        return patternError;
    }
}

