/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.core.transfer;

import java.io.Serializable;
import org.neuroph.core.transfer.TransferFunction;
import org.neuroph.util.Properties;

public class Tanh
extends TransferFunction
implements Serializable {
    private static final long serialVersionUID = 2L;
    private double slope = 2.0;

    public Tanh() {
    }

    public Tanh(double slope) {
        this.slope = slope;
    }

    public Tanh(Properties properties) {
        try {
            this.slope = (Double)properties.getProperty("transferFunction.slope");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid transfer function properties! Using default values.");
        }
    }

    @Override
    public final double getOutput(double net) {
        if (net > 100.0) {
            return 1.0;
        }
        if (net < -100.0) {
            return -1.0;
        }
        double E_x = Math.exp(this.slope * net);
        this.output = (E_x - 1.0) / (E_x + 1.0);
        return this.output;
    }

    @Override
    public final double getDerivative(double net) {
        return 1.0 - this.output * this.output;
    }

    public double getSlope() {
        return this.slope;
    }

    public void setSlope(double slope) {
        this.slope = slope;
    }
}

