/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet;

import org.neuroph.core.Layer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.input.WeightedSum;
import org.neuroph.nnet.comp.layer.CompetitiveLayer;
import org.neuroph.nnet.comp.neuron.CompetitiveNeuron;
import org.neuroph.nnet.learning.CompetitiveLearning;
import org.neuroph.util.ConnectionFactory;
import org.neuroph.util.LayerFactory;
import org.neuroph.util.NeuralNetworkFactory;
import org.neuroph.util.NeuralNetworkType;
import org.neuroph.util.NeuronProperties;
import org.neuroph.util.TransferFunctionType;

public class CompetitiveNetwork
extends NeuralNetwork {
    private static final long serialVersionUID = 1L;

    public CompetitiveNetwork(int inputNeuronsCount, int outputNeuronsCount) {
        this.createNetwork(inputNeuronsCount, outputNeuronsCount);
    }

    private void createNetwork(int inputNeuronsCount, int outputNeuronsCount) {
        this.setNetworkType(NeuralNetworkType.COMPETITIVE);
        Layer inputLayer = LayerFactory.createLayer(inputNeuronsCount, new NeuronProperties());
        this.addLayer(inputLayer);
        NeuronProperties neuronProperties = new NeuronProperties();
        neuronProperties.setProperty("neuronType", CompetitiveNeuron.class);
        neuronProperties.setProperty("inputFunction", WeightedSum.class);
        neuronProperties.setProperty("transferFunction", (Object)TransferFunctionType.RAMP);
        CompetitiveLayer competitiveLayer = new CompetitiveLayer(outputNeuronsCount, neuronProperties);
        this.addLayer(competitiveLayer);
        double competitiveWeight = -(1.0 / (double)outputNeuronsCount);
        ConnectionFactory.fullConnect((Layer)competitiveLayer, competitiveWeight, 1);
        ConnectionFactory.fullConnect(inputLayer, competitiveLayer);
        NeuralNetworkFactory.setDefaultIO(this);
        this.setLearningRule(new CompetitiveLearning());
    }
}

