/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.learning;

import org.neuroph.core.data.DataSet;
import org.neuroph.nnet.learning.MomentumBackpropagation;

public class DynamicBackPropagation
extends MomentumBackpropagation {
    private static final long serialVersionUID = 1L;
    private double maxLearningRate = 0.9;
    private double minLearningRate = 0.1;
    private double learningRateChange = 0.99926;
    private boolean useDynamicLearningRate = true;
    private double maxMomentum = 0.9;
    private double minMomentum = 0.1;
    private double momentumChange = 0.99926;
    private boolean useDynamicMomentum = true;

    protected void adjustLearningRate() {
        double errorChange = this.previousEpochError - this.getErrorFunction().getTotalError();
        this.learningRate += errorChange * this.learningRateChange;
        if (this.learningRate > this.maxLearningRate) {
            this.learningRate = this.maxLearningRate;
        }
        if (this.learningRate < this.minLearningRate) {
            this.learningRate = this.minLearningRate;
        }
    }

    protected void adjustMomentum() {
        double errorChange = this.previousEpochError - this.getErrorFunction().getTotalError();
        this.momentum += errorChange * this.momentumChange;
        if (this.momentum > this.maxMomentum) {
            this.momentum = this.maxMomentum;
        }
        if (this.momentum < this.minMomentum) {
            this.momentum = this.minMomentum;
        }
    }

    @Override
    public void doLearningEpoch(DataSet trainingSet) {
        super.doLearningEpoch(trainingSet);
        if (this.currentIteration > 0) {
            if (this.useDynamicLearningRate) {
                this.adjustLearningRate();
            }
            if (this.useDynamicMomentum) {
                this.adjustMomentum();
            }
        }
    }

    public double getLearningRateChange() {
        return this.learningRateChange;
    }

    public void setLearningRateChange(double learningRateChange) {
        this.learningRateChange = learningRateChange;
    }

    public double getMaxLearningRate() {
        return this.maxLearningRate;
    }

    public void setMaxLearningRate(double maxLearningRate) {
        this.maxLearningRate = maxLearningRate;
    }

    public double getMaxMomentum() {
        return this.maxMomentum;
    }

    public void setMaxMomentum(double maxMomentum) {
        this.maxMomentum = maxMomentum;
    }

    public double getMinLearningRate() {
        return this.minLearningRate;
    }

    public void setMinLearningRate(double minLearningRate) {
        this.minLearningRate = minLearningRate;
    }

    public double getMinMomentum() {
        return this.minMomentum;
    }

    public void setMinMomentum(double minMomentum) {
        this.minMomentum = minMomentum;
    }

    public double getMomentumChange() {
        return this.momentumChange;
    }

    public void setMomentumChange(double momentumChange) {
        this.momentumChange = momentumChange;
    }

    public boolean getUseDynamicLearningRate() {
        return this.useDynamicLearningRate;
    }

    public void setUseDynamicLearningRate(boolean useDynamicLearningRate) {
        this.useDynamicLearningRate = useDynamicLearningRate;
    }

    public boolean getUseDynamicMomentum() {
        return this.useDynamicMomentum;
    }

    public void setUseDynamicMomentum(boolean useDynamicMomentum) {
        this.useDynamicMomentum = useDynamicMomentum;
    }
}

