/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.learning;

import org.neuroph.core.Connection;
import org.neuroph.core.Neuron;
import org.neuroph.nnet.learning.LMS;

public class SupervisedHebbianLearning
extends LMS {
    private static final long serialVersionUID = 1L;

    @Override
    protected void updateNetworkWeights(double[] desiredOutput) {
        int i = 0;
        for (Neuron neuron : this.neuralNetwork.getOutputNeurons()) {
            this.updateNeuronWeights(neuron, desiredOutput[i]);
            ++i;
        }
    }

    protected void updateNeuronWeights(Neuron neuron, double desiredOutput) {
        for (Connection connection : neuron.getInputConnections()) {
            double input = connection.getInput();
            double deltaWeight = input * desiredOutput * this.learningRate;
            connection.getWeight().inc(deltaWeight);
        }
    }
}

