/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util;

import java.util.ArrayList;
import org.neuroph.core.Layer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.Neuron;
import org.neuroph.nnet.Adaline;
import org.neuroph.nnet.BAM;
import org.neuroph.nnet.CompetitiveNetwork;
import org.neuroph.nnet.Hopfield;
import org.neuroph.nnet.Instar;
import org.neuroph.nnet.Kohonen;
import org.neuroph.nnet.MaxNet;
import org.neuroph.nnet.MultiLayerPerceptron;
import org.neuroph.nnet.Outstar;
import org.neuroph.nnet.Perceptron;
import org.neuroph.nnet.RBFNetwork;
import org.neuroph.nnet.SupervisedHebbianNetwork;
import org.neuroph.nnet.UnsupervisedHebbianNetwork;
import org.neuroph.nnet.comp.neuron.BiasNeuron;
import org.neuroph.nnet.learning.BackPropagation;
import org.neuroph.nnet.learning.BinaryDeltaRule;
import org.neuroph.nnet.learning.DynamicBackPropagation;
import org.neuroph.nnet.learning.MomentumBackpropagation;
import org.neuroph.nnet.learning.PerceptronLearning;
import org.neuroph.nnet.learning.ResilientPropagation;
import org.neuroph.util.NeuronProperties;
import org.neuroph.util.TransferFunctionType;
import org.neuroph.util.VectorParser;

public class NeuralNetworkFactory {
    public static Adaline createAdaline(int inputsCount) {
        Adaline nnet = new Adaline(inputsCount);
        return nnet;
    }

    public static Perceptron createPerceptron(int inputNeuronsCount, int outputNeuronsCount, TransferFunctionType transferFunctionType) {
        Perceptron nnet = new Perceptron(inputNeuronsCount, outputNeuronsCount, transferFunctionType);
        return nnet;
    }

    public static Perceptron createPerceptron(int inputNeuronsCount, int outputNeuronsCount, TransferFunctionType transferFunctionType, Class learningRule) {
        Perceptron nnet = new Perceptron(inputNeuronsCount, outputNeuronsCount, transferFunctionType);
        if (learningRule.getName().equals(PerceptronLearning.class.getName())) {
            nnet.setLearningRule(new PerceptronLearning());
        } else if (learningRule.getName().equals(BinaryDeltaRule.class.getName())) {
            nnet.setLearningRule(new BinaryDeltaRule());
        }
        return nnet;
    }

    public static MultiLayerPerceptron createMLPerceptron(String layersStr, TransferFunctionType transferFunctionType) {
        ArrayList<Integer> layerSizes = VectorParser.parseInteger(layersStr);
        MultiLayerPerceptron nnet = new MultiLayerPerceptron(layerSizes, transferFunctionType);
        return nnet;
    }

    public static MultiLayerPerceptron createMLPerceptron(String layersStr, TransferFunctionType transferFunctionType, Class learningRule, boolean useBias, boolean connectIO) {
        ArrayList<Integer> layerSizes = VectorParser.parseInteger(layersStr);
        NeuronProperties neuronProperties = new NeuronProperties(transferFunctionType, useBias);
        MultiLayerPerceptron nnet = new MultiLayerPerceptron(layerSizes, neuronProperties);
        if (learningRule.getName().equals(BackPropagation.class.getName())) {
            nnet.setLearningRule(new BackPropagation());
        } else if (learningRule.getName().equals(MomentumBackpropagation.class.getName())) {
            nnet.setLearningRule(new MomentumBackpropagation());
        } else if (learningRule.getName().equals(DynamicBackPropagation.class.getName())) {
            nnet.setLearningRule(new DynamicBackPropagation());
        } else if (learningRule.getName().equals(ResilientPropagation.class.getName())) {
            nnet.setLearningRule(new ResilientPropagation());
        }
        if (connectIO) {
            nnet.connectInputsToOutputs();
        }
        return nnet;
    }

    public static Hopfield createHopfield(int neuronsCount) {
        Hopfield nnet = new Hopfield(neuronsCount);
        return nnet;
    }

    public static BAM createBam(int inputNeuronsCount, int outputNeuronsCount) {
        BAM nnet = new BAM(inputNeuronsCount, outputNeuronsCount);
        return nnet;
    }

    public static Kohonen createKohonen(int inputNeuronsCount, int outputNeuronsCount) {
        Kohonen nnet = new Kohonen(inputNeuronsCount, outputNeuronsCount);
        return nnet;
    }

    public static SupervisedHebbianNetwork createSupervisedHebbian(int inputNeuronsCount, int outputNeuronsCount, TransferFunctionType transferFunctionType) {
        SupervisedHebbianNetwork nnet = new SupervisedHebbianNetwork(inputNeuronsCount, outputNeuronsCount, transferFunctionType);
        return nnet;
    }

    public static UnsupervisedHebbianNetwork createUnsupervisedHebbian(int inputNeuronsCount, int outputNeuronsCount, TransferFunctionType transferFunctionType) {
        UnsupervisedHebbianNetwork nnet = new UnsupervisedHebbianNetwork(inputNeuronsCount, outputNeuronsCount, transferFunctionType);
        return nnet;
    }

    public static MaxNet createMaxNet(int neuronsCount) {
        MaxNet nnet = new MaxNet(neuronsCount);
        return nnet;
    }

    public static Instar createInstar(int inputNeuronsCount) {
        Instar nnet = new Instar(inputNeuronsCount);
        return nnet;
    }

    public static Outstar createOutstar(int outputNeuronsCount) {
        Outstar nnet = new Outstar(outputNeuronsCount);
        return nnet;
    }

    public static CompetitiveNetwork createCompetitiveNetwork(int inputNeuronsCount, int outputNeuronsCount) {
        CompetitiveNetwork nnet = new CompetitiveNetwork(inputNeuronsCount, outputNeuronsCount);
        return nnet;
    }

    public static RBFNetwork createRbfNetwork(int inputNeuronsCount, int rbfNeuronsCount, int outputNeuronsCount) {
        RBFNetwork nnet = new RBFNetwork(inputNeuronsCount, rbfNeuronsCount, outputNeuronsCount);
        return nnet;
    }

    public static void setDefaultIO(NeuralNetwork nnet) {
        ArrayList<Neuron> inputNeuronsList = new ArrayList<Neuron>();
        Layer firstLayer = nnet.getLayerAt(0);
        for (Neuron neuron : firstLayer.getNeurons()) {
            if (neuron instanceof BiasNeuron) continue;
            inputNeuronsList.add(neuron);
        }
        Neuron[] inputNeurons = new Neuron[inputNeuronsList.size()];
        inputNeurons = inputNeuronsList.toArray(inputNeurons);
        Neuron[] outputNeurons = nnet.getLayerAt(nnet.getLayersCount() - 1).getNeurons();
        nnet.setInputNeurons(inputNeurons);
        nnet.setOutputNeurons(outputNeurons);
    }
}

