/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Neuroph {
    private static Neuroph instance;
    private boolean flattenNetworks = false;

    public static Neuroph getInstance() {
        if (instance == null) {
            instance = new Neuroph();
        }
        return instance;
    }

    public static String getVersion() {
        return "2.8";
    }

    public boolean shouldFlattenNetworks() {
        return this.flattenNetworks;
    }

    public void setFlattenNetworks(boolean flattenNetworks) {
        this.flattenNetworks = flattenNetworks;
    }

    public void shutdown() {
    }

    public ArrayList<String> getInputFunctions() {
        try {
            ArrayList<String> classes = Neuroph.getClassNamesFromPackage("org.neuroph.core.input");
            classes.remove("InputFunction");
            return classes;
        }
        catch (IOException ex) {
            Logger.getLogger(Neuroph.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public ArrayList<String> getTransferFunctions() {
        try {
            ArrayList<String> classes = Neuroph.getClassNamesFromPackage("org.neuroph.core.transfer");
            classes.remove("TransferFunction");
            return classes;
        }
        catch (IOException ex) {
            Logger.getLogger(Neuroph.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public ArrayList<String> getNeurons() {
        try {
            ArrayList<String> classes = Neuroph.getClassNamesFromPackage("org.neuroph.nnet.comp.neuron");
            classes.add(0, "Neuron");
            return classes;
        }
        catch (IOException ex) {
            Logger.getLogger(Neuroph.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public ArrayList<String> getLayers() {
        try {
            ArrayList<String> classes = Neuroph.getClassNamesFromPackage("org.neuroph.nnet.comp.layer");
            classes.add(0, "Layer");
            return classes;
        }
        catch (IOException ex) {
            Logger.getLogger(Neuroph.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public ArrayList<String> getLearningRules() {
        try {
            ArrayList<String> classes = Neuroph.getClassNamesFromPackage("org.neuroph.nnet.learning");
            return classes;
        }
        catch (IOException ex) {
            Logger.getLogger(Neuroph.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private static ArrayList<String> getClassNamesFromPackage(String packageName) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<String> names = new ArrayList<String>();
        URL packageURL = classLoader.getResource(packageName = packageName.replace(".", "/"));
        if (packageURL.getProtocol().equals("jar")) {
            String jarFileName = URLDecoder.decode(packageURL.getFile(), "UTF-8");
            jarFileName = jarFileName.substring(5, jarFileName.indexOf("!"));
            JarFile jf = new JarFile(jarFileName);
            Enumeration<JarEntry> jarEntries = jf.entries();
            while (jarEntries.hasMoreElements()) {
                String entryName = jarEntries.nextElement().getName();
                if (!entryName.startsWith(packageName) || entryName.length() <= packageName.length() + 5) continue;
                entryName = entryName.substring(packageName.length(), entryName.lastIndexOf(46));
                names.add(entryName.substring(1));
            }
        } else {
            File[] contenuti;
            File folder = new File(packageURL.getFile());
            for (File actual : contenuti = folder.listFiles()) {
                String entryName = actual.getName();
                entryName = entryName.substring(0, entryName.lastIndexOf(46));
                names.add(entryName);
            }
        }
        return names;
    }
}

