/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util.benchmark;

public class BenchmarkTaskResults {
    int testIterations;
    long[] elapsedTimes;
    int timesCounter;
    double averageTestTime;
    double standardDeviation;
    double minTestTime;
    double maxTestTime;

    public BenchmarkTaskResults(int testIterations) {
        this.testIterations = testIterations;
        this.elapsedTimes = new long[testIterations];
        this.timesCounter = 0;
    }

    public double getAverageTestTime() {
        return this.averageTestTime;
    }

    public long[] getElapsedTimes() {
        return this.elapsedTimes;
    }

    public double getMaxTestTime() {
        return this.maxTestTime;
    }

    public double getMinTestTime() {
        return this.minTestTime;
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    public int getTestIterations() {
        return this.testIterations;
    }

    public void addElapsedTime(long time) {
        this.elapsedTimes[this.timesCounter++] = time;
    }

    public void calculateStatistics() {
        this.minTestTime = this.elapsedTimes[0];
        this.maxTestTime = this.elapsedTimes[0];
        long sum = 0L;
        for (int i = 0; i < this.timesCounter; ++i) {
            sum += this.elapsedTimes[i];
            if ((double)this.elapsedTimes[i] < this.minTestTime) {
                this.minTestTime = this.elapsedTimes[i];
            }
            if (!((double)this.elapsedTimes[i] > this.maxTestTime)) continue;
            this.maxTestTime = this.elapsedTimes[i];
        }
        this.averageTestTime = (double)sum / (double)this.timesCounter;
        long sqrSum = 0L;
        for (int i = 0; i < this.timesCounter; ++i) {
            sqrSum = (long)((double)sqrSum + ((double)this.elapsedTimes[i] - this.averageTestTime) * ((double)this.elapsedTimes[i] - this.averageTestTime));
        }
        this.standardDeviation = Math.sqrt((double)sqrSum / (double)this.timesCounter);
    }

    public String toString() {
        String results = "Test iterations: " + this.testIterations + "\n" + "Min time: " + this.minTestTime + " ms\n" + "Max time: " + this.maxTestTime + " ms\n" + "Average time: " + this.averageTestTime + " ms\n" + "Std. deviation: " + this.standardDeviation + "\n";
        results = results + "Test times:\n";
        for (int i = 0; i < this.timesCounter; ++i) {
            results = results + (i + 1) + ". iteration: " + this.elapsedTimes[i] + "ms\n";
        }
        return results;
    }
}

