/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util.random;

import java.util.Random;
import org.neuroph.core.Connection;
import org.neuroph.core.Layer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.Neuron;

public class WeightsRandomizer {
    protected Random randomGenerator;

    public WeightsRandomizer() {
        this.randomGenerator = new Random();
    }

    public WeightsRandomizer(Random randomGenerator) {
        this.randomGenerator = randomGenerator;
    }

    public Random getRandomGenerator() {
        return this.randomGenerator;
    }

    public void setRandomGenerator(Random randomGenerator) {
        this.randomGenerator = randomGenerator;
    }

    public void randomize(NeuralNetwork neuralNetwork) {
        for (Layer layer : neuralNetwork.getLayers()) {
            this.randomize(layer);
        }
    }

    public void randomize(Layer layer) {
        for (Neuron neuron : layer.getNeurons()) {
            this.randomize(neuron);
        }
    }

    public void randomize(Neuron neuron) {
        int numberOfInputConnections = neuron.getInputConnections().length;
        double coefficient = 1.0 / Math.sqrt(numberOfInputConnections);
        coefficient = coefficient == 0.0 ? 1.0 : coefficient;
        for (Connection connection : neuron.getInputConnections()) {
            connection.getWeight().setValue(this.nextRandomWeight());
        }
    }

    protected double nextRandomWeight() {
        return this.randomGenerator.nextDouble();
    }
}

