/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api;

import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.exception.AlreadyExistsException;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.CreationException;
import org.bonitasoft.engine.exception.DeletionException;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.engine.exception.UpdateException;
import org.bonitasoft.engine.identity.ContactData;
import org.bonitasoft.engine.identity.User;
import org.bonitasoft.engine.identity.UserCreator;
import org.bonitasoft.engine.identity.UserCriterion;
import org.bonitasoft.engine.identity.UserNotFoundException;
import org.bonitasoft.engine.identity.UserUpdater;
import org.bonitasoft.engine.identity.UserWithContactData;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.SearchResult;

public interface UserAPI {
    public User createUser(String var1, String var2) throws AlreadyExistsException, CreationException;

    public User createUser(String var1, String var2, String var3, String var4) throws AlreadyExistsException, CreationException;

    public User createUser(UserCreator var1) throws AlreadyExistsException, CreationException;

    public User updateUser(long var1, UserUpdater var3) throws UserNotFoundException, UpdateException;

    public void deleteUser(long var1) throws DeletionException;

    public void deleteUser(String var1) throws DeletionException;

    public void deleteUsers(List<Long> var1) throws DeletionException;

    public User getUser(long var1) throws UserNotFoundException;

    public User getUserByUserName(String var1) throws UserNotFoundException;

    public UserWithContactData getUserWithProfessionalDetails(long var1) throws UserNotFoundException;

    public ContactData getUserContactData(long var1, boolean var3) throws UserNotFoundException;

    public long getNumberOfUsers();

    public List<User> getUsers(int var1, int var2, UserCriterion var3);

    public Map<Long, User> getUsers(List<Long> var1);

    public Map<String, User> getUsersByUsernames(List<String> var1);

    public SearchResult<User> searchUsers(SearchOptions var1) throws SearchException;

    public long getNumberOfUsersInRole(long var1);

    public List<User> getUsersInRole(long var1, int var3, int var4, UserCriterion var5);

    public long getNumberOfUsersInGroup(long var1) throws BonitaException;

    public List<User> getUsersInGroup(long var1, int var3, int var4, UserCriterion var5);

    public List<Long> getUserIdsWithCustomUserInfo(String var1, String var2, boolean var3, int var4, int var5);
}

