/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.bar;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveContribution;
import org.bonitasoft.engine.io.IOUtil;

public abstract class ResourceInSpecificFolderContribution
implements BusinessArchiveContribution {
    @Override
    public boolean readFromBarFolder(BusinessArchive businessArchive, File barFolder) throws IOException {
        File folder = new File(barFolder, this.getFolderName());
        if (folder.exists() && !folder.isFile()) {
            File[] listFiles;
            for (File file : listFiles = folder.listFiles()) {
                byte[] content = IOUtil.getContent(file);
                businessArchive.addResource(this.getFolderName() + '/' + file.getName(), content);
            }
            return listFiles.length > 0;
        }
        return false;
    }

    protected abstract String getFolderName();

    @Override
    public void saveToBarFolder(BusinessArchive businessArchive, File barFolder) throws IOException {
        File folder = new File(barFolder, this.getFolderName());
        folder.mkdir();
        int beginIndex = this.getFolderName().length();
        Map<String, byte[]> resources = businessArchive.getResources("^" + this.getFolderName() + "/.*$");
        for (Map.Entry<String, byte[]> entry : resources.entrySet()) {
            File file = new File(folder, entry.getKey().substring(beginIndex));
            IOUtil.write(file, entry);
        }
    }

    @Override
    public boolean isMandatory() {
        return false;
    }
}

