/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.bar.xml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bonitasoft.engine.bpm.actor.ActorDefinition;
import org.bonitasoft.engine.bpm.businessdata.BusinessDataDefinition;
import org.bonitasoft.engine.bpm.connector.ConnectorDefinition;
import org.bonitasoft.engine.bpm.connector.FailAction;
import org.bonitasoft.engine.bpm.data.DataDefinition;
import org.bonitasoft.engine.bpm.data.TextDataDefinition;
import org.bonitasoft.engine.bpm.data.XMLDataDefinition;
import org.bonitasoft.engine.bpm.document.DocumentDefinition;
import org.bonitasoft.engine.bpm.document.DocumentListDefinition;
import org.bonitasoft.engine.bpm.flownode.ActivityDefinition;
import org.bonitasoft.engine.bpm.flownode.AutomaticTaskDefinition;
import org.bonitasoft.engine.bpm.flownode.BoundaryEventDefinition;
import org.bonitasoft.engine.bpm.flownode.CallActivityDefinition;
import org.bonitasoft.engine.bpm.flownode.CatchErrorEventTriggerDefinition;
import org.bonitasoft.engine.bpm.flownode.CatchEventDefinition;
import org.bonitasoft.engine.bpm.flownode.CatchMessageEventTriggerDefinition;
import org.bonitasoft.engine.bpm.flownode.CatchSignalEventTriggerDefinition;
import org.bonitasoft.engine.bpm.flownode.CorrelationDefinition;
import org.bonitasoft.engine.bpm.flownode.EndEventDefinition;
import org.bonitasoft.engine.bpm.flownode.FlowNodeDefinition;
import org.bonitasoft.engine.bpm.flownode.GatewayDefinition;
import org.bonitasoft.engine.bpm.flownode.IntermediateCatchEventDefinition;
import org.bonitasoft.engine.bpm.flownode.IntermediateThrowEventDefinition;
import org.bonitasoft.engine.bpm.flownode.LoopCharacteristics;
import org.bonitasoft.engine.bpm.flownode.ManualTaskDefinition;
import org.bonitasoft.engine.bpm.flownode.ReceiveTaskDefinition;
import org.bonitasoft.engine.bpm.flownode.SendTaskDefinition;
import org.bonitasoft.engine.bpm.flownode.StartEventDefinition;
import org.bonitasoft.engine.bpm.flownode.TerminateEventTriggerDefinition;
import org.bonitasoft.engine.bpm.flownode.ThrowErrorEventTriggerDefinition;
import org.bonitasoft.engine.bpm.flownode.ThrowEventDefinition;
import org.bonitasoft.engine.bpm.flownode.ThrowMessageEventTriggerDefinition;
import org.bonitasoft.engine.bpm.flownode.ThrowSignalEventTriggerDefinition;
import org.bonitasoft.engine.bpm.flownode.TimerEventTriggerDefinition;
import org.bonitasoft.engine.bpm.flownode.TransitionDefinition;
import org.bonitasoft.engine.bpm.flownode.UserTaskDefinition;
import org.bonitasoft.engine.bpm.flownode.impl.FlowElementContainerDefinition;
import org.bonitasoft.engine.bpm.flownode.impl.HumanTaskDefinition;
import org.bonitasoft.engine.bpm.flownode.impl.internal.MultiInstanceLoopCharacteristics;
import org.bonitasoft.engine.bpm.flownode.impl.internal.StandardLoopCharacteristics;
import org.bonitasoft.engine.bpm.parameter.ParameterDefinition;
import org.bonitasoft.engine.bpm.process.DesignProcessDefinition;
import org.bonitasoft.engine.bpm.process.SubProcessDefinition;
import org.bonitasoft.engine.bpm.process.impl.internal.SubProcessDefinitionImpl;
import org.bonitasoft.engine.bpm.userfilter.UserFilterDefinition;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.io.xml.XMLNode;
import org.bonitasoft.engine.operation.LeftOperand;
import org.bonitasoft.engine.operation.Operation;

public class XMLProcessDefinition {
    public static final String CORRELATION_VALUE = "value";
    public static final String CORRELATION_KEY = "key";
    public static final String NAMESPACE = "http://www.bonitasoft.org/ns/process/client/6.3";
    public static final String PROCESS_NODE = "processDefinition";
    public static final String TRANSITIONS_NODE = "transitions";
    public static final String FLOW_ELEMENTS_NODE = "flowElements";
    public static final String FLOW_NODES_NODE = "flowNodes";
    public static final String CONNECTORS_NODE = "connectors";
    public static final String DATA_DEFINITIONS_NODE = "dataDefinitions";
    public static final String DOCUMENT_DEFINITIONS_NODE = "documentDefinitions";
    public static final String DOCUMENT_DEFINITION_NODE = "documentDefinition";
    public static final String DOCUMENT_LIST_DEFINITIONS_NODE = "documentListDefinitions";
    public static final String DOCUMENT_LIST_DEFINITION_NODE = "documentListDefinition";
    public static final String DOCUMENT_DEFINITION_URL = "url";
    public static final String DOCUMENT_DEFINITION_FILE = "file";
    public static final String DOCUMENT_DEFINITION_FILE_NAME = "fileName";
    public static final String DOCUMENT_DEFINITION_MIME_TYPE = "mimeType";
    public static final String OPERATIONS_NODE = "operations";
    public static final String DEPENDENCIES_NODE = "dependencies";
    public static final String ACTORS_NODE = "actors";
    public static final String PARAMETERS_NODE = "parameters";
    public static final String ACTOR_NODE = "actor";
    public static final String INITIATOR_NODE = "actorInitiator";
    public static final String CONNECTOR_NODE = "connector";
    public static final String USER_FILTER_NODE = "userFilter";
    public static final String DATA_DEFINITION_NODE = "dataDefinition";
    public static final String USER_TASK_NODE = "userTask";
    public static final String MANUAL_TASK_NODE = "manualTask";
    public static final String AUTOMATIC_TASK_NODE = "automaticTask";
    public static final String RECEIVE_TASK_NODE = "receiveTask";
    public static final String SEND_TASK_NODE = "sendTask";
    public static final String CALL_ACTIVITY_NODE = "callActivity";
    public static final String DATA_INPUT_OPERATION_NODE = "dataInputOperation";
    public static final String DATA_OUTPUT_OPERATION_NODE = "dataOutputOperation";
    public static final String CALLABLE_ELEMENT_NODE = "callableElement";
    public static final String CALLABLE_ELEMENT_VERSION_NODE = "callableElementVersion";
    public static final String CALLABLE_ELEMENT_TYPE = "callableElementType";
    public static final String GATEWAY_NODE = "gateway";
    public static final String PARAMETER_NODE = "parameter";
    public static final String START_EVENT_NODE = "startEvent";
    public static final String INTERMEDIATE_CATCH_EVENT_NODE = "intermediateCatchEvent";
    public static final String INTERMEDIATE_THROW_EVENT_NODE = "intermediateThrowEvent";
    public static final String END_EVENT_NODE = "endEvent";
    public static final String BOUNDARY_EVENTS_NODE = "boundaryEvents";
    public static final String BOUNDARY_EVENT_NODE = "boundaryEvent";
    public static final String INTERRUPTING = "interrupting";
    public static final String NAME = "name";
    public static final String ID = "id";
    public static final String IDREF = "idref";
    public static final String VERSION = "version";
    public static final String DESCRIPTION = "description";
    public static final String DISPLAY_NAME = "displayName";
    public static final String DISPLAY_DESCRIPTION = "displayDescription";
    public static final String STRING_INDEXES = "stringIndexes";
    public static final String STRING_INDEX = "stringIndex";
    public static final String BUSINESS_DATA_DEFINITION_NODE = "businessDataDefinition";
    public static final String BUSINESS_DATA_DEFINITIONS_NODE = "businessDataDefinitions";
    public static final String BUSINESS_DATA_DEFINITION_CLASS = "className";
    public static final String BUSINESS_DATA_DEFINITION_IS_MULTIPLE = "multiple";
    public static final String INDEX = "index";
    public static final String LABEL = "label";
    public static final String DISPLAY_DESCRIPTION_AFTER_COMPLETION = "displayDescriptionAfterCompletion";
    public static final String INCOMING_TRANSITION = "incomingTransition";
    public static final String OUTGOING_TRANSITION = "outgoingTransition";
    public static final String TRANSITION_NODE = "transition";
    public static final String TRANSITION_SOURCE = "source";
    public static final String TRANSITION_TARGET = "target";
    public static final String TRANSITION_CONDITION = "condition";
    public static final String ACTOR_NAME = "actorName";
    public static final String CONNECTOR_ID = "connectorId";
    public static final String CONNECTOR_ACTIVATION_EVENT = "activationEvent";
    public static final String CONNECTOR_FAIL_ACTION = "failAction";
    public static final String CONNECTOR_ERROR_CODE = "errorCode";
    public static final String CONNECTOR_INPUT = "input";
    public static final String CONNECTOR_INPUT_NAME = "inputName";
    public static final String USER_FILTER_ID = "userFilterId";
    public static final String DATA_DEFINITION_CLASS = "className";
    public static final String DATA_DEFINITION_TRANSIENT = "transient";
    public static final String EXPRESSION_NODE = "expression";
    public static final String EXPRESSION_TYPE = "expressionType";
    public static final String EXPRESSION_RETURN_TYPE = "returnType";
    public static final String EXPRESSION_INTERPRETER = "interpreter";
    public static final String EXPRESSION_CONTENT = "content";
    public static final String GATEWAY_TYPE = "gatewayType";
    public static final String DEFAULT_TRANSITION = "defaultTransition";
    public static final String PARAMETER_TYPE = "type";
    public static final String BOS_VERSION = "bos_version";
    private static final String BOS_CURRENT_VERSION = "6.0-SNAPSHOT";
    public static final String DEFAULT_VALUE_NODE = "defaultValue";
    public static final String TIMER_EVENT_TRIGGER_NODE = "timerEventTrigger";
    public static final String CATCH_MESSAGE_EVENT_TRIGGER_NODE = "catchMessageEventTrigger";
    public static final String THROW_MESSAGE_EVENT_TRIGGER_NODE = "throwMessageEventTrigger";
    public static final String CATCH_SIGNAL_EVENT_TRIGGER_NODE = "catchSignalEventTrigger";
    public static final String CATCH_ERROR_EVENT_TRIGGER_NODE = "catchErrorEventTrigger";
    public static final String THROW_SIGNAL_EVENT_TRIGGER_NODE = "throwSignalEventTrigger";
    public static final String THROW_ERROR_EVENT_TRIGGER_NODE = "throwErrorEventTrigger";
    public static final String TERMINATE_EVENT_TRIGGER_NODE = "terminateEventTrigger";
    public static final String TIMER_EVENT_TRIGGER_TIMER_TYPE = "type";
    public static final String ERROR_CODE = "errorCode";
    public static final String CORRELATION_NODE = "correlation";
    public static final String TARGET_PROCESS = "targetProcess";
    public static final String TARGET_FLOW_NODE = "targetFlowNode";
    public static final String OPERATION_NODE = "operation";
    public static final String OPERATION_RIGHT_OPERAND = "rightOperand";
    public static final String OPERATION_LEFT_OPERAND = "leftOperand";
    public static final String OPERATION_OPERATOR_TYPE = "operatorType";
    public static final String OPERATION_OPERATOR = "operator";
    public static final String LEFT_OPERAND_NAME = "name";
    public static final String LEFT_OPERAND_TYPE = "type";
    public static final String CONNECTOR_INPUTS_NODE = "inputs";
    public static final String CONNECTOR_OUTPUTS_NODE = "outputs";
    public static final String CONNECTOR_VERSION = "version";
    public static final String STANDARD_LOOP_CHARACTERISTICS_NODE = "standardLoopCharacteristics";
    public static final String LOOP_CONDITION = "loopCondition";
    public static final String TEST_BEFORE = "testBefore";
    public static final String LOOP_MAX = "loopMax";
    public static final String MULTI_INSTANCE_LOOP_CHARACTERISTICS_NODE = "multiInstanceLoopCharacteristics";
    public static final String MULTI_INSTANCE_IS_SEQUENTIAL = "isSequential";
    public static final String MULTI_INSTANCE_DATA_INPUT_ITEM_REF = "dataInputItemRef";
    public static final String MULTI_INSTANCE_DATA_OUTPUT_ITEM_REF = "dataOutputItemRef";
    public static final String MULTI_INSTANCE_LOOP_DATA_INPUT = "loopDataInputRef";
    public static final String MULTI_INSTANCE_LOOP_DATA_OUTPUT = "loopDataOutputRef";
    public static final String MULTI_INSTANCE_LOOP_CARDINALITY = "loopCardinality";
    public static final String MULTI_INSTANCE_COMPLETION_CONDITION = "completionCondition";
    public static final String PRIORITY = "priority";
    public static final String EXPECTED_DURATION = "expectedDuration";
    public static final String XML_DATA_DEFINITION_NAMESPACE = "namespace";
    public static final String XML_DATA_DEFINITION_ELEMENT = "element";
    public static final String XML_DATA_DEFINITION_NODE = "xmlDataDefinition";
    public static final String TEXT_DATA_DEFINITION_NODE = "textDataDefinition";
    public static final String TEXT_DATA_DEFINITION_LONG = "longText";
    public static final String SUB_PROCESS = "subProcess";
    public static final String TRIGGERED_BY_EVENT = "triggeredByEvent";
    public Map<Object, String> objectToId = new HashMap<Object, String>();

    public XMLNode getXMLProcessDefinition(DesignProcessDefinition processDefinition) {
        XMLNode rootNode = new XMLNode(PROCESS_NODE);
        rootNode.addAttribute("name", processDefinition.getName());
        rootNode.addAttribute(DESCRIPTION, processDefinition.getDescription());
        rootNode.addAttribute(DISPLAY_NAME, processDefinition.getDisplayName());
        rootNode.addAttribute(DISPLAY_DESCRIPTION, processDefinition.getDisplayDescription());
        rootNode.addAttribute("version", processDefinition.getVersion());
        rootNode.addAttribute(BOS_VERSION, BOS_CURRENT_VERSION);
        rootNode.addAttribute("xmlns", NAMESPACE);
        XMLNode stringIndexes = new XMLNode(STRING_INDEXES);
        for (int i = 1; i <= 5; ++i) {
            XMLNode xmlNode = new XMLNode(STRING_INDEX);
            xmlNode.addAttribute(INDEX, String.valueOf(i));
            xmlNode.addAttribute(LABEL, processDefinition.getStringIndexLabel(i));
            Expression stringIndexValue = processDefinition.getStringIndexValue(i);
            if (stringIndexValue != null) {
                XMLNode value = new XMLNode(EXPRESSION_NODE);
                this.fillExpressionNode(value, stringIndexValue, false);
                xmlNode.addChild(value);
            }
            stringIndexes.addChild(xmlNode);
        }
        rootNode.addChild(stringIndexes);
        this.createAndFillFlowElements(rootNode, processDefinition.getProcessContainer());
        XMLNode dependencies = new XMLNode(DEPENDENCIES_NODE);
        rootNode.addChild(dependencies);
        XMLNode parameters = new XMLNode(PARAMETERS_NODE);
        dependencies.addChild(parameters);
        for (ParameterDefinition parameter : processDefinition.getParameters()) {
            XMLNode parameterNode = new XMLNode(PARAMETER_NODE);
            this.fillParameterNode(parameterNode, parameter);
            parameters.addChild(parameterNode);
        }
        XMLNode actors = new XMLNode(ACTORS_NODE);
        dependencies.addChild(actors);
        for (ActorDefinition actor : processDefinition.getActorsList()) {
            XMLNode actorNode = new XMLNode(ACTOR_NODE);
            this.fillActorNode(actorNode, actor);
            actors.addChild(actorNode);
        }
        ActorDefinition actorInitiator = processDefinition.getActorInitiator();
        if (actorInitiator != null) {
            XMLNode initiatorNode = new XMLNode(INITIATOR_NODE);
            rootNode.addChild(initiatorNode);
            this.fillInitiatorActorNode(initiatorNode, actorInitiator);
        }
        return rootNode;
    }

    private void createAndFillFlowElements(XMLNode containerNode, FlowElementContainerDefinition containerDefinition) {
        XMLNode flowElements = new XMLNode(FLOW_ELEMENTS_NODE);
        containerNode.addChild(flowElements);
        XMLNode transitionsNode = new XMLNode(TRANSITIONS_NODE);
        flowElements.addChild(transitionsNode);
        for (TransitionDefinition transition : containerDefinition.getTransitions()) {
            XMLNode transitionNode = new XMLNode(TRANSITION_NODE);
            String id = String.valueOf(Math.abs(UUID.randomUUID().getMostSignificantBits()));
            this.objectToId.put(transition, id);
            transitionNode.addAttribute(ID, id);
            this.fillTransitionNode(transitionNode, transition);
            transitionsNode.addChild(transitionNode);
        }
        XMLNode connectorsNode = new XMLNode(CONNECTORS_NODE);
        flowElements.addChild(connectorsNode);
        for (ConnectorDefinition connector : containerDefinition.getConnectors()) {
            XMLNode connectorNode = new XMLNode(CONNECTOR_NODE);
            this.fillConnectorNode(connectorNode, connector);
            connectorsNode.addChild(connectorNode);
        }
        this.addBusinessDataDefinitionNodes(containerDefinition.getBusinessDataDefinitions(), flowElements);
        XMLNode dataDefinitionsNode = new XMLNode(DATA_DEFINITIONS_NODE);
        flowElements.addChild(dataDefinitionsNode);
        for (DataDefinition dataDefinition : containerDefinition.getDataDefinitions()) {
            XMLNode dataDefinitionNode = this.getDataDefinitionNode(dataDefinition);
            dataDefinitionsNode.addChild(dataDefinitionNode);
        }
        XMLNode documentDefinitionsNode = new XMLNode(DOCUMENT_DEFINITIONS_NODE);
        flowElements.addChild(documentDefinitionsNode);
        for (DocumentDefinition document : containerDefinition.getDocumentDefinitions()) {
            XMLNode documentDefinitionNode = new XMLNode(DOCUMENT_DEFINITION_NODE);
            this.fillDocumentDefinitionNode(documentDefinitionNode, document);
            documentDefinitionsNode.addChild(documentDefinitionNode);
        }
        XMLNode documentListDefinitionsNode = new XMLNode(DOCUMENT_LIST_DEFINITIONS_NODE);
        flowElements.addChild(documentListDefinitionsNode);
        for (DocumentListDefinition documentList : containerDefinition.getDocumentListDefinitions()) {
            XMLNode documentListDefinitionNode = new XMLNode(DOCUMENT_LIST_DEFINITION_NODE);
            this.fillDocumentListDefinitionNode(documentListDefinitionNode, documentList);
            documentListDefinitionsNode.addChild(documentListDefinitionNode);
        }
        this.createAndFillFlowNodes(containerDefinition, flowElements);
    }

    private void createAndFillFlowNodes(FlowElementContainerDefinition containerDefinition, XMLNode flowElements) {
        XMLNode flowNodes = new XMLNode(FLOW_NODES_NODE);
        flowElements.addChild(flowNodes);
        for (ActivityDefinition activity : containerDefinition.getActivities()) {
            String xmlNodeName = this.getXmlNodeName(activity);
            XMLNode activityNode = new XMLNode(xmlNodeName);
            if (activity instanceof HumanTaskDefinition) {
                this.fillHumanTask(activity, activityNode);
            }
            this.fillFlowNode(activityNode, activity);
            this.addDataDefinitionNodes(activity, activityNode);
            this.addBusinessDataDefinitionNodes(activity.getBusinessDataDefinitions(), activityNode);
            this.addOperationNodes(activity, activityNode);
            this.addLoopCharacteristics(activity, activityNode);
            this.addBoundaryEventDefinitionsNode(activity, activityNode);
            if (activity instanceof HumanTaskDefinition) {
                HumanTaskDefinition humanTaskDefinition = (HumanTaskDefinition)activity;
                if (humanTaskDefinition.getUserFilter() != null) {
                    XMLNode userFilterNode = new XMLNode(USER_FILTER_NODE);
                    this.fillUserFilterNode(userFilterNode, humanTaskDefinition.getUserFilter());
                    activityNode.addChild(userFilterNode);
                }
            } else if (activity instanceof CallActivityDefinition) {
                this.fillCallActivity((CallActivityDefinition)activity, activityNode);
            } else if (activity instanceof SubProcessDefinition) {
                this.fillSubProcess((SubProcessDefinition)activity, activityNode);
            } else if (activity instanceof ReceiveTaskDefinition) {
                this.fillReceiveTask((ReceiveTaskDefinition)activity, activityNode);
            } else if (activity instanceof SendTaskDefinition) {
                this.fillSendTask((SendTaskDefinition)activity, activityNode);
            }
            flowNodes.addChild(activityNode);
        }
        for (GatewayDefinition gateway : containerDefinition.getGatewaysList()) {
            XMLNode gatewayNode = new XMLNode(GATEWAY_NODE);
            this.fillGatewayNode(gatewayNode, gateway);
            flowNodes.addChild(gatewayNode);
        }
        this.createAndFillStartEvents(containerDefinition, flowNodes);
        this.createAndfillIntermediateCatchEvents(containerDefinition, flowNodes);
        this.createAndFillIntermediateThrowEvents(containerDefinition, flowNodes);
        this.createAndFillEndEvents(containerDefinition, flowNodes);
    }

    private void addBusinessDataDefinitionNodes(List<BusinessDataDefinition> businessDataDefinitions, XMLNode containerNode) {
        if (!businessDataDefinitions.isEmpty()) {
            XMLNode businessDataDefinitionsNode = new XMLNode(BUSINESS_DATA_DEFINITIONS_NODE);
            containerNode.addChild(businessDataDefinitionsNode);
            for (BusinessDataDefinition businessDataDefinition : businessDataDefinitions) {
                XMLNode businessDataDefinitionNode = this.getBusinessDataDefinitionNode(businessDataDefinition);
                businessDataDefinitionsNode.addChild(businessDataDefinitionNode);
            }
        }
    }

    private void addBoundaryEventDefinitionsNode(ActivityDefinition activity, XMLNode activityNode) {
        XMLNode boundaryEventsNode = new XMLNode(BOUNDARY_EVENTS_NODE);
        activityNode.addChild(boundaryEventsNode);
        this.addBoundaryEventDefinitionNodes(activity, boundaryEventsNode);
    }

    private void addBoundaryEventDefinitionNodes(ActivityDefinition activity, XMLNode boundaryEventsNode) {
        for (BoundaryEventDefinition boundaryEvent : activity.getBoundaryEventDefinitions()) {
            XMLNode boundaryEventNode = new XMLNode(BOUNDARY_EVENT_NODE);
            this.fillFlowNode(boundaryEventNode, boundaryEvent);
            this.fillCatchEventDefinition(boundaryEventNode, boundaryEvent);
            boundaryEventsNode.addChild(boundaryEventNode);
        }
    }

    private String getXmlNodeName(ActivityDefinition activity) {
        String xmlNodeName = null;
        if (activity instanceof CallActivityDefinition) {
            xmlNodeName = CALL_ACTIVITY_NODE;
        } else if (activity instanceof AutomaticTaskDefinition) {
            xmlNodeName = AUTOMATIC_TASK_NODE;
        } else if (activity instanceof ReceiveTaskDefinition) {
            xmlNodeName = RECEIVE_TASK_NODE;
        } else if (activity instanceof SendTaskDefinition) {
            xmlNodeName = SEND_TASK_NODE;
        } else if (activity instanceof ManualTaskDefinition) {
            xmlNodeName = MANUAL_TASK_NODE;
        } else if (activity instanceof UserTaskDefinition) {
            xmlNodeName = USER_TASK_NODE;
        } else if (activity instanceof SubProcessDefinitionImpl) {
            xmlNodeName = SUB_PROCESS;
        }
        return xmlNodeName;
    }

    private void fillSubProcess(SubProcessDefinition activity, XMLNode activityNode) {
        activityNode.addAttribute(TRIGGERED_BY_EVENT, String.valueOf(activity.isTriggeredByEvent()));
        this.createAndFillFlowElements(activityNode, activity.getSubProcessContainer());
    }

    private void fillCallActivity(CallActivityDefinition activity, XMLNode activityNode) {
        this.addExpressionNode(activityNode, CALLABLE_ELEMENT_NODE, activity.getCallableElement());
        this.addExpressionNode(activityNode, CALLABLE_ELEMENT_VERSION_NODE, activity.getCallableElementVersion());
        this.createAndfillOperations(activityNode, activity.getDataInputOperations(), DATA_INPUT_OPERATION_NODE);
        this.createAndfillOperations(activityNode, activity.getDataOutputOperations(), DATA_OUTPUT_OPERATION_NODE);
        activityNode.addAttribute(CALLABLE_ELEMENT_TYPE, activity.getCallableElementType().name());
    }

    private void fillReceiveTask(ReceiveTaskDefinition receiveTask, XMLNode activityNode) {
        this.createAndfillMessageEventTriggers(activityNode, receiveTask.getTrigger());
    }

    private void fillSendTask(SendTaskDefinition sendTask, XMLNode activityNode) {
        this.createAndfillMessageEventTrigger(activityNode, sendTask.getMessageTrigger());
    }

    private void fillHumanTask(ActivityDefinition activity, XMLNode activityNode) {
        HumanTaskDefinition humanTaskDefinition = (HumanTaskDefinition)activity;
        String actorName = humanTaskDefinition.getActorName();
        activityNode.addAttribute(ACTOR_NAME, actorName);
        String priority = humanTaskDefinition.getPriority();
        activityNode.addAttribute(PRIORITY, priority);
        Long expectedDuration = humanTaskDefinition.getExpectedDuration();
        if (expectedDuration != null) {
            activityNode.addAttribute(EXPECTED_DURATION, String.valueOf(expectedDuration));
        }
    }

    private void createAndFillIntermediateThrowEvents(FlowElementContainerDefinition containerDefinition, XMLNode flowNodes) {
        for (IntermediateThrowEventDefinition intermediateThrowEvent : containerDefinition.getIntermediateThrowEvents()) {
            XMLNode intermediateThrowEventNode = new XMLNode(INTERMEDIATE_THROW_EVENT_NODE);
            this.fillFlowNode(intermediateThrowEventNode, intermediateThrowEvent);
            this.fillThrowEventDefinition(intermediateThrowEventNode, intermediateThrowEvent);
            flowNodes.addChild(intermediateThrowEventNode);
        }
    }

    private void createAndFillStartEvents(FlowElementContainerDefinition containerDefinition, XMLNode flowNodes) {
        for (StartEventDefinition startEvent : containerDefinition.getStartEvents()) {
            XMLNode startEventNode = new XMLNode(START_EVENT_NODE);
            this.fillFlowNode(startEventNode, startEvent);
            this.fillCatchEventDefinition(startEventNode, startEvent);
            flowNodes.addChild(startEventNode);
        }
    }

    private void createAndFillEndEvents(FlowElementContainerDefinition containerDefinition, XMLNode flowNodes) {
        for (EndEventDefinition endEvent : containerDefinition.getEndEvents()) {
            XMLNode endEventNode = new XMLNode(END_EVENT_NODE);
            this.fillFlowNode(endEventNode, endEvent);
            this.fillThrowEventDefinition(endEventNode, endEvent);
            this.createAndFillTerminateEventTrigger(endEventNode, endEvent);
            this.createAndfillErrorEventTriggers(endEventNode, endEvent);
            flowNodes.addChild(endEventNode);
        }
    }

    private void createAndFillTerminateEventTrigger(XMLNode eventNode, EndEventDefinition event) {
        TerminateEventTriggerDefinition terminateEventTriggerDefinition = event.getTerminateEventTriggerDefinition();
        if (terminateEventTriggerDefinition != null) {
            XMLNode terminateEventTriggerNode = new XMLNode(TERMINATE_EVENT_TRIGGER_NODE);
            eventNode.addChild(terminateEventTriggerNode);
        }
    }

    private void fillThrowEventDefinition(XMLNode eventNode, ThrowEventDefinition event) {
        this.createAndfillMessageEventTriggers(eventNode, event);
        this.createAndfillSignalEventTriggers(eventNode, event);
    }

    private void createAndfillSignalEventTriggers(XMLNode eventNode, ThrowEventDefinition event) {
        for (ThrowSignalEventTriggerDefinition signalEventTrigger : event.getSignalEventTriggerDefinitions()) {
            XMLNode signalEventTriggerNode = new XMLNode(THROW_SIGNAL_EVENT_TRIGGER_NODE);
            signalEventTriggerNode.addAttribute("name", signalEventTrigger.getSignalName());
            eventNode.addChild(signalEventTriggerNode);
        }
    }

    private void createAndfillErrorEventTriggers(XMLNode eventNode, EndEventDefinition event) {
        for (ThrowErrorEventTriggerDefinition errorEventTrigger : event.getErrorEventTriggerDefinitions()) {
            XMLNode errorEventTriggerNode = new XMLNode(THROW_ERROR_EVENT_TRIGGER_NODE);
            errorEventTriggerNode.addAttribute("errorCode", errorEventTrigger.getErrorCode());
            eventNode.addChild(errorEventTriggerNode);
        }
    }

    private void createAndfillMessageEventTriggers(XMLNode eventNode, ThrowEventDefinition event) {
        for (ThrowMessageEventTriggerDefinition messageEventTrigger : event.getMessageEventTriggerDefinitions()) {
            this.createAndfillMessageEventTrigger(eventNode, messageEventTrigger);
        }
    }

    private void createAndfillMessageEventTrigger(XMLNode eventNode, ThrowMessageEventTriggerDefinition messageEventTrigger) {
        XMLNode messageEventTriggerNode = new XMLNode(THROW_MESSAGE_EVENT_TRIGGER_NODE);
        messageEventTriggerNode.addAttribute("name", messageEventTrigger.getMessageName());
        this.addExpressionNode(messageEventTriggerNode, TARGET_PROCESS, messageEventTrigger.getTargetProcess());
        Expression targetFlowNode = messageEventTrigger.getTargetFlowNode();
        if (targetFlowNode != null) {
            this.addExpressionNode(messageEventTriggerNode, TARGET_FLOW_NODE, targetFlowNode);
        }
        this.createAndFillDataDefinitions(messageEventTriggerNode, messageEventTrigger);
        this.createAndfillCorrelations(messageEventTriggerNode, messageEventTrigger.getCorrelations());
        eventNode.addChild(messageEventTriggerNode);
    }

    private void createAndFillDataDefinitions(XMLNode messageEventTriggerNode, ThrowMessageEventTriggerDefinition messageEventTrigger) {
        for (DataDefinition dataDefinition : messageEventTrigger.getDataDefinitions()) {
            XMLNode dataDefinitionNode = this.getDataDefinitionNode(dataDefinition);
            messageEventTriggerNode.addChild(dataDefinitionNode);
        }
    }

    private void addDataDefinitionNodes(ActivityDefinition activity, XMLNode activityNode) {
        XMLNode dataDefinitionsNodeFromActivity = new XMLNode(DATA_DEFINITIONS_NODE);
        activityNode.addChild(dataDefinitionsNodeFromActivity);
        for (DataDefinition dataDefinition : activity.getDataDefinitions()) {
            XMLNode dataDefinitionNode = this.getDataDefinitionNode(dataDefinition);
            dataDefinitionsNodeFromActivity.addChild(dataDefinitionNode);
        }
    }

    private void addOperationNodes(ActivityDefinition activity, XMLNode activityNode) {
        XMLNode operationsNode = new XMLNode(OPERATIONS_NODE);
        activityNode.addChild(operationsNode);
        this.createAndfillOperations(operationsNode, activity.getOperations(), OPERATION_NODE);
    }

    private void addLoopCharacteristics(ActivityDefinition activity, XMLNode activityNode) {
        LoopCharacteristics loopCharacteristics = activity.getLoopCharacteristics();
        if (loopCharacteristics != null) {
            XMLNode loopNode;
            if (loopCharacteristics instanceof StandardLoopCharacteristics) {
                loopNode = new XMLNode(STANDARD_LOOP_CHARACTERISTICS_NODE);
                StandardLoopCharacteristics loop = (StandardLoopCharacteristics)loopCharacteristics;
                loopNode.addAttribute(TEST_BEFORE, String.valueOf(loop.isTestBefore()));
                Expression loopMax = loop.getLoopMax();
                XMLNode expressionNode = new XMLNode(LOOP_CONDITION);
                this.fillExpressionNode(expressionNode, loop.getLoopCondition(), true);
                loopNode.addChild(expressionNode);
                if (loopMax != null) {
                    XMLNode loopMaxNode = new XMLNode(LOOP_MAX);
                    this.fillExpressionNode(loopMaxNode, loopMax, false);
                    loopNode.addChild(loopMaxNode);
                }
            } else {
                Expression completionCondition;
                loopNode = new XMLNode(MULTI_INSTANCE_LOOP_CHARACTERISTICS_NODE);
                MultiInstanceLoopCharacteristics loop = (MultiInstanceLoopCharacteristics)loopCharacteristics;
                loopNode.addAttribute(MULTI_INSTANCE_IS_SEQUENTIAL, String.valueOf(loop.isSequential()));
                loopNode.addAttribute(MULTI_INSTANCE_DATA_INPUT_ITEM_REF, loop.getDataInputItemRef());
                loopNode.addAttribute(MULTI_INSTANCE_DATA_OUTPUT_ITEM_REF, loop.getDataOutputItemRef());
                loopNode.addAttribute(MULTI_INSTANCE_LOOP_DATA_INPUT, loop.getLoopDataInputRef());
                loopNode.addAttribute(MULTI_INSTANCE_LOOP_DATA_OUTPUT, loop.getLoopDataOutputRef());
                Expression loopCardinality = loop.getLoopCardinality();
                if (loopCardinality != null) {
                    XMLNode expressionNode = new XMLNode(MULTI_INSTANCE_LOOP_CARDINALITY);
                    this.fillExpressionNode(expressionNode, loopCardinality, false);
                    loopNode.addChild(expressionNode);
                }
                if ((completionCondition = loop.getCompletionCondition()) != null) {
                    XMLNode expressionNode = new XMLNode(MULTI_INSTANCE_COMPLETION_CONDITION);
                    this.fillExpressionNode(expressionNode, completionCondition, true);
                    loopNode.addChild(expressionNode);
                }
            }
            activityNode.addChild(loopNode);
        }
    }

    private void createAndfillIntermediateCatchEvents(FlowElementContainerDefinition containerDefinition, XMLNode flowNodes) {
        for (IntermediateCatchEventDefinition intermediateEvent : containerDefinition.getIntermediateCatchEvents()) {
            XMLNode intermediateCatchEventNode = new XMLNode(INTERMEDIATE_CATCH_EVENT_NODE);
            this.fillFlowNode(intermediateCatchEventNode, intermediateEvent);
            this.fillCatchEventDefinition(intermediateCatchEventNode, intermediateEvent);
            flowNodes.addChild(intermediateCatchEventNode);
        }
    }

    private void fillCatchEventDefinition(XMLNode catchEventNode, CatchEventDefinition catchEvent) {
        this.createAndFillTimerEventTriggers(catchEventNode, catchEvent);
        this.createAndfillMessageEventTriggers(catchEventNode, catchEvent);
        this.createAndfillSignalEventTriggers(catchEventNode, catchEvent);
        this.createAndfillErrorEventTriggers(catchEventNode, catchEvent);
        catchEventNode.addAttribute(INTERRUPTING, String.valueOf(catchEvent.isInterrupting()));
    }

    private void createAndFillTimerEventTriggers(XMLNode catchEventNode, CatchEventDefinition catchEvent) {
        for (TimerEventTriggerDefinition timerEventTrigger : catchEvent.getTimerEventTriggerDefinitions()) {
            XMLNode timerEventTriggerNode = new XMLNode(TIMER_EVENT_TRIGGER_NODE);
            timerEventTriggerNode.addAttribute("type", timerEventTrigger.getTimerType().toString());
            XMLNode expression = new XMLNode(EXPRESSION_NODE);
            this.fillExpressionNode(expression, timerEventTrigger.getTimerExpression(), false);
            timerEventTriggerNode.addChild(expression);
            catchEventNode.addChild(timerEventTriggerNode);
        }
    }

    private void createAndfillSignalEventTriggers(XMLNode catchEventNode, CatchEventDefinition catchEvent) {
        for (CatchSignalEventTriggerDefinition signalEventTrigger : catchEvent.getSignalEventTriggerDefinitions()) {
            XMLNode signalEventTriggerNode = new XMLNode(CATCH_SIGNAL_EVENT_TRIGGER_NODE);
            signalEventTriggerNode.addAttribute("name", signalEventTrigger.getSignalName());
            catchEventNode.addChild(signalEventTriggerNode);
        }
    }

    private void createAndfillErrorEventTriggers(XMLNode catchEventNode, CatchEventDefinition catchEvent) {
        for (CatchErrorEventTriggerDefinition errorEventTrigger : catchEvent.getErrorEventTriggerDefinitions()) {
            XMLNode errorEventTriggerNode = new XMLNode(CATCH_ERROR_EVENT_TRIGGER_NODE);
            errorEventTriggerNode.addAttribute("errorCode", errorEventTrigger.getErrorCode());
            catchEventNode.addChild(errorEventTriggerNode);
        }
    }

    private void createAndfillMessageEventTriggers(XMLNode catchEventNode, CatchEventDefinition catchEvent) {
        for (CatchMessageEventTriggerDefinition messageEventTrigger : catchEvent.getMessageEventTriggerDefinitions()) {
            this.createAndfillMessageEventTriggers(catchEventNode, messageEventTrigger);
        }
    }

    private void createAndfillMessageEventTriggers(XMLNode activityNode, CatchMessageEventTriggerDefinition trigger) {
        XMLNode messageEventTriggerNode = new XMLNode(CATCH_MESSAGE_EVENT_TRIGGER_NODE);
        messageEventTriggerNode.addAttribute("name", trigger.getMessageName());
        this.createAndfillCorrelations(messageEventTriggerNode, trigger.getCorrelations());
        this.createAndfillOperations(messageEventTriggerNode, trigger.getOperations(), OPERATION_NODE);
        activityNode.addChild(messageEventTriggerNode);
    }

    private void createAndfillCorrelations(XMLNode messageEventTriggerNode, List<CorrelationDefinition> correlations) {
        for (CorrelationDefinition correlation : correlations) {
            XMLNode correlationNode = new XMLNode(CORRELATION_NODE);
            XMLNode keyNode = new XMLNode(CORRELATION_KEY);
            this.fillExpressionNode(keyNode, correlation.getKey(), false);
            correlationNode.addChild(keyNode);
            XMLNode valueNode = new XMLNode(CORRELATION_VALUE);
            this.fillExpressionNode(valueNode, correlation.getValue(), false);
            correlationNode.addChild(valueNode);
            messageEventTriggerNode.addChild(correlationNode);
        }
    }

    private void createAndfillOperations(XMLNode parentNode, List<Operation> operations, String operationNodeName) {
        for (Operation operation : operations) {
            this.createAndFillOperation(parentNode, operation, operationNodeName);
        }
    }

    private void createAndFillOperation(XMLNode parentNode, Operation operation, String operationNodeName) {
        XMLNode operationNode = new XMLNode(operationNodeName);
        operationNode.addAttribute(OPERATION_OPERATOR_TYPE, operation.getType().name());
        operationNode.addAttribute(OPERATION_OPERATOR, operation.getOperator());
        XMLNode leftOperand = new XMLNode(OPERATION_LEFT_OPERAND);
        this.fillLeftOperandNode(leftOperand, operation.getLeftOperand());
        operationNode.addChild(leftOperand);
        Expression rightOperandExpression = operation.getRightOperand();
        if (rightOperandExpression != null) {
            XMLNode expressionNode = new XMLNode(OPERATION_RIGHT_OPERAND);
            this.fillExpressionNode(expressionNode, operation.getRightOperand(), false);
            operationNode.addChild(expressionNode);
        }
        parentNode.addChild(operationNode);
    }

    private void fillConnectorNode(XMLNode connectorNode, ConnectorDefinition connector) {
        connectorNode.addAttribute("name", connector.getName());
        connectorNode.addAttribute(CONNECTOR_ID, connector.getConnectorId());
        connectorNode.addAttribute("version", connector.getVersion());
        connectorNode.addAttribute(CONNECTOR_ACTIVATION_EVENT, connector.getActivationEvent().toString());
        connectorNode.addAttribute(CONNECTOR_FAIL_ACTION, connector.getFailAction().toString());
        if (connector.getFailAction() == FailAction.ERROR_EVENT) {
            connectorNode.addAttribute("errorCode", connector.getErrorCode());
        }
        Map<String, Expression> inputs = connector.getInputs();
        this.createAndFillInputsNode(connectorNode, inputs);
        XMLNode outputsNode = new XMLNode(CONNECTOR_OUTPUTS_NODE);
        this.createAndfillOperations(outputsNode, connector.getOutputs(), OPERATION_NODE);
        connectorNode.addChild(outputsNode);
    }

    private void createAndFillInputsNode(XMLNode connectorNode, Map<String, Expression> inputs) {
        XMLNode inputsNode = new XMLNode(CONNECTOR_INPUTS_NODE);
        for (Map.Entry<String, Expression> input : inputs.entrySet()) {
            XMLNode inputNode = new XMLNode(CONNECTOR_INPUT);
            inputNode.addAttribute("name", input.getKey());
            XMLNode expressionNode = new XMLNode(EXPRESSION_NODE);
            this.fillExpressionNode(expressionNode, input.getValue(), false);
            inputNode.addChild(expressionNode);
            inputsNode.addChild(inputNode);
        }
        connectorNode.addChild(inputsNode);
    }

    private void fillLeftOperandNode(XMLNode rightOperandNode, LeftOperand leftOperand) {
        rightOperandNode.addAttribute("name", leftOperand.getName());
        rightOperandNode.addAttribute("type", leftOperand.getType());
    }

    private void fillUserFilterNode(XMLNode userFilterNode, UserFilterDefinition userFilter) {
        userFilterNode.addAttribute("name", userFilter.getName());
        userFilterNode.addAttribute(USER_FILTER_ID, userFilter.getUserFilterId());
        userFilterNode.addAttribute("version", userFilter.getVersion());
        Map<String, Expression> inputs = userFilter.getInputs();
        this.createAndFillInputsNode(userFilterNode, inputs);
    }

    private XMLNode getBusinessDataDefinitionNode(BusinessDataDefinition businessDataDefinition) {
        Expression defaultValueExpression;
        XMLNode businessDataDefinitionNode = null;
        businessDataDefinitionNode = new XMLNode(BUSINESS_DATA_DEFINITION_NODE);
        businessDataDefinitionNode.addAttribute("name", businessDataDefinition.getName());
        businessDataDefinitionNode.addAttribute("className", businessDataDefinition.getClassName());
        businessDataDefinitionNode.addAttribute(BUSINESS_DATA_DEFINITION_IS_MULTIPLE, String.valueOf(businessDataDefinition.isMultiple()));
        if (businessDataDefinition.getDescription() != null) {
            businessDataDefinitionNode.addChild(DESCRIPTION, businessDataDefinition.getDescription());
        }
        if ((defaultValueExpression = businessDataDefinition.getDefaultValueExpression()) != null) {
            XMLNode defaultValueNode = new XMLNode(DEFAULT_VALUE_NODE);
            this.fillExpressionNode(defaultValueNode, defaultValueExpression, false);
            businessDataDefinitionNode.addChild(defaultValueNode);
        }
        return businessDataDefinitionNode;
    }

    private XMLNode getDataDefinitionNode(DataDefinition dataDefinition) {
        XMLNode dataDefinitionNode = null;
        if (dataDefinition instanceof XMLDataDefinition) {
            String element;
            dataDefinitionNode = new XMLNode(XML_DATA_DEFINITION_NODE);
            this.fillDataDefinitionNode(dataDefinitionNode, dataDefinition);
            XMLDataDefinition xmlData = (XMLDataDefinition)dataDefinition;
            String namespace = xmlData.getNamespace();
            if (namespace != null) {
                dataDefinitionNode.addChild(XML_DATA_DEFINITION_NAMESPACE, namespace);
            }
            if ((element = xmlData.getElement()) != null) {
                dataDefinitionNode.addChild(XML_DATA_DEFINITION_ELEMENT, element);
            }
        } else if (dataDefinition instanceof TextDataDefinition) {
            dataDefinitionNode = new XMLNode(TEXT_DATA_DEFINITION_NODE);
            dataDefinitionNode.addAttribute(TEXT_DATA_DEFINITION_LONG, String.valueOf(((TextDataDefinition)dataDefinition).isLongText()));
            this.fillDataDefinitionNode(dataDefinitionNode, dataDefinition);
        } else {
            dataDefinitionNode = new XMLNode(DATA_DEFINITION_NODE);
            this.fillDataDefinitionNode(dataDefinitionNode, dataDefinition);
        }
        return dataDefinitionNode;
    }

    private void fillDataDefinitionNode(XMLNode dataDefinitionNode, DataDefinition dataDefinition) {
        Expression defaultValueExpression;
        dataDefinitionNode.addAttribute("name", dataDefinition.getName());
        dataDefinitionNode.addAttribute("className", dataDefinition.getClassName());
        dataDefinitionNode.addAttribute(DATA_DEFINITION_TRANSIENT, String.valueOf(dataDefinition.isTransientData()));
        if (dataDefinition.getDescription() != null) {
            dataDefinitionNode.addChild(DESCRIPTION, dataDefinition.getDescription());
        }
        if ((defaultValueExpression = dataDefinition.getDefaultValueExpression()) != null) {
            XMLNode defaultValueNode = new XMLNode(DEFAULT_VALUE_NODE);
            this.fillExpressionNode(defaultValueNode, defaultValueExpression, false);
            dataDefinitionNode.addChild(defaultValueNode);
        }
    }

    private void fillDocumentDefinitionNode(XMLNode documentDefinitionNode, DocumentDefinition documentDefinition) {
        documentDefinitionNode.addAttribute("name", documentDefinition.getName());
        documentDefinitionNode.addAttribute(DOCUMENT_DEFINITION_MIME_TYPE, documentDefinition.getContentMimeType());
        if (documentDefinition.getFileName() != null) {
            documentDefinitionNode.addChild(DOCUMENT_DEFINITION_FILE_NAME, documentDefinition.getFileName());
        }
        if (documentDefinition.getDescription() != null) {
            documentDefinitionNode.addChild(DESCRIPTION, documentDefinition.getDescription());
        }
        if (documentDefinition.getUrl() != null) {
            documentDefinitionNode.addChild(DOCUMENT_DEFINITION_URL, documentDefinition.getUrl());
        }
        if (documentDefinition.getFile() != null) {
            documentDefinitionNode.addChild(DOCUMENT_DEFINITION_FILE, documentDefinition.getFile());
        }
    }

    private void fillDocumentListDefinitionNode(XMLNode documentListDefinitionNode, DocumentListDefinition documentListDefinition) {
        documentListDefinitionNode.addAttribute("name", documentListDefinition.getName());
        if (documentListDefinition.getDescription() != null) {
            documentListDefinitionNode.addChild(DESCRIPTION, documentListDefinition.getDescription());
        }
        if (documentListDefinition.getExpression() != null) {
            XMLNode value = new XMLNode(EXPRESSION_NODE);
            this.fillExpressionNode(value, documentListDefinition.getExpression(), false);
            documentListDefinitionNode.addChild(value);
        }
    }

    private void fillActorNode(XMLNode actorNode, ActorDefinition actor) {
        actorNode.addAttribute("name", actor.getName());
        if (actor.getDescription() != null) {
            actorNode.addChild(DESCRIPTION, actor.getDescription());
        }
    }

    private void fillInitiatorActorNode(XMLNode actorNode, ActorDefinition actor) {
        actorNode.addAttribute("name", actor.getName());
    }

    private void fillParameterNode(XMLNode parameterNode, ParameterDefinition parameter) {
        parameterNode.addAttribute("name", parameter.getName());
        parameterNode.addAttribute("type", parameter.getType());
        if (parameter.getDescription() != null) {
            parameterNode.addChild(DESCRIPTION, parameter.getDescription());
        }
    }

    private void fillGatewayNode(XMLNode gatewayNode, GatewayDefinition gateway) {
        this.fillFlowNode(gatewayNode, gateway);
        gatewayNode.addAttribute(GATEWAY_TYPE, gateway.getGatewayType().toString());
    }

    private void fillFlowNode(XMLNode node, FlowNodeDefinition flowNode) {
        XMLNode transitionNode;
        node.addAttribute(ID, String.valueOf(flowNode.getId()));
        node.addAttribute("name", flowNode.getName());
        node.addAttribute(DESCRIPTION, flowNode.getDescription());
        this.addExpressionNode(node, DISPLAY_NAME, flowNode.getDisplayName());
        this.addExpressionNode(node, DISPLAY_DESCRIPTION, flowNode.getDisplayDescription());
        this.addExpressionNode(node, DISPLAY_DESCRIPTION_AFTER_COMPLETION, flowNode.getDisplayDescriptionAfterCompletion());
        for (TransitionDefinition transition : flowNode.getIncomingTransitions()) {
            transitionNode = new XMLNode(INCOMING_TRANSITION);
            this.fillTransitionRefNode(transitionNode, transition);
            node.addChild(transitionNode);
        }
        for (TransitionDefinition transition : flowNode.getOutgoingTransitions()) {
            transitionNode = new XMLNode(OUTGOING_TRANSITION);
            this.fillTransitionRefNode(transitionNode, transition);
            node.addChild(transitionNode);
        }
        if (flowNode.getDefaultTransition() != null) {
            XMLNode defaultTransition = new XMLNode(DEFAULT_TRANSITION);
            this.fillTransitionRefNode(defaultTransition, flowNode.getDefaultTransition());
            node.addChild(defaultTransition);
        }
        for (ConnectorDefinition connector : flowNode.getConnectors()) {
            XMLNode connectorNode = new XMLNode(CONNECTOR_NODE);
            this.fillConnectorNode(connectorNode, connector);
            node.addChild(connectorNode);
        }
    }

    private void addExpressionNode(XMLNode parentNode, String expressionNodeName, Expression expression) {
        if (expression != null) {
            XMLNode xmlNode = new XMLNode(expressionNodeName);
            this.fillExpressionNode(xmlNode, expression, false);
            parentNode.addChild(xmlNode);
        }
    }

    private void fillTransitionRefNode(XMLNode transitionNode, TransitionDefinition transition) {
        transitionNode.addAttribute(IDREF, this.objectToId.get(transition));
    }

    private void fillExpressionNode(XMLNode expressionNode, Expression expression, boolean isCondition) {
        if (isCondition && !"java.lang.Boolean".equals(expression.getReturnType())) {
            throw new BonitaRuntimeException("The return type of the expression must be Boolean");
        }
        expressionNode.addAttribute(EXPRESSION_TYPE, expression.getExpressionType());
        expressionNode.addAttribute("name", expression.getName());
        expressionNode.addAttribute(EXPRESSION_RETURN_TYPE, expression.getReturnType());
        expressionNode.addAttribute(EXPRESSION_INTERPRETER, expression.getInterpreter());
        expressionNode.addChild(EXPRESSION_CONTENT, expression.getContent());
        for (Expression dependency : expression.getDependencies()) {
            XMLNode dependencyExpression = new XMLNode(EXPRESSION_NODE);
            this.fillExpressionNode(dependencyExpression, dependency, false);
            expressionNode.addChild(dependencyExpression);
        }
    }

    private void fillTransitionNode(XMLNode transitionNode, TransitionDefinition transition) {
        transitionNode.addAttribute("name", transition.getName());
        transitionNode.addAttribute(TRANSITION_SOURCE, String.valueOf(transition.getSource()));
        transitionNode.addAttribute(TRANSITION_TARGET, String.valueOf(transition.getTarget()));
        if (transition.getCondition() != null) {
            XMLNode condition = new XMLNode(TRANSITION_CONDITION);
            this.fillExpressionNode(condition, transition.getCondition(), true);
            transitionNode.addChild(condition);
        }
    }

    public static final class BEntry<K, V>
    implements Map.Entry<K, V> {
        private final K k;
        private V v;

        public BEntry(K k, V v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public K getKey() {
            return this.k;
        }

        @Override
        public V getValue() {
            return this.v;
        }

        @Override
        public V setValue(V value) {
            this.v = value;
            return this.v;
        }
    }
}

