/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.flownode.impl.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.bpm.ObjectSeeker;
import org.bonitasoft.engine.bpm.businessdata.BusinessDataDefinition;
import org.bonitasoft.engine.bpm.data.DataDefinition;
import org.bonitasoft.engine.bpm.flownode.ActivityDefinition;
import org.bonitasoft.engine.bpm.flownode.BoundaryEventDefinition;
import org.bonitasoft.engine.bpm.flownode.LoopCharacteristics;
import org.bonitasoft.engine.bpm.flownode.impl.internal.FlowNodeDefinitionImpl;
import org.bonitasoft.engine.operation.Operation;

public abstract class ActivityDefinitionImpl
extends FlowNodeDefinitionImpl
implements ActivityDefinition {
    private static final long serialVersionUID = 5575175860474559979L;
    private final List<DataDefinition> dataDefinitions = new ArrayList<DataDefinition>();
    private final List<BusinessDataDefinition> businessDataDefinitions;
    private final List<Operation> operations = new ArrayList<Operation>();
    private LoopCharacteristics loopCharacteristics;
    private final List<BoundaryEventDefinition> boundaryEventDefinitions = new ArrayList<BoundaryEventDefinition>(1);

    public ActivityDefinitionImpl(long id, String name) {
        super(id, name);
        this.businessDataDefinitions = new ArrayList<BusinessDataDefinition>(3);
    }

    public ActivityDefinitionImpl(String name) {
        super(name);
        this.businessDataDefinitions = new ArrayList<BusinessDataDefinition>(3);
    }

    @Override
    public List<DataDefinition> getDataDefinitions() {
        return this.dataDefinitions;
    }

    public void addDataDefinition(DataDefinition dataDefinition) {
        this.dataDefinitions.add(dataDefinition);
    }

    @Override
    public List<Operation> getOperations() {
        return this.operations;
    }

    public void addOperation(Operation operation) {
        this.operations.add(operation);
    }

    @Override
    public List<BoundaryEventDefinition> getBoundaryEventDefinitions() {
        return Collections.unmodifiableList(this.boundaryEventDefinitions);
    }

    public void addBoundaryEventDefinition(BoundaryEventDefinition boundaryEventDefinition) {
        this.boundaryEventDefinitions.add(boundaryEventDefinition);
    }

    @Override
    public LoopCharacteristics getLoopCharacteristics() {
        return this.loopCharacteristics;
    }

    public void setLoopCharacteristics(LoopCharacteristics loopCharacteristics) {
        this.loopCharacteristics = loopCharacteristics;
    }

    @Override
    public List<BusinessDataDefinition> getBusinessDataDefinitions() {
        return this.businessDataDefinitions;
    }

    public void addBusinessDataDefinition(BusinessDataDefinition businessDataDefinition) {
        this.businessDataDefinitions.add(businessDataDefinition);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.boundaryEventDefinitions == null ? 0 : this.boundaryEventDefinitions.hashCode());
        result = 31 * result + (this.businessDataDefinitions == null ? 0 : this.businessDataDefinitions.hashCode());
        result = 31 * result + (this.dataDefinitions == null ? 0 : this.dataDefinitions.hashCode());
        result = 31 * result + (this.loopCharacteristics == null ? 0 : this.loopCharacteristics.hashCode());
        result = 31 * result + (this.operations == null ? 0 : this.operations.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActivityDefinitionImpl other = (ActivityDefinitionImpl)obj;
        if (this.boundaryEventDefinitions == null ? other.boundaryEventDefinitions != null : !this.boundaryEventDefinitions.equals(other.boundaryEventDefinitions)) {
            return false;
        }
        if (this.businessDataDefinitions == null ? other.businessDataDefinitions != null : !this.businessDataDefinitions.equals(other.businessDataDefinitions)) {
            return false;
        }
        if (this.dataDefinitions == null ? other.dataDefinitions != null : !this.dataDefinitions.equals(other.dataDefinitions)) {
            return false;
        }
        if (this.loopCharacteristics == null ? other.loopCharacteristics != null : !this.loopCharacteristics.equals(other.loopCharacteristics)) {
            return false;
        }
        return !(this.operations == null ? other.operations != null : !this.operations.equals(other.operations));
    }

    @Override
    public BusinessDataDefinition getBusinessDataDefinition(String name) {
        return ObjectSeeker.getNamedElement(this.businessDataDefinitions, name);
    }

    @Override
    public DataDefinition getDataDefinition(String name) {
        return ObjectSeeker.getNamedElement(this.dataDefinitions, name);
    }
}

