/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.process;

import java.util.HashMap;
import java.util.Map;

public enum ProcessInstanceState {
    INITIALIZING(0),
    STARTED(1),
    SUSPENDED(2),
    CANCELLED(3),
    ABORTED(4),
    COMPLETING(5),
    COMPLETED(6),
    ERROR(7),
    ABORTING(11);

    private static Map<Integer, ProcessInstanceState> map;
    private int id;

    private ProcessInstanceState(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static ProcessInstanceState getFromId(int id) {
        if (!map.containsKey(id)) {
            map.put(id, ProcessInstanceState.fromIdToProcessInstanceState(id));
        }
        return map.get(id);
    }

    private static ProcessInstanceState fromIdToProcessInstanceState(int id) {
        for (ProcessInstanceState state : ProcessInstanceState.values()) {
            if (id != state.getId()) continue;
            return state;
        }
        return null;
    }

    static {
        map = new HashMap<Integer, ProcessInstanceState>(11);
    }
}

